/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.updatedata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class RefreshInvBillMasterId
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RefreshInvBillMasterId.class);
    private static final String BILL_TYPE = "billtype";
    private static final Long DEF_VALUE = 0L;
    private static final String SPLIT = ".";
    private static final String BILL_ENTRY = "billentry";
    private static final String MATERIAL = "material";
    private static final String MATERIAL_MASTER_ID = "materialmasterid";
    private static final String AFTER_ENTITY = "afterentity";
    private static final String SUFFIX = "1";
    private static final String MASTER_ID = "masterid";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        logger.info("RefreshInvBillMasterId==============\u5f00\u59cb\u5237\u65b0\u4e1a\u52a1\u7b56\u7565\u4e3b\u5185\u7801\u5b57\u6bb5");
        ArrayList<String> doubleEntryBillType = new ArrayList<String>(8);
        doubleEntryBillType.add("im_adjustbill");
        doubleEntryBillType.add("im_assembbill");
        doubleEntryBillType.add("im_disassemblebill");
        DynamicObject[] dataEntities = e.getDataEntities();
        String billType = dataEntities[0].getDynamicObject(BILL_TYPE).getString("number");
        if (StringUtils.isEmpty((String)billType)) {
            logger.info("RefreshInvBillMasterId==============billType is empty");
            return;
        }
        ArrayList<DynamicObject> invBills = new ArrayList<DynamicObject>(16);
        HashSet<Object> billIds = new HashSet<Object>(16);
        QFilter filter = new QFilter("billentry.material", "!=", (Object)DEF_VALUE);
        filter.and("billentry.materialmasterid", "=", (Object)DEF_VALUE);
        String selectField = doubleEntryBillType.contains(billType) ? "id, billno, billentry, billentry.material, billentry.materialmasterid, afterentity, afterentity.material1, afterentity.materialmasterid1" : "id, billno, billentry, billentry.material, billentry.materialmasterid";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)billType, (String)selectField, (QFilter[])filter.toArray(), (String)"");
        this.addBills(billIds, invBills, bills);
        if (doubleEntryBillType.contains(billType)) {
            QFilter filter1 = new QFilter("billentry.afterentity.material1", "!=", (Object)DEF_VALUE);
            filter1.and("billentry.afterentity.materialmasterid1", "=", (Object)DEF_VALUE);
            DynamicObject[] subBills = BusinessDataServiceHelper.load((String)billType, (String)selectField, (QFilter[])filter1.toArray(), (String)"");
            this.addBills(billIds, invBills, subBills);
        }
        if (invBills.isEmpty()) {
            logger.info("RefreshInvBillMasterId\uff1a\u5355\u636e\u7c7b\u578b\uff1a " + billType + "\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u540c\u6b65\u7684\u5355\u636e\u3002\u8fc7\u6ee4\u6761\u4ef6\uff1a" + filter.toString());
            return;
        }
        logger.info("RefreshInvBillMasterId\uff1a\u5355\u636e\u7c7b\u578b\uff1a " + billType + "\uff0c\u67e5\u8be2\u5230\u9700\u8981\u540c\u6b65\u7684\u5355\u636e" + bills.length + "\u6761\u3002\u8fc7\u6ee4\u6761\u4ef6\uff1a" + filter.toString());
        this.updateBills(billType, invBills);
        SaveServiceHelper.save((DynamicObject[])invBills.toArray(new DynamicObject[0]));
        logger.info("RefreshInvBillMasterId==============\u5237\u65b0\u4e1a\u52a1\u7b56\u7565\u4e3b\u5185\u7801\u5b57\u6bb5\u6210\u529f");
    }

    private void addBills(Set<Object> billIds, List<DynamicObject> invBills, DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return;
        }
        for (DynamicObject bill : bills) {
            String billId = bill.getString("id");
            if (billIds.contains(billId)) continue;
            billIds.add(billId);
            invBills.add(bill);
        }
    }

    private void updateBills(String billType, List<DynamicObject> bills) {
        HashSet<String> billNos = new HashSet<String>(bills.size());
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection(BILL_ENTRY);
            if (billEntry == null || billEntry.isEmpty()) {
                return;
            }
            this.updateEntry(billEntry, MATERIAL, MATERIAL_MASTER_ID);
            if ("im_adjustbill".equals(billType) || "im_assembbill".equals(billType) || "im_disassemblebill".equals(billType)) {
                for (DynamicObject entry : billEntry) {
                    DynamicObjectCollection subEntity = entry.getDynamicObjectCollection(AFTER_ENTITY);
                    if (subEntity == null || subEntity.isEmpty()) continue;
                    this.updateEntry(subEntity, "material1", "materialmasterid1");
                }
            }
            billNos.add(bill.getString("billno"));
        }
        logger.info("RefreshInvBillMasterId\u66f4\u65b0\u5355\u636e:" + billNos);
    }

    private void updateEntry(DynamicObjectCollection entrys, String materialKey, String masterIdKey) {
        for (DynamicObject entry : entrys) {
            DynamicObject material;
            DynamicObject materialInfo = entry.getDynamicObject(materialKey);
            if (materialInfo == null || (material = materialInfo.getDynamicObject(MASTER_ID)) == null) continue;
            Long masterId = material.getLong("id");
            entry.set(masterIdKey, (Object)masterId);
        }
    }
}

