/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.acc;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class InitBillCurrencyValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"InitBillCurrencyValidator", (String)"validate");){
            ExtendedDataEntity[] dataEntities = this.dataEntities;
            if (dataEntities == null || dataEntities.length == 0) {
                return;
            }
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject initBill = dataEntity.getDataEntity();
                DynamicObject currency = initBill.getDynamicObject("currency");
                if (currency != null) continue;
                this.validateEntryPrice(dataEntity);
            }
        }
    }

    private void validateEntryPrice(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        DynamicObjectCollection billEntry = initBill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billEntry) {
            BigDecimal price = entry.getBigDecimal("price");
            if (BigDecimal.ZERO.compareTo(price) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5e93\u5b58\u5355\u5206\u5f55\u5355\u4ef7\u4e0d\u4e3a0, \u8bf7\u7ef4\u62a4\u672c\u4f4d\u5e01\u5b57\u6bb5\u3002", (String)"InitBillCurrencyValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            break;
        }
    }
}

