/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.acc;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.WarehouseHelper;

public class InitBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"InitBillUnAuditValidator", (String)"validate");){
            ArrayList<Object> billIds = new ArrayList<Object>(this.dataEntities.length);
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject invBill = entity.getDataEntity();
                billIds.add(invBill.getPkValue());
                for (DynamicObject item : invBill.getDynamicObjectCollection("billentry")) {
                    billIds.add(item.getPkValue());
                    DynamicObject orgDyc = invBill.getDynamicObject("org");
                    DynamicObject warehouseDyc = item.getDynamicObject("warehouse");
                    if (orgDyc == null || warehouseDyc == null || !WarehouseHelper.isFinishInit((Long)((Long)orgDyc.getPkValue()), (Long)Long.valueOf(warehouseDyc.getPkValue().toString()))) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u521d\u59cb\u5e93\u5b58\u5355\u4e0d\u53ef\u53cd\u5ba1\u6838\u3002", (String)"InitBillUnAuditValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), warehouseDyc.getString("name"));
                    this.addMessage(entity, msg, ErrorLevel.Error);
                }
            }
            if (MetaDataHelper.isBizAppExistCal()) {
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"InitBillCheckService", (String)"InitBillUnauditCheck", (Object[])new Object[]{billIds});
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObject invBill = entity.getDataEntity();
                    Long billId = (Long)invBill.getPkValue();
                    if (!resultMap.containsKey(billId)) continue;
                    String msg = String.format((String)resultMap.get(billId), new Object[0]);
                    this.addMessage(entity, msg, ErrorLevel.Error);
                }
            }
        }
    }
}

