/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.acc.close;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.scmc.im.business.helper.acct.CloseAcctHelper;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class CloseDateValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("inwarehouse");
        fields.add("outwarehouse");
        fields.add("inlocation");
        fields.add("outlocation");
        fields.add("inorg");
        fields.add("outorg");
        return fields;
    }

    private String getMessageFormat() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u4ed3\u5e93\u201c%2$s\u201d\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u7b49\u4e8e\u5df2\u5173\u8d26\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u80fd%5$s\u5f53\u524d\u53ca\u4ee5\u524d\u8bb0\u8d26\u65e5\u671f\u5355\u636e\uff0c\u8bf7\u5148\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u6216\u8005\u5148\u53cd\u5173\u8d26\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CloseDateValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"CloseDateValidator", (String)"validate");){
            if (CommonUtils.isNull((Object)this.dataEntities) || !InvBalanceConst.getBalBillList().contains(this.getEntityKey())) {
                return;
            }
            boolean updateEnable = "submit".equals(this.getOperateKey());
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject bill = entity.getDataEntity();
                String billNo = bill.getString("billno");
                if (!"unaudit".equals(this.getOperateKey()) && !"unsubmit".equals(this.getOperateKey())) {
                    CloseDateHelper.initBookDate((String)this.entityKey, (DynamicObject)bill);
                }
                Date bookDate = bill.getDate("bookdate");
                Date bizDate = bill.getDate("biztime");
                if (bizDate == null || bookDate == null || !(bookDate = DateUtils.getDate((Date)bookDate)).before(bizDate = DateUtils.getDate((Date)bizDate))) continue;
                String content = String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u201c%2$s\u201d\uff0c\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u4e1a\u52a1\u65e5\u671f\u201c%4$s\u201d\uff0c%5$s\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"CloseDateValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), this.getOperationName(), billNo, DateUtils.getDateString((Date)bookDate), DateUtils.getDateString((Date)bizDate), this.getOperationName());
                this.addMessage(entity, content, ErrorLevel.Error);
            }
            HashMap<String, HashMap<Integer, Date>> dateIndexMap = new HashMap<String, HashMap<Integer, Date>>(16);
            HashMap<Long, Set<String>> billOrgWareHouseMap = new HashMap<Long, Set<String>>();
            HashMap<Long, Set<Long>> orgWarehouseMap = this.getAllOrgWarehouseMap(dateIndexMap, billOrgWareHouseMap);
            if (orgWarehouseMap.isEmpty()) {
                return;
            }
            Map resultMap = CloseAcctHelper.getCloseDateMap(orgWarehouseMap);
            boolean closeNextDayEnable = SupplyChainParameterHelper.getEnableScmParam((String)"INV0008");
            boolean dateEqualsEnable = SupplyChainParameterHelper.getEnableScmParam((String)"INV0004");
            HashMap<String, Date> orgWarehouseCloseDates = new HashMap<String, Date>();
            this.addCheckMessage(dateIndexMap, resultMap, closeNextDayEnable, orgWarehouseCloseDates, updateEnable);
            if (!orgWarehouseCloseDates.isEmpty() && updateEnable) {
                this.updateDate(billOrgWareHouseMap, dateEqualsEnable, orgWarehouseCloseDates);
            }
        }
    }

    private void updateDate(HashMap<Long, Set<String>> billOrgWareHouseMap, boolean dateEqualsEnable, Map<String, Date> orgWarehouseCloseDates) {
        for (ExtendedDataEntity entity : this.dataEntities) {
            Long billId = (Long)entity.getDataEntity().getPkValue();
            Set<String> billOrgWarehouse = billOrgWareHouseMap.get(billId);
            Date bookDate = (Date)entity.getValue("bookdate");
            Date lastCloseDate = null;
            if (billOrgWarehouse.isEmpty()) continue;
            for (String key : billOrgWarehouse) {
                if (!orgWarehouseCloseDates.containsKey(key) || lastCloseDate != null && orgWarehouseCloseDates.get(key).compareTo(lastCloseDate) <= 0) continue;
                lastCloseDate = orgWarehouseCloseDates.get(key);
            }
            if (bookDate == null || lastCloseDate == null || lastCloseDate.compareTo(bookDate) < 0) continue;
            Date time = DateUtils.addOneDay((Date)lastCloseDate);
            entity.setValue("bookdate", (Object)time);
            if (!dateEqualsEnable) continue;
            entity.setValue("biztime", (Object)time);
        }
    }

    private HashMap<Long, Set<Long>> getAllOrgWarehouseMap(HashMap<String, HashMap<Integer, Date>> dateIndexMap, HashMap<Long, Set<String>> billOrgWareHouseMap) {
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>(16);
        boolean isAssBill = this.getEntityKey().equals("im_assembbill");
        boolean isAdjBill = this.getEntityKey().equals("im_adjustbill");
        boolean isDisBill = this.getEntityKey().equals("im_disassemblebill");
        for (ExtendedDataEntity entity : this.dataEntities) {
            Date bookDate;
            DynamicObject invScheme;
            BillEntityType dataEntityType;
            IDataEntityProperty property;
            DynamicObject bill = entity.getDataEntity();
            if (null == bill || this.isSkip(bill) || (property = (dataEntityType = (BillEntityType)bill.getDataEntityType()).findProperty("invscheme")) != null && ((invScheme = bill.getDynamicObject("invscheme")) == null || invScheme.getBoolean("isnotupdate")) || null == (bookDate = bill.getDate("bookdate"))) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            DynamicObject orgDyc = bill.getDynamicObject("org");
            String entityName = bill.getDataEntityType().getName();
            for (DynamicObject item : entry) {
                DynamicObject org;
                DynamicObject outWarehouseDyc;
                DynamicObject warehouseDyc = item.getDynamicObject("warehouse");
                this.getAllOrgWarehouse(entity, orgWarehouseMap, dateIndexMap, billOrgWareHouseMap, orgDyc, warehouseDyc, bookDate);
                if ("im_transdirbill".equals(entityName)) {
                    DynamicObject outOrg = bill.getDynamicObject("outorg");
                    outWarehouseDyc = item.getDynamicObject("outwarehouse");
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, dateIndexMap, billOrgWareHouseMap, outOrg, outWarehouseDyc, bookDate);
                }
                if ("im_transoutbill".equals(entityName)) {
                    this.dealOrgAndWareHouse(dateIndexMap, billOrgWareHouseMap, orgWarehouseMap, entity, bill, bookDate, item, "org", "inwarehouse");
                    this.dealOrgAndWareHouse(dateIndexMap, billOrgWareHouseMap, orgWarehouseMap, entity, bill, bookDate, item, "inorg", "inwarehouse");
                }
                if ("im_transinbill".equals(entityName)) {
                    this.dealOrgAndWareHouse(dateIndexMap, billOrgWareHouseMap, orgWarehouseMap, entity, bill, bookDate, item, "org", "outwarehouse");
                    this.dealOrgAndWareHouse(dateIndexMap, billOrgWareHouseMap, orgWarehouseMap, entity, bill, bookDate, item, "outorg", "outwarehouse");
                }
                if ("im_purinbill".equals(entityName) || "im_mdc_omcmplinbill".equals(entityName) || "im_mdc_ominbill".equals(entityName) || "im_ospurinbill".equals(entityName)) {
                    org = bill.getDynamicObject("org");
                    outWarehouseDyc = item.getDynamicObject("outwarehouse");
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, dateIndexMap, billOrgWareHouseMap, org, outWarehouseDyc, bookDate);
                }
                if ("im_saloutbill".equals(entityName)) {
                    org = bill.getDynamicObject("org");
                    outWarehouseDyc = item.getDynamicObject("inwarehouse");
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, dateIndexMap, billOrgWareHouseMap, org, outWarehouseDyc, bookDate);
                }
                if ("im_invinspectbill".equals(entityName)) {
                    this.dealOrgAndWareHouse(dateIndexMap, billOrgWareHouseMap, orgWarehouseMap, entity, bill, bookDate, item, "org", "outwarehouse");
                }
                if (!isAssBill && !isAdjBill && !isDisBill) continue;
                DynamicObjectCollection afterEntryDycs = item.getDynamicObjectCollection("afterentity");
                for (DynamicObject afterDyc : afterEntryDycs) {
                    DynamicObject afterWarehouseDyc = afterDyc.getDynamicObject("warehouse1");
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, dateIndexMap, billOrgWareHouseMap, orgDyc, afterWarehouseDyc, bookDate);
                }
            }
        }
        return orgWarehouseMap;
    }

    private void dealOrgAndWareHouse(HashMap<String, HashMap<Integer, Date>> dateIndexMap, HashMap<Long, Set<String>> billOrgWareHoaseMap, HashMap<Long, Set<Long>> orgWarehouseMap, ExtendedDataEntity entity, DynamicObject bill, Date bookDate, DynamicObject item, String orgField, String warehouseField) {
        DynamicObject outOrg = bill.getDynamicObject(orgField);
        DynamicObject outWarehouseDyc = item.getDynamicObject(warehouseField);
        this.getAllOrgWarehouse(entity, orgWarehouseMap, dateIndexMap, billOrgWareHoaseMap, outOrg, outWarehouseDyc, bookDate);
    }

    private boolean isSkip(DynamicObject invBill) {
        boolean isExist = MetaDataHelper.isExistField((IDataEntityType)invBill.getDataEntityType(), (String)"isinitbill");
        boolean check = isExist && invBill.getBoolean("isinitbill");
        boolean initCheck = "im_initbill".equals(invBill.getDataEntityType().getName());
        return check || initCheck;
    }

    private void getAllOrgWarehouse(ExtendedDataEntity entity, HashMap<Long, Set<Long>> orgWarehouseMap, HashMap<String, HashMap<Integer, Date>> dateIndexMap, HashMap<Long, Set<String>> billOrgWareHouseMap, DynamicObject org, DynamicObject warehouse, Date bookDate) {
        if (CommonUtils.isNull((Object)org) || CommonUtils.isNull((Object)warehouse)) {
            return;
        }
        Long billId = (Long)entity.getDataEntity().getPkValue();
        billOrgWareHouseMap.computeIfAbsent(billId, k -> new HashSet());
        orgWarehouseMap.computeIfAbsent((Long)org.getPkValue(), k -> new HashSet());
        orgWarehouseMap.get(org.getPkValue()).add((Long)warehouse.getPkValue());
        StringBuilder orgWareHBuilder = new StringBuilder();
        orgWareHBuilder.append(org.getPkValue());
        orgWareHBuilder.append(",");
        orgWareHBuilder.append(warehouse.getPkValue());
        String orgWarehouseKey = orgWareHBuilder.toString();
        dateIndexMap.computeIfAbsent(orgWarehouseKey, k -> new HashMap(16));
        HashMap<Integer, Date> dateSetHashMap = dateIndexMap.get(orgWarehouseKey);
        dateSetHashMap.put(entity.getDataEntityIndex(), bookDate);
        billOrgWareHouseMap.get(billId).add(orgWarehouseKey);
    }

    private void addCheckMessage(HashMap<String, HashMap<Integer, Date>> dateIndexMap, Map<String, DynamicObject> resultMap, boolean enable, Map<String, Date> orgWarehouseCloseDates, boolean updateEnable) {
        for (Map.Entry<String, DynamicObject> item : resultMap.entrySet()) {
            HashMap<Integer, Date> dateIndex = dateIndexMap.get(item.getKey());
            for (Map.Entry<Integer, Date> indexDate : dateIndex.entrySet()) {
                Date closeDate;
                Date indexDateVal = indexDate.getValue();
                if (indexDateVal.compareTo(closeDate = item.getValue().getDate("closedate")) > 0) continue;
                if (enable && updateEnable) {
                    orgWarehouseCloseDates.put(item.getKey(), closeDate);
                    continue;
                }
                String orgName = item.getValue().getDynamicObject("org").getString("name");
                String warehouseName = item.getValue().getDynamicObject("warehouse").getString("name");
                this.addMessage(this.dataEntities[indexDate.getKey()], String.format(this.getMessageFormat(), orgName, warehouseName, DateUtils.getDateString((Date)indexDateVal), DateUtils.getDateString((Date)item.getValue().getDate("closedate")), this.getOperationName() == null ? this.getOperationName() : this.getOperationName().trim()), ErrorLevel.Error);
            }
        }
    }
}

