/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.adjustbill;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.scmc.im.utils.DateUtils;

public class AdjustBillCalCloseCheckValidator
extends AbstractValidator {
    protected static final Log logger = LogFactory.getLog(AdjustBillCalCloseCheckValidator.class);
    private Set<Long> ownerIds = new HashSet<Long>(16);
    private Map<Long, String> ownerInfo = new HashMap<Long, String>(16);
    private Map<Long, Object[]> startDateMap = new HashMap<Long, Object[]>(16);
    private Map<Long, Object[]> closeDateMap = new HashMap<Long, Object[]>(16);
    private Map<Long, Set<Long>> billOwners = new HashMap<Long, Set<Long>>(16);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"AdjustBillCalCloseCheckValidator", (String)"validate");){
            if (!MetaDataHelper.isBizAppExistCal()) {
                return;
            }
            boolean updateEnable = "submit".equals(this.getOperateKey());
            this.getAllOwnerIds();
            this.getCloseDate();
            boolean closeNextDayEnable = SupplyChainParameterHelper.getEnableScmParam((String)"INV0008");
            boolean dateEqualsEnable = SupplyChainParameterHelper.getEnableScmParam((String)"INV0004");
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject invBill = entity.getDataEntity();
                if (!"unaudit".equals(this.getOperateKey()) && !"unsubmit".equals(this.getOperateKey())) {
                    CloseDateHelper.initBookDate((String)this.entityKey, (DynamicObject)invBill);
                }
                Date bookDate = invBill.getDate("bookdate");
                bookDate = DateUtils.getDayStartTime((Date)bookDate);
                for (Long id : this.ownerIds) {
                    if (!this.startDateMap.isEmpty()) {
                        Object[] startDateValues = this.startDateMap.get(id);
                        this.isBeforeStartDate(entity, bookDate, startDateValues);
                    }
                    if (this.closeDateMap.isEmpty()) continue;
                    if (closeNextDayEnable && updateEnable) {
                        this.updateDate(entity, dateEqualsEnable);
                        continue;
                    }
                    Object[] closeDateValues = this.closeDateMap.get(id);
                    this.isAfterCloseDate(entity, bookDate, closeDateValues, id);
                }
            }
        }
    }

    private void updateDate(ExtendedDataEntity entity, boolean dateEqualsEnable) {
        Set<Long> owners = this.billOwners.get((Long)entity.getBillPkId());
        Date lastCloseDate = null;
        for (Long owner : owners) {
            Date closeDate;
            Object[] objects = this.closeDateMap.get(owner);
            if (objects == null || (closeDate = (Date)objects[0]) == null || lastCloseDate != null && closeDate.compareTo(lastCloseDate) <= 0) continue;
            lastCloseDate = closeDate;
        }
        Date bookDate = (Date)entity.getValue("bookdate");
        if (bookDate != null && lastCloseDate != null && lastCloseDate.compareTo(bookDate) >= 0) {
            Date time = DateUtils.addOneDay((Date)lastCloseDate);
            entity.setValue("bookdate", (Object)time);
            if (dateEqualsEnable) {
                entity.setValue("biztime", (Object)time);
            }
        }
    }

    private void getCloseDate() {
        try {
            Map ownerCloseDate = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCloseService", (String)"getOwnerCloseDate", (Object[])new Object[]{this.ownerIds});
            this.startDateMap = (Map)ownerCloseDate.get("startDate");
            this.closeDateMap = (Map)ownerCloseDate.get("closeDate");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5b58\u8d27\u6838\u7b97\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloseDateHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private void getAllOwnerIds() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject invBill = entity.getDataEntity();
            DynamicObjectCollection invBillEntryList = invBill.getDynamicObjectCollection("billentry");
            HashSet<Long> owners = new HashSet<Long>();
            for (DynamicObject entry : invBillEntryList) {
                DynamicObject owner = entry.getDynamicObject("owner");
                if (owner == null) continue;
                long ownerId = owner.getLong("id");
                String ownerNum = owner.getString("number");
                String ownerName = owner.getString("name");
                this.ownerIds.add(ownerId);
                this.ownerInfo.put(ownerId, ownerNum + "." + ownerName);
                owners.add(ownerId);
            }
            this.billOwners.put((Long)entity.getBillPkId(), owners);
        }
    }

    private void isBeforeStartDate(ExtendedDataEntity entity, Date bookDate, Object[] startDateValues) {
        if (startDateValues == null || startDateValues.length <= 0) {
            return;
        }
        Date startDate = (Date)startDateValues[0];
        if (bookDate.compareTo(startDate) < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u3010%1s\u3011\u5c0f\u4e8e\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8d26\u7c3f\u7f16\u7801\u3010%2s\u3011\u540d\u79f0\u3010%3s\u3011\u7684\u6838\u7b97\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3010%4s\u3011", DateUtils.getDateString((Date)bookDate), startDateValues[1], startDateValues[2], DateUtils.getDateString((Date)startDate)));
            }
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u201c%1s\u201d\u5c0f\u4e8e\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8d26\u7c3f\uff08\u7f16\u7801\u201c%2s\u201d\uff0c\u540d\u79f0\u201c%3s\u201d\uff09\u7684\u6838\u7b97\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%4s\u201d\u3002", (String)"AdjustBillCalCloseCheckValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), DateUtils.getDateString((Date)bookDate), startDateValues[1], startDateValues[2], DateUtils.getDateString((Date)startDate)));
        }
    }

    private void isAfterCloseDate(ExtendedDataEntity entity, Date bookDate, Object[] closeDateValues, Long ownerId) {
        if (closeDateValues == null || closeDateValues.length <= 0) {
            return;
        }
        Date closeDate = (Date)closeDateValues[0];
        if (bookDate.compareTo(closeDate) <= 0) {
            String ownerNumAndName = this.ownerInfo.get(ownerId);
            String[] ownerNumName = ownerNumAndName.split("\\.");
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u3010%1$s\u3011\u5c0f\u4e8e\u7b49\u4e8e\u8d27\u4e3b\u7f16\u7801\u3010%2$s\u3011\u540d\u79f0\u3010%3$s\u3011\u7684\u6838\u7b97\u5173\u8d26\u65e5\u671f\u3010%4$s\u3011\uff0c\u4e0d\u80fd%5$s\u5f53\u524d\u53ca\u4ee5\u524d\u8bb0\u8d26\u65e5\u671f\u5355\u636e\u3002", DateUtils.getDateString((Date)bookDate), ownerNumName[0], ownerNumName[1], DateUtils.getDateString((Date)closeDate), this.getOperationName()));
            }
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u5c0f\u4e8e\u7b49\u4e8e\u8d27\u4e3b\uff08\u7f16\u7801\u201c%2$s\u201d\uff0c\u540d\u79f0\u201c%3$s\u201d\uff09\u7684\u6838\u7b97\u5173\u8d26\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u80fd%5$s\u5f53\u524d\u53ca\u4ee5\u524d\u8bb0\u8d26\u65e5\u671f\u5355\u636e\uff0c\u8bf7\u5148\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u6216\u8005\u5148\u53cd\u5173\u8d26\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustBillCalCloseCheckValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), DateUtils.getDateString((Date)bookDate), ownerNumName[0], ownerNumName[1], DateUtils.getDateString((Date)closeDate), this.getOperationName()));
        }
    }
}

