/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.adjustbill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.AdjustBillSubmitHelper;
import kd.scmc.im.consts.AdjustBillConst;

public class AdjustBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bizType = entity.getDataEntity().getDynamicObject("biztype");
            if (bizType == null) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a", (String)"AdjustBillSubmitValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            this.conmmonValidate(entity);
            Long bizTypeId = (Long)bizType.getPkValue();
            if (AdjustBillConst.BIZTYPE_MATERIALADJUST.equals(bizTypeId)) {
                this.validateByMaterialAdjust(entity);
                continue;
            }
            if (AdjustBillConst.BIZTYPE_LOTADJUST.equals(bizTypeId)) {
                this.validateByLotAdjust(entity);
                continue;
            }
            if (AdjustBillConst.BIZTYPE_STATUSADJUST.equals(bizTypeId)) {
                this.validateByStatusAdjust(entity);
                continue;
            }
            if (AdjustBillConst.BIZTYPE_SNADJUST.equals(bizTypeId)) {
                this.validateBySnAdjust(entity);
                continue;
            }
            if (AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) {
                this.validateByUnitAdjust(entity);
                continue;
            }
            if (!AdjustBillConst.BIZTYPE_INSPECTADJUST.equals(bizTypeId)) continue;
            this.validateByInspectAdjust(entity);
        }
    }

    private void validateByInspectAdjust(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
            if (afterEntrys.size() > 1) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5728\u7269\u6599\u8f6c\u6362\u540e\uff0c\u4e0d\u5141\u8bb8\u6709\u591a\u6761\u3002", (String)"AdjustBillSubmitValidator_26", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
                continue;
            }
            if (afterEntrys.isEmpty()) continue;
            DynamicObject afterEntry = (DynamicObject)afterEntrys.get(0);
            boolean hasChange = AdjustBillSubmitHelper.hasChange((DynamicObject)entry, (DynamicObject)afterEntry, (String[])new String[]{"lotnumber", "producedate", "expirydate", "warehouse", "location", "invstatus"});
            if (hasChange) continue;
            this.addMessage(entity, ResManager.loadKDString((String)"\u8f6c\u6362\u540e\u884c\u53f7\u4e3a{0}\u7684\u6240\u6709\u7ef4\u5ea6\u4e0e\u8f6c\u6362\u524d\u5168\u90e8\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustBillSubmitValidator_25", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
        }
    }

    private void conmmonValidate(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        MainEntityType dataEntityType = (MainEntityType)bill.getDataEntityType();
        String beforeEntryName = dataEntityType.findProperty("billentry").getDisplayName().getLocaleValue();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
            if (afterEntrys == null || afterEntrys.size() == 0) continue;
            for (int j = 0; j < afterEntrys.size(); ++j) {
                DynamicObject afterEntry = (DynamicObject)afterEntrys.get(j);
                boolean hasChange = AdjustBillSubmitHelper.hasChange((DynamicObject)entry, (DynamicObject)afterEntry, (String[])new String[]{"keepertype", "keeper", "ownertype", "owner"});
                if (!hasChange) continue;
                this.addMessage(entity, ResManager.loadKDString((String)"{0}\u7b2c{1}\u884c\u7684\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b\u3001\u51fa\u5e93\u5e93\u5b58\u72b6\u6001\u3001\u51fa\u5e93\u8d27\u4e3b\u7c7b\u578b\u3001\u51fa\u5e93\u8d27\u4e3b\u3001\u51fa\u5e93\u4fdd\u7ba1\u8005\u7c7b\u578b\u3001\u51fa\u5e93\u4fdd\u7ba1\u8005\uff0c\u4e0e\u8f6c\u6362\u540e\u4e0d\u4e00\u81f4\u3002", (String)"AdjustBillSubmitValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[]{beforeEntryName, i + 1}), ErrorLevel.Error);
            }
        }
    }

    private void validateByMaterialAdjust(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
            for (int j = 0; j < afterEntrys.size(); ++j) {
                DynamicObject afterEntry = (DynamicObject)afterEntrys.get(j);
                DynamicObject subMaterial = afterEntry.getDynamicObject("material1");
                if (!AdjustBillSubmitHelper.compareTo((DynamicObject)material, (DynamicObject)subMaterial)) continue;
                this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u7684\u7269\u6599\u5728\u8f6c\u6362\u524d\u540e\u5e94\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustBillSubmitValidator_28", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
            }
        }
    }

    private void validateByStatusAdjust(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
            if (afterEntrys.size() > 1) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5728\u975e\u6279\u6b21\u7269\u6599\u8f6c\u6362\u540e\uff0c\u4e0d\u5141\u8bb8\u6709\u591a\u6761\u3002", (String)"AdjustBillSubmitValidator_27", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
                continue;
            }
            for (int j = 0; j < afterEntrys.size(); ++j) {
                DynamicObject afterEntry = (DynamicObject)afterEntrys.get(j);
                boolean hasChange = AdjustBillSubmitHelper.hasChange((DynamicObject)entry, (DynamicObject)afterEntry, (String[])new String[]{"invstatus", "invtype"});
                if (hasChange) continue;
                this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u7684\u5e93\u5b58\u72b6\u6001\u548c\u5e93\u5b58\u7c7b\u578b\u5728\u8f6c\u6362\u524d\u540e\u5e94\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustBillSubmitValidator_29", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
            }
        }
    }

    private void validateByLotAdjust(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            BigDecimal totleBaseQty = BigDecimal.ZERO;
            for (int j = 0; j < afterEntrys.size(); ++j) {
                DynamicObject afterEntry = (DynamicObject)afterEntrys.get(j);
                BigDecimal afterBaseQty = afterEntry.getBigDecimal("baseqty1");
                totleBaseQty = totleBaseQty.add(afterBaseQty);
                boolean hasChange = AdjustBillSubmitHelper.hasChange((DynamicObject)entry, (DynamicObject)afterEntry, (String[])new String[]{"lotnumber"});
                if (hasChange) continue;
                this.addMessage(entity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e0d\u540c\u4e8e\u8f6c\u6362\u524d\u5206\u5f55\u7b2c{0}\u884c\u7684\u6279\u53f7\u3002", (String)"AdjustBillSubmitValidator_21", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
            }
            if (totleBaseQty.compareTo(baseQty) == 0) continue;
            this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u7684\u5408\u8ba1\u6570\u91cf\u5728\u6279\u6b21\u8f6c\u6362\u524d\u540e\u5e94\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustBillSubmitValidator_24", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
        }
    }

    private void validateByUnitAdjust(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
            if (afterEntrys.size() > 1) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5728\u975e\u6279\u6b21\u7269\u6599\u8f6c\u6362\u540e\uff0c\u4e0d\u5141\u8bb8\u6709\u591a\u6761\u3002", (String)"AdjustBillSubmitValidator_27", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
                continue;
            }
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            BigDecimal totleBaseQty = BigDecimal.ZERO;
            for (int j = 0; j < afterEntrys.size(); ++j) {
                DynamicObject afterEntry = (DynamicObject)afterEntrys.get(j);
                BigDecimal afterBaseQty = afterEntry.getBigDecimal("baseqty1");
                totleBaseQty = totleBaseQty.add(afterBaseQty);
                boolean hasChange = AdjustBillSubmitHelper.hasChange((DynamicObject)entry, (DynamicObject)afterEntry, (String[])new String[]{"unit"});
                if (hasChange) continue;
                this.addMessage(entity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e0d\u540c\u4e8e\u8f6c\u6362\u524d\u5206\u5f55\u7b2c{0}\u884c\u7684\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"AdjustBillSubmitValidator_22", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
            }
            if (totleBaseQty.compareTo(baseQty) == 0) continue;
            this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u7684\u7269\u6599\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u5728\u8f6c\u6362\u524d\u540e\u5e94\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustBillSubmitValidator_23", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
        }
    }

    private void validateBySnAdjust(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        LinkedHashMap<Long, Long> before2AfterIdMap = new LinkedHashMap<Long, Long>(entrys.size());
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
            if (afterEntrys.size() > 1) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5728\u975e\u6279\u6b21\u7269\u6599\u8f6c\u6362\u540e\uff0c\u4e0d\u5141\u8bb8\u6709\u591a\u6761\u3002", (String)"AdjustBillSubmitValidator_27", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1}), ErrorLevel.Error);
            }
            if (afterEntrys.isEmpty() || afterEntrys.get(0) == null) continue;
            Long afterId = ((DynamicObject)afterEntrys.get(0)).getLong("id");
            before2AfterIdMap.put(entry.getLong("id"), afterId);
        }
        String billType = this.getEntityKey();
        Long pkValue = bill.getLong("id");
        if (pkValue == 0L) {
            return;
        }
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("billid", "=", (Object)pkValue);
        DataSet billSNRelations = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sbs_billsnrelation", (String)"entryid,entryentity.snnumber snnumber", (QFilter[])filter.toArray(), (String)"");
        HashMap snRelationMap = new HashMap(16);
        for (Row billSNRelation : billSNRelations) {
            Long entryId = billSNRelation.getLong("entryid");
            snRelationMap.putIfAbsent(entryId, new HashSet());
            ((Set)snRelationMap.get(entryId)).add(billSNRelation.getString("snnumber"));
        }
        int seq = 1;
        for (Map.Entry idEntry : before2AfterIdMap.entrySet()) {
            Long beforeId = (Long)idEntry.getKey();
            Long afterId = (Long)idEntry.getValue();
            Set beforeSnIds = (Set)snRelationMap.get(beforeId);
            Set afterSnIds = (Set)snRelationMap.get(afterId);
            if (beforeSnIds != null && afterSnIds != null) {
                afterSnIds.addAll(beforeSnIds);
                if (afterSnIds.size() < beforeSnIds.size() * 2) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8f6c\u6362\u524d\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\u4e0e\u5bf9\u5e94\u8f6c\u6362\u540e\u7269\u6599\u660e\u7ec6\u7684\u5e8f\u5217\u53f7\u4e0d\u80fd\u76f8\u540c\u3002", (String)"AdjustBillSubmitValidator_19", (String)"scmc-im-opplugin", (Object[])new Object[]{seq}));
                }
            }
            ++seq;
        }
    }
}

