/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.assembbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class AssembMustInputBeforeAssembValidator
extends AbstractValidator {
    public void validate() {
        this.materialMustInputValidate();
        this.currencyMustInputValidate();
    }

    private void currencyMustInputValidate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object currency;
            if (dataEntity == null || (currency = dataEntity.getDataEntity().get("currency")) != null) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5e93\u5b58\u7ec4\u7ec7\u6838\u7b97\u4e3b\u4f53\u672c\u4f4d\u5e01\u3002", (String)"AssembMustInputBeforeAssembValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void materialMustInputValidate() {
        InvBillErrorCode errorCodeObj = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder strs = new StringBuilder();
            errorCodeObj = new InvBillErrorCode();
            DynamicObjectCollection billentry = dataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            if (billentry == null || billentry.size() == 0) continue;
            for (DynamicObject entry : billentry) {
                DynamicObjectCollection beforeMaterial = entry.getDynamicObjectCollection("afterentity");
                if (beforeMaterial != null && beforeMaterial.size() != 0) continue;
                strs.append(CommonUtils.getCodeErrorMessage((ErrorCode)errorCodeObj.getNO_BEFORE_MATERIAL(), (Object[])new Object[]{entry.get("seq")}));
                strs.append('\n');
            }
            String erroMessage = strs.toString();
            if (erroMessage.trim().equals("")) continue;
            this.addErrorMessage(dataEntity, erroMessage);
        }
    }
}

