/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.calcost;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class QueryCalCostSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkDataRange(dataEntity);
            this.checkCostAccount(dataEntity);
            this.checkOperation(dataEntity);
        }
    }

    private void checkOperation(ExtendedDataEntity dataEntity) {
        HashSet<String> opKeys = new HashSet<String>(16);
        String operationNum = dataEntity.getDataEntity().getString("operation");
        DynamicObject imBill = dataEntity.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            return;
        }
        String imBillNum = imBill.getString("number");
        List operations = EntityMetadataCache.getDataEntityOperate((String)imBillNum);
        for (Map operation : operations) {
            String opKey = (String)operation.get("key");
            opKeys.add(opKey);
        }
        if (!opKeys.contains(operationNum)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8c03\u7528\u670d\u52a1\u7684\u64cd\u4f5c\u201d\u3002", (String)"QueryCalCostSaveValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkDataRange(ExtendedDataEntity dataEntity) {
        String filterFormula = dataEntity.getDataEntity().getString("filterformula_tag");
        if (StringUtils.isBlank((CharSequence)filterFormula)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u8303\u56f4\u3002", (String)"QueryCalCostSaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkCostAccount(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        boolean mainAccount = entity.getBoolean("iscostmainaccount");
        if (Boolean.FALSE.equals(mainAccount)) {
            Object accountType = entity.get("accounttype");
            Object costAccount = entity.get("costaccount");
            if (accountType == null && costAccount == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e3b\u8d26\u7c3f\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u8d26\u7c3f\u7c7b\u522b\u548c\u6210\u672c\u8d26\u7c3f\u5fc5\u987b\u67091\u9879\u6709\u503c\u3002", (String)"QueryCalCostSaveValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

