/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.general;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class WarehouseFinishInitValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(WarehouseFinishInitValidator.class);

    private String getStockDateMsgFormat() {
        return ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1s\u884c\uff0c\u5165\u5e93\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u4ed3\u5e93\u201c%2s\u201d\u7684\u542f\u7528\u65e5\u671f\u201c%3s\u201d\u3002", (String)"WarehouseFinishInitValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"WarehouseFinishInitValidator", (String)"validate");){
            Map<String, DynamicObject> orgWarehouseMap = this.getWareHouseSet(this.dataEntities);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkHeadWarehouse(dataEntity, orgWarehouseMap);
                this.checkStockinDate(dataEntity);
            }
        }
    }

    private void checkStockinDate(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObject org = bill.getDynamicObject("org");
        if (null == org) {
            return;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        HashSet warIds = new HashSet(entrys.size());
        entrys.forEach(v -> {
            DynamicObject warehouse = v.getDynamicObject("warehouse");
            if (warehouse != null) {
                warIds.add(warehouse.getPkValue());
            }
        });
        if (warIds.isEmpty()) {
            return;
        }
        Map warMap = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"id,startdate,warehouse", (QFilter[])filter.and("warehouse", "in", warIds).toArray());
        HashMap<Object, DynamicObject> whIdToSetupMap = new HashMap<Object, DynamicObject>(warMap.size());
        for (DynamicObject whSetup : warMap.values()) {
            DynamicObject wh = whSetup.getDynamicObject("warehouse");
            if (wh == null) continue;
            whIdToSetupMap.put(wh.getPkValue(), whSetup);
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject warehouse;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Date stockindate = entry.getDate("stockindate");
            if (null == stockindate || (warehouse = entry.getDynamicObject("warehouse")) == null) continue;
            Object warehousePkValue = warehouse.getPkValue();
            DynamicObject dynamicObject = (DynamicObject)whIdToSetupMap.get(warehousePkValue);
            if (dynamicObject == null) {
                logger.info("WarehouseFinishInitValidator.checkStockinDate:filter is :" + filter);
                logger.info(String.format("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u8bbe\u7f6e,\u5355\u636e\u7f16\u53f7\uff1a[%s] ;\u5206\u5f55\u4e0b\u6807\uff1a[%s] ;\u5e93\u5b58\u7ec4\u7ec7\uff1a\u7f16\u7801[%s],id[%s] ;\u4ed3\u5e93\uff1a\u7f16\u7801[%s],id[%s] ", bill.get("billno"), i, org.get("number"), org.getPkValue(), warehouse.get("number"), warehouse.getPkValue()));
                continue;
            }
            Date startDate = dynamicObject.getDate("startdate");
            if (startDate == null || stockindate.before(startDate)) continue;
            String warehouseName = warehouse.getLocaleString("name").getLocaleValue();
            this.addErrorMessage(dataEntity, String.format(this.getStockDateMsgFormat(), i + 1, warehouseName, DateUtils.getDateString((Date)startDate)));
        }
    }

    private Map<String, DynamicObject> getWareHouseSet(ExtendedDataEntity[] dataEntities) {
        HashSet<Object> whIds = new HashSet<Object>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject invBill = dataEntity.getDataEntity();
            DynamicObjectCollection billEntry = invBill.getDynamicObjectCollection("billentry");
            for (DynamicObject item : billEntry) {
                DynamicObject headWh = item.getDynamicObject("warehouse");
                if (headWh == null) continue;
                whIds.add(headWh.getPkValue());
            }
        }
        QFilter qFilter1 = new QFilter("warehouse.id", "in", whIds);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map whSet = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"id,org,warehouse,initstatus", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        HashMap<String, DynamicObject> orgWarehouseMap = new HashMap<String, DynamicObject>();
        for (Map.Entry entry : whSet.entrySet()) {
            DynamicObject orgDyc = ((DynamicObject)entry.getValue()).getDynamicObject("org");
            DynamicObject warehouseDyc = ((DynamicObject)entry.getValue()).getDynamicObject("warehouse");
            if (warehouseDyc == null || orgDyc == null) continue;
            StringBuilder orgWarehouseKey = new StringBuilder();
            orgWarehouseKey.append(orgDyc.getPkValue());
            orgWarehouseKey.append(',');
            orgWarehouseKey.append(warehouseDyc.getPkValue());
            orgWarehouseMap.put(orgWarehouseKey.toString(), (DynamicObject)entry.getValue());
        }
        return orgWarehouseMap;
    }

    private void checkHeadWarehouse(ExtendedDataEntity dataEntity, Map<String, DynamicObject> orgWarehouseMap) {
        DynamicObject invBill = dataEntity.getDataEntity();
        DynamicObject headOrgDyc = invBill.getDynamicObject("org");
        for (DynamicObject entryDyc : invBill.getDynamicObjectCollection("billentry")) {
            String tip;
            Object[] errorCodeParams;
            InvBillErrorCode errorCode;
            DynamicObject entryWarehouseDyc = entryDyc.getDynamicObject("warehouse");
            if (headOrgDyc == null || entryWarehouseDyc == null) continue;
            StringBuilder orgWarehouseSbf = new StringBuilder();
            orgWarehouseSbf.append(headOrgDyc.getPkValue());
            orgWarehouseSbf.append(',');
            orgWarehouseSbf.append(entryWarehouseDyc.getPkValue());
            String orgWarehouseKey = orgWarehouseSbf.toString();
            DynamicObject warehouseSetting = orgWarehouseMap.get(orgWarehouseKey);
            if (warehouseSetting == null) {
                errorCode = new InvBillErrorCode();
                errorCodeParams = new Object[]{headOrgDyc.get("name"), entryWarehouseDyc.getString("name")};
                tip = CommonUtils.getCodeErrorMessage((ErrorCode)errorCode.getERROR_WAREHOUSESET_NOTEXIT(), (Object[])errorCodeParams);
                this.addErrorMessage(dataEntity, tip);
                continue;
            }
            if (!"B".equals(warehouseSetting.getString("initstatus"))) continue;
            errorCode = new InvBillErrorCode();
            errorCodeParams = new Object[]{headOrgDyc.get("name"), entryWarehouseDyc.getString("name")};
            tip = CommonUtils.getCodeErrorMessage((ErrorCode)errorCode.getERROR_WAREHOUSE_INIT(), (Object[])errorCodeParams);
            this.addErrorMessage(dataEntity, tip);
        }
    }
}

