/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.algorithm.SimpleAlgorithmForBotp;
import kd.scmc.im.business.algorithm.TaxAlgorithmForBotp;
import kd.scmc.im.business.helper.AuxQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillQtyAndUnitHelper;
import kd.scmc.im.business.helper.DefaultTaxRateHelper;
import kd.scmc.im.business.helper.FarmProductsHelper;
import kd.scmc.im.business.helper.InvoiceBizHelper;
import kd.scmc.im.business.helper.SetValueForBotpWBHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.IMStringUtils;

public class BillTplImportHandle {
    private List<String> errorMsg = new ArrayList<String>();
    private Map<Long, List<String>> materialAux = new HashMap<Long, List<String>>();
    private List<String> flexFieldlist = new ArrayList<String>();
    private Map<Long, List<Long>> unitlist = null;
    private Map<Object, DynamicObject> unitsMap = null;
    private Map<String, Map<Integer, Integer>> unitRateConv = new HashMap<String, Map<Integer, Integer>>();
    private Map<String, String> rateCache = new HashMap<String, String>(16);
    private Map<Long, BigDecimal> taxRateCache = new HashMap<Long, BigDecimal>(16);
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;

    public BillTplImportHandle(List<DynamicObject> datas) {
        this.initData(datas);
    }

    private void initData(List<DynamicObject> datas) {
        this.beforeHandleBills(datas);
        for (DynamicObject data : datas) {
            DynamicObjectCollection enrtyList = data.getDynamicObjectCollection("billentry");
            String formId = data.getDynamicObjectType().getName();
            this.beforeHandleEntries(data, enrtyList, formId);
            for (DynamicObject entry : enrtyList) {
                this.handleEntry(formId, entry);
            }
            this.afterHandleEntries(data, enrtyList, formId);
        }
        this.afterHandleBills(datas);
    }

    protected void beforeHandleBills(List<DynamicObject> datas) {
        this.cache2Auxpty(datas);
    }

    protected void beforeHandleEntries(DynamicObject data, DynamicObjectCollection enrtyList, String formId) {
        FarmProductsHelper.setDeductibleRate((DynamicObject)data);
        if (!("im_purinbill".equals(formId) || "im_purreceivebill".equals(formId) || "im_saloutbill".equals(formId) || "im_ospurinbill".equals(formId))) {
            return;
        }
        Object headSupOrCustomer = null;
        headSupOrCustomer = "im_saloutbill".equals(formId) ? data.get("customer") : data.get("supplier");
        if ("im_purinbill".equals(formId) || "im_ospurinbill".equals(formId)) {
            this.setInvoiceBizType(data);
        }
        for (DynamicObject entry : enrtyList) {
            this.setByIsPresent(data, entry);
            if (headSupOrCustomer == null) continue;
            this.setSupplierOrCustomer(formId, entry, (DynamicObject)headSupOrCustomer);
        }
    }

    private void setInvoiceBizType(DynamicObject data) {
        DynamicObject dataInvoiceBizType = data.getDynamicObject("invoicebiztype");
        if (dataInvoiceBizType != null) {
            return;
        }
        DynamicObject supplier = data.getDynamicObject("supplier");
        DynamicObject defaultInvoiceBizType = BusinessDataServiceHelper.loadSingle((Object)DEFAULT_INVOICE_BIZ, (String)"bd_invoicebiztype");
        if (supplier == null) {
            data.set("invoicebiztype", (Object)defaultInvoiceBizType);
            return;
        }
        DynamicObject invoiceType = (DynamicObject)supplier.get("invoicecategory");
        if (invoiceType != null) {
            String appId = "im";
            Long invoiceTypeId = invoiceType.getLong("id");
            DynamicObject invoiceBizType = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"CommonHelperService", (String)"getInvoiceBizType", (Object[])new Object[]{invoiceTypeId, appId});
            if (invoiceBizType != null) {
                data.set("invoicebiztype", (Object)invoiceBizType);
            } else {
                data.set("invoicebiztype", (Object)defaultInvoiceBizType);
            }
        } else {
            data.set("invoicebiztype", (Object)defaultInvoiceBizType);
        }
    }

    protected void handleEntry(String formId, DynamicObject entry) {
        this.check2UnitAndQty(entry, formId);
        this.checkByUnit2nd(entry);
        this.check4auxpty(entry);
    }

    private void setSupplierOrCustomer(String formId, DynamicObject entry, DynamicObject headSupOrCustomer) {
        Object bizFunction = headSupOrCustomer.get("bizfunction");
        if (bizFunction == null) {
            return;
        }
        String bizFunctionStr = bizFunction.toString();
        HashMap<String, String[]> fieldFunctionMap = new HashMap<String, String[]>(8);
        if ("im_saloutbill".equals(formId)) {
            fieldFunctionMap.put("reccustomer", new String[]{"1", "delivercustomerid"});
            fieldFunctionMap.put("settlecustomer", new String[]{"2", "invoicecustomerid"});
            fieldFunctionMap.put("payingcustomer", new String[]{"3", "paymentcustomerid"});
        } else {
            fieldFunctionMap.put("providersupplier", new String[]{"1", "deliversupplierid"});
            fieldFunctionMap.put("invoicesupplier", new String[]{"2", "invoicesupplierid"});
            fieldFunctionMap.put("receivesupplier", new String[]{"3", "receivingsupplierid"});
        }
        for (Map.Entry functionEntry : fieldFunctionMap.entrySet()) {
            Object tabValue;
            String fieldKey = (String)functionEntry.getKey();
            String[] value = (String[])functionEntry.getValue();
            Object importValue = entry.get(fieldKey);
            if (importValue != null) continue;
            importValue = "providersupplier".equals(fieldKey) || "reccustomer".equals(fieldKey) ? (bizFunctionStr.contains(value[0]) ? headSupOrCustomer : null) : ((tabValue = headSupOrCustomer.get(value[1])) == null ? (bizFunctionStr.contains(value[0]) ? headSupOrCustomer : null) : tabValue);
            entry.set(fieldKey, importValue);
        }
    }

    private void setByIsPresent(DynamicObject data, DynamicObject entry) {
        Object isPresent = entry.get("ispresent");
        if (isPresent == null || !((Boolean)isPresent).booleanValue()) {
            return;
        }
        Object isTax = data.get("istax");
        if (isTax == null) {
            return;
        }
        Object price = entry.get((Boolean)isTax != false ? "priceandtax" : "price");
        if (price == null || BigDecimal.ZERO.compareTo((BigDecimal)price) == 0) {
            entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
            entry.set("discountrate", (Object)Constants.ZERO);
        } else {
            entry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
            entry.set("discountrate", (Object)Constants.ONE_HUNDRED);
        }
    }

    protected void afterHandleEntries(DynamicObject data, DynamicObjectCollection enrtyList, String formId) {
        if ("im_purinbill".equals(formId)) {
            SetValueForBotpWBHelper.purInSetValueByImport((DynamicObject)data);
        } else if ("im_saloutbill".equals(formId)) {
            SetValueForBotpWBHelper.salOutSetValueByImport((DynamicObject)data);
        }
        this.reCalTaxRate(formId, data, enrtyList);
        this.setDeductibleRate(data, enrtyList);
        this.calByQty(formId, data);
        this.checkAmount(formId, data);
        this.calMaterialCost(formId, data);
    }

    protected void afterHandleBills(List<DynamicObject> datas) {
    }

    private void setDeductibleRate(DynamicObject data, DynamicObjectCollection entryList) {
        boolean purInBillType = InvoiceBizHelper.isPurInBillType((DynamicObject)data);
        if (purInBillType) {
            DynamicObject invoiceBiz = data.getDynamicObject("invoicebiztype");
            if (invoiceBiz == null) {
                return;
            }
            String invoiceBizNum = invoiceBiz.getString("number");
            for (DynamicObject entry : entryList) {
                String taxPayerType = entry.getString("taxpayertype");
                if (("SP00002_S".equals(invoiceBizNum) || "SP00004_S".equals(invoiceBizNum)) && "1".equals(taxPayerType)) {
                    Object taxRate = entry.get("taxrate");
                    entry.set("deductiblerate", taxRate);
                    continue;
                }
                entry.set("deductiblerate", (Object)BigDecimal.ZERO);
            }
        }
    }

    private void reCalTaxRate(String formId, DynamicObject data, DynamicObjectCollection entryList) {
        boolean hasTaxRateBill = true;
        String supOrCusKey = "supplier";
        if ("im_saloutbill".equals(formId)) {
            supOrCusKey = "customer";
        } else if (!("im_purreceivebill".equals(formId) || "im_purinbill".equals(formId) || "im_ospurinbill".equals(formId))) {
            hasTaxRateBill = false;
        }
        if (!hasTaxRateBill) {
            return;
        }
        for (DynamicObject entry : entryList) {
            DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
            if (taxRateId == null) {
                DefaultTaxRateHelper.setTaxRate((DynamicObject)data, (String)supOrCusKey, (DynamicObject)entry, this.taxRateCache);
                continue;
            }
            entry.set("taxrate", (Object)taxRateId.getBigDecimal("taxrate"));
        }
    }

    private void calMaterialCost(String formId, DynamicObject data) {
        if ("im_saloutbill".equals(formId)) {
            boolean isInitBill = data.getBoolean("isinitbill");
            boolean isInputAmount = data.getBoolean("inputamount");
            if (isInitBill) {
                DynamicObjectCollection enrtyList = data.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : enrtyList) {
                    BigDecimal qty = entry.getBigDecimal("qty");
                    qty = qty == null ? BigDecimal.ZERO : qty;
                    int pricePrecision = this.getPrecision(data, "currency", "amtprecision");
                    int precision = this.getPrecision(data, "currency", "priceprecision");
                    if (isInputAmount) {
                        BigDecimal mCost = entry.getBigDecimal("materialcost");
                        mCost = mCost == null ? BigDecimal.ZERO : mCost;
                        entry.set("unitmaterialcost", (Object)mCost.divide(qty, precision, 4));
                        continue;
                    }
                    BigDecimal baseMCost = entry.getBigDecimal("unitmaterialcost");
                    baseMCost = baseMCost == null ? BigDecimal.ZERO : baseMCost;
                    entry.set("materialcost", (Object)baseMCost.multiply(qty).setScale(pricePrecision, 4));
                }
            }
        }
    }

    private int getPrecision(DynamicObject data, String currencyf, String pref) {
        int precision = 2;
        DynamicObject currency = data.getDynamicObject(currencyf);
        if (currency != null) {
            precision = currency.getInt(pref);
        }
        return precision;
    }

    private void checkAmount(String formId, DynamicObject data) {
        if ("im_productinbill".equals(formId)) {
            DynamicObjectCollection enrtyList = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : enrtyList) {
                BigDecimal amount = entry.getBigDecimal("amount");
                boolean flag = this.checkBigDecimal(amount);
                if (flag) continue;
                return;
            }
        }
    }

    private boolean checkBigDecimal(BigDecimal amount) {
        if (amount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            this.errorMsg.add(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_AMOUNT()));
            return false;
        }
        return true;
    }

    private void calByQty(String formId, DynamicObject data) {
        switch (formId) {
            case "im_mdc_ominbill": 
            case "im_saloutbill": 
            case "im_purinbill": 
            case "im_purreceivebill": 
            case "im_mdc_omcmplinbill": 
            case "im_ospurinbill": {
                TaxAlgorithmForBotp algo = new TaxAlgorithmForBotp(data);
                boolean inputAmount = this.inputAmount(formId, data);
                if (inputAmount) {
                    if (data.getBoolean("istax")) {
                        algo.reCalByAmountAndTax();
                        break;
                    }
                    algo.reCalByAmount();
                    break;
                }
                algo.reCalFields();
                break;
            }
            case "im_otherinbill": 
            case "im_otheroutbill": 
            case "im_productinbill": 
            case "im_materialreqoutbill": 
            case "im_osmaterialreqoutbill": {
                SimpleAlgorithmForBotp simpleAlgo = new SimpleAlgorithmForBotp(data);
                simpleAlgo.reCalFields();
                break;
            }
            case "im_transdirbill": 
            case "im_transinbill": 
            case "im_transoutbill": {
                SimpleAlgorithmForBotp transAlgo = new SimpleAlgorithmForBotp(data, "settlescurrency");
                transAlgo.reCalFields();
                break;
            }
            case "im_initbill": {
                SimpleAlgorithmForBotp initBillAlgo = new SimpleAlgorithmForBotp(data, "currency");
                initBillAlgo.reCalInitFields();
                break;
            }
        }
    }

    private boolean inputAmount(String formId, DynamicObject data) {
        if ("im_purinbill".equals(formId) || "im_saloutbill".equals(formId) || "im_ospurinbill".equals(formId)) {
            return data.getBoolean("inputamount");
        }
        return false;
    }

    private void cache2Auxpty(List<DynamicObject> datas) {
        ArrayList<String> auxList = null;
        HashSet<Long> masterIdSet = new HashSet<Long>();
        HashSet<String> keySet = new HashSet<String>();
        ArrayList<Long> materialIds = new ArrayList<Long>();
        HashSet<Long> invUnitIds = new HashSet<Long>(16);
        for (DynamicObject data : datas) {
            DynamicObjectCollection enrtyList = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : enrtyList) {
                DynamicObject material;
                DynamicObject materialDym = entry.getDynamicObject("material");
                if (materialDym == null || (material = materialDym.getDynamicObject("masterid")) == null) continue;
                invUnitIds.add(materialDym.getLong("inventoryunit_id"));
                invUnitIds.add(material.getLong("auxptyunit_id"));
            }
            this.addMaterialIds(masterIdSet, keySet, materialIds, enrtyList);
        }
        this.unitlist = AuxQtyAndUnitHelper.getAssistMUListResult(materialIds, (String)"1");
        this.unitsMap = this.cacheUnit(invUnitIds);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"number", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", keySet)});
        Arrays.asList(load).forEach(v -> this.flexFieldlist.add(v.getString("number")));
        if (masterIdSet.size() > 0) {
            DynamicObject[] auxptyV;
            for (DynamicObject aux : auxptyV = BusinessDataServiceHelper.load((String)"bd_auxptyvalue", (String)"entryentity.auxptyvalueid,material", (QFilter[])new QFilter[]{new QFilter("material", "in", masterIdSet), new QFilter("entryentity.isenable", "=", (Object)Boolean.TRUE)})) {
                DynamicObjectCollection col = aux.getDynamicObjectCollection("entryentity");
                Long materialId = aux.getLong("material.id");
                ArrayList<String> auxListValue = this.materialAux.get(materialId);
                auxList = auxListValue != null ? auxListValue : new ArrayList<String>();
                for (DynamicObject colEntry : col) {
                    auxList.add(colEntry.getString("auxptyvalueid"));
                }
                this.materialAux.put(materialId, auxList);
            }
        }
    }

    private Map<Object, DynamicObject> cacheUnit(Set<Long> unitIdSet) {
        if (this.unitlist == null || this.unitlist.isEmpty()) {
            return new HashMap<Object, DynamicObject>(16);
        }
        for (List<Long> unitIds : this.unitlist.values()) {
            unitIdSet.addAll(unitIds);
        }
        if (unitIdSet.isEmpty()) {
            return new HashMap<Object, DynamicObject>(16);
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])unitIdSet.toArray(), (String)"bd_measureunits");
    }

    private void addMaterialIds(Set<Long> masterIdSet, Set<String> keySet, List<Long> materialIds, DynamicObjectCollection enrtyList) {
        if (enrtyList == null) {
            return;
        }
        for (DynamicObject entry : enrtyList) {
            DynamicObject auxpty;
            DynamicObject materialDym = entry.getDynamicObject("material");
            if (materialDym == null) continue;
            long materialId = (Long)materialDym.getDynamicObject("masterid").getPkValue();
            if (!materialIds.contains(materialId)) {
                materialIds.add(materialId);
            }
            if ((auxpty = entry.getDynamicObject("auxpty")) == null) continue;
            Map jsonMap = (Map)SerializationUtils.fromJsonString((String)auxpty.getString("value"), Map.class);
            keySet.addAll(jsonMap.keySet());
            if (this.materialAux.containsKey(materialId)) continue;
            masterIdSet.add(materialDym.getLong("masterid.id"));
        }
    }

    public final void check2UnitAndQty(DynamicObject entry, String formId) {
        Map<Integer, Integer> rateMap;
        DynamicObject muConv;
        Long masterMaterialId = 0L;
        DynamicObject materialDym = entry.getDynamicObject("material");
        if (materialDym == null) {
            return;
        }
        DynamicObject unit = entry.getDynamicObject("unit");
        if (unit == null) {
            Long unitId = materialDym.getLong("inventoryunit_id");
            unit = this.unitsMap.get(unitId);
            entry.set("unit", (Object)unit);
        }
        DynamicObject masterMaterial = materialDym.getDynamicObject("masterid");
        DynamicObject baseUnit = null;
        if (masterMaterial != null) {
            masterMaterialId = (Long)masterMaterial.getPkValue();
            baseUnit = this.unitsMap.get(masterMaterial.getLong("baseunit_id"));
        }
        entry.set("materialmasterid", (Object)masterMaterial);
        if (baseUnit == null) {
            this.errorMsg.add(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
            return;
        }
        entry.set("baseunit", baseUnit);
        List<Long> unitIds = this.unitlist.get(masterMaterialId);
        if (unitIds == null || !unitIds.contains(unit.getLong("id"))) {
            this.errorMsg.add(IMStringUtils.append((String)ResManager.loadKDString((String)"\u7269\u6599", (String)"BillTplImportHandle_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{materialDym.getString("masterid.name"), ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"BillTplImportHandle_1", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
            return;
        }
        int precision = unit.getInt("precision");
        int basePrecision = baseUnit.getInt("precision");
        String precisionaccountStr = unit.getString("precisionaccount");
        String basePrecisionaccountStr = baseUnit.getString("precisionaccount");
        int precisionaccount = 4;
        int basePrecisionaccount = 4;
        if (!StringUtils.isEmpty((CharSequence)precisionaccountStr)) {
            precisionaccount = Integer.parseInt(precisionaccountStr);
        }
        if (!StringUtils.isEmpty((CharSequence)basePrecisionaccountStr)) {
            basePrecisionaccount = Integer.parseInt(basePrecisionaccountStr);
        }
        BigDecimal qty = entry.getBigDecimal("qty");
        qty = qty.setScale(precision, precisionaccount);
        entry.set("qty", (Object)qty);
        String key = masterMaterial.getPkValue() + "_" + unit.getPkValue() + "_" + baseUnit.getPkValue();
        if (!this.unitRateConv.containsKey(key) && (muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterMaterial.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)baseUnit.getPkValue()))) != null && muConv.getInt("numerator") != 0) {
            this.unitRateConv.put(key, Collections.singletonMap(muConv.getInt("numerator"), muConv.getInt("denominator")));
        }
        if ((rateMap = this.unitRateConv.get(key)) == null) {
            this.errorMsg.add(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6216\u7ef4\u62a4\u8ba1\u91cf\u5355\u4f4d\u7684\u6362\u7b97\u7387\u3002", (String)"BillTplImportHandle_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            return;
        }
        Map.Entry<Integer, Integer> rateEntry = rateMap.entrySet().iterator().next();
        BigDecimal baseQty = qty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePrecisionaccount));
        entry.set("baseqty", (Object)baseQty);
        this.updateYearQty(entry, Collections.singletonMap(new BigDecimal(rateEntry.getKey()), new BigDecimal(rateEntry.getValue())), "baseqty");
        if ("im_productinbill".equals(formId) || "im_purinbill".equals(formId)) {
            this.updateQtyUnit2nd(entry);
        }
    }

    private void updateQtyUnit2nd(DynamicObject entryObj) {
        boolean qtyUnit2ndIsZero;
        DynamicObject materialInvInfo = entryObj.getDynamicObject("material");
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        boolean isUnitToU2nd = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir);
        boolean isUnitAndU2nd = UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        BigDecimal baseQty = entryObj.getBigDecimal("baseqty");
        DynamicObject billUnit2nd = entryObj.getDynamicObject("unit2nd");
        if (billUnit2nd == null) {
            billUnit2nd = this.unitsMap.get(material.getLong("auxptyunit_id"));
            entryObj.set("unit2nd", (Object)billUnit2nd);
        }
        BigDecimal qtyUnit2nd = entryObj.getBigDecimal("qtyunit2nd");
        if (baseUnit == null || billUnit2nd == null) {
            return;
        }
        boolean bl = qtyUnit2ndIsZero = BigDecimal.ZERO.compareTo(qtyUnit2nd) == 0;
        if ((isUnitToU2nd && qtyUnit2ndIsZero || isUnitAndU2nd) && baseQty != null && baseQty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal unit2ndRate = BillTplImportHandle.getUnitRateConv((Long)material.getPkValue(), (Long)billUnit2nd.getPkValue(), (Long)baseUnit.getPkValue(), this.rateCache);
            if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
                return;
            }
            unit2ndRate = unit2ndRate.setScale(10);
            BigDecimal qtyUnit2ndResult = baseQty.divide(unit2ndRate, billUnit2nd.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)billUnit2nd.getInt("precisionaccount")));
            entryObj.set("qtyunit2nd", (Object)qtyUnit2ndResult);
        }
    }

    private static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId, Map<String, String> cacheMap) {
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            return BigDecimal.ZERO;
        }
        StringBuilder cacheKeySb = new StringBuilder("unitRateCache_").append("_").append(materialId).append("_").append(srcUnitId).append("_").append(desUnitId);
        String cacheKey = cacheKeySb.toString();
        String rateCache = cacheMap.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)rateCache)) {
            return new BigDecimal(rateCache);
        }
        BigDecimal unitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        unitRate = unitRate == null ? BigDecimal.ZERO : unitRate;
        cacheMap.put(cacheKey, unitRate.toString());
        return unitRate;
    }

    public List<String> getErrorMsg() {
        return new ArrayList<String>(this.errorMsg);
    }

    public void updateYearQty(DynamicObject entry, Map<BigDecimal, BigDecimal> rateMap, String key) {
    }

    public final void checkByUnit2nd(DynamicObject entry) {
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = this.unitsMap.get(material.getLong("auxptyunit_id"));
        Boolean isUseUnit2nd = auxptyUnit != null;
        if (isUseUnit2nd.booleanValue()) {
            entry.set("unit2nd", (Object)auxptyUnit);
            this.update2Rate(entry, material);
        } else {
            entry.set("qtyunit2nd", (Object)BigDecimal.ZERO);
            entry.set("unit2nd", (Object)null);
            this.updateYearQty(entry, null, "unit2nd");
        }
    }

    public void update2Rate(DynamicObject entry, DynamicObject materialDym) {
        DynamicObject baseunit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        if (baseunit == null) {
            return;
        }
        DynamicObject unit2nd = entry.getDynamicObject("unit2nd");
        if (unit2nd != null) {
            BigDecimal qtyunit2nd = entry.getBigDecimal("qtyunit2nd");
            BigDecimal conv = Constants.ZERO;
            if (qtyunit2nd != null && qtyunit2nd.compareTo(BigDecimal.ZERO) != 0) {
                conv = baseQty.divide(qtyunit2nd, 10, 4);
            }
            if (conv.compareTo(Constants.ZERO) == 0) {
                conv = null;
            }
            this.updateYearQty(entry, Collections.singletonMap(baseQty, qtyunit2nd), "unit2nd");
        } else {
            this.updateYearQty(entry, null, "unit2nd");
        }
    }

    public final void check4auxpty(DynamicObject entry) {
        DynamicObject materialDym = entry.getDynamicObject("material");
        DynamicObject auxpty = entry.getDynamicObject("auxpty");
        if (materialDym == null || auxpty == null) {
            return;
        }
        Map jsonMap = (Map)SerializationUtils.fromJsonString((String)auxpty.getString("value"), Map.class);
        HashMap auxResult = new HashMap();
        Long masterId = materialDym.getLong("masterid.id");
        String masterNum = materialDym.getString("masterid.number");
        ArrayList auxList = this.materialAux.get(masterId);
        ArrayList arrayList = auxList = auxList == null ? new ArrayList() : auxList;
        if (!materialDym.getBoolean("masterid.isuseauxpty")) {
            this.errorMsg.add(IMStringUtils.append((String)ResManager.loadKDString((String)"\u7269\u6599", (String)"BillTplImportHandle_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{masterNum, ResManager.loadKDString((String)"\u672a\u542f\u7528\u8f85\u52a9\u5c5e\u6027,\u8bf7\u68c0\u67e5\u3002", (String)"BillTplImportHandle_3", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
            return;
        }
        for (Map.Entry next : jsonMap.entrySet()) {
            String auxId = next.getValue().toString();
            for (String aux : auxList) {
                if (!aux.equals(auxId)) continue;
                auxResult.put(next.getKey(), next.getValue());
            }
        }
        Set josnEntrys = jsonMap.entrySet();
        for (Map.Entry josnEntry : josnEntrys) {
            String flexField = (String)josnEntry.getKey();
            if (!this.flexFieldlist.contains(flexField)) continue;
            auxResult.put(flexField, josnEntry.getValue());
            String result = SerializationUtils.toJsonString(auxResult);
            auxpty.set("value", (Object)result);
            break;
        }
    }

    public void check4Lot(DynamicObject entry) {
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        if (materialInvInfo == null) {
            return;
        }
        if (!materialInvInfo.getBoolean("enablelot")) {
            entry.set("lotnumber", (Object)"");
        }
    }
}

