/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.validator.improt.BillTplImportHandle;

public class InitBillTplImportHandle
extends BillTplImportHandle {
    public InitBillTplImportHandle(List<DynamicObject> datas) {
        super(datas);
    }

    @Override
    public void updateYearQty(DynamicObject entry, Map<BigDecimal, BigDecimal> rateMap, String key) {
        super.updateYearQty(entry, rateMap, key);
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal yreceiveqty = entry.getBigDecimal("yreceiveqty");
        BigDecimal ysendqty = entry.getBigDecimal("ysendqty");
        BigDecimal qtyunit2nd = entry.getBigDecimal("qtyunit2nd");
        BigDecimal yreceiveqtyunit2nd = entry.getBigDecimal("yreceiveqtyunit2nd");
        BigDecimal ysendqtyunit2nd = entry.getBigDecimal("ysendqtyunit2nd");
        BigDecimal ystartqty = qty.add(ysendqty).subtract(yreceiveqty);
        entry.set("ystartqty", (Object)ystartqty);
        if ("baseqty".equals(key)) {
            if (rateMap == null) {
                entry.set("ystartbaseqty", (Object)BigDecimal.ZERO);
                entry.set("yreceivebaseqty", (Object)BigDecimal.ZERO);
                entry.set("ysendbaseqty", (Object)BigDecimal.ZERO);
            } else {
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                int basePrecision = baseUnit.getInt("precision");
                String basePrecisionaccountStr = baseUnit.getString("precisionaccount");
                int basePrecisionaccount = StringUtils.isBlank((CharSequence)basePrecisionaccountStr) ? 4 : Integer.parseInt(basePrecisionaccountStr);
                Map.Entry<BigDecimal, BigDecimal> rateEntry = rateMap.entrySet().iterator().next();
                entry.set("ystartbaseqty", (Object)ystartqty.multiply(rateEntry.getKey()).divide(rateEntry.getValue(), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePrecisionaccount)));
                entry.set("yreceivebaseqty", (Object)yreceiveqty.multiply(rateEntry.getKey()).divide(rateEntry.getValue(), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePrecisionaccount)));
                entry.set("ysendbaseqty", (Object)ysendqty.multiply(rateEntry.getKey()).divide(rateEntry.getValue(), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePrecisionaccount)));
            }
        }
        if ("unit2nd".equals(key)) {
            if (rateMap == null) {
                entry.set("qtyunit2nd", (Object)BigDecimal.ZERO);
                entry.set("ystartqtyunit2nd", (Object)BigDecimal.ZERO);
                entry.set("yreceiveqtyunit2nd", (Object)BigDecimal.ZERO);
                entry.set("ysendqtyunit2nd", (Object)BigDecimal.ZERO);
            } else {
                BigDecimal ystartqtyunit2nd = qtyunit2nd.add(ysendqtyunit2nd).subtract(yreceiveqtyunit2nd);
                entry.set("ystartqtyunit2nd", (Object)ystartqtyunit2nd);
            }
        }
    }
}

