/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.business.helper.impt.ImptDataSourceHelper;
import kd.scmc.im.business.helper.impt.ImptValidateHelper;
import kd.scmc.im.business.pojo.GeneralValResultInfo;

public class OtherInImptValidator
extends AbstractValidator {
    private static final String BILLCRETYPE_IMPORT = "1";
    private Map<Long, Long> orgToDefDept = new HashMap<Long, Long>();

    public void validate() {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        ArrayList<ExtendedDataEntity> imptDataEntities = new ArrayList<ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            String billCreType = billObj.getString("billcretype");
            if (!BILLCRETYPE_IMPORT.equals(billCreType)) continue;
            DynamicObject org = billObj.getDynamicObject("org");
            if (org != null) {
                Long orgId = org.getLong("id");
                orgIds.add(orgId);
            }
            imptDataEntities.add(dataEntity);
        }
        if (imptDataEntities.isEmpty()) {
            return;
        }
        Map orgToBizDepts = ImptDataSourceHelper.getOrgToBizDepts(orgIds);
        for (ExtendedDataEntity dataEntity : imptDataEntities) {
            DynamicObject billObj;
            DynamicObject org = (billObj = dataEntity.getDataEntity()).getDynamicObject("org");
            Long orgId = org == null ? 0L : org.getLong("id");
            List bizDeptsOfOrg = (List)orgToBizDepts.get(orgId);
            GeneralValResultInfo ckBizDeptRes = ImptValidateHelper.checkBizDept((DynamicObject)billObj, (List)bizDeptsOfOrg);
            Boolean isSuccess = ckBizDeptRes.getIsVaild();
            if (!isSuccess.booleanValue()) {
                String errMsg = ckBizDeptRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            DynamicObject dept = billObj.getDynamicObject("dept");
            Long defDeptId = dept == null ? 0L : dept.getLong("id");
            orgIds.add(orgId);
            if (!defDeptId.equals(0L)) {
                this.orgToDefDept.put(orgId, defDeptId);
            }
            Map orgToDepts = ImptDataSourceHelper.getOrgToDepts(orgIds, this.orgToDefDept);
            List list = (List)orgToDepts.get(orgId);
        }
    }
}

