/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.util.Date;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.impt.ImptValidateHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;

public class ShelflifeMgrNoAfterEntryValidator
extends AbstractValidator {
    private static final String BILLCRETYPE_IMPORT = "1";

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ShelfLifeDateValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject billObj = dataEntity.getDataEntity();
                String billCreType = billObj.getString("billcretype");
                boolean isIngore = true;
                if (!BILLCRETYPE_IMPORT.equals(billCreType)) continue;
                DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
                for (DynamicObject entryObj : billEntrys) {
                    DynamicObject materialStategy = entryObj.getDynamicObject("material");
                    if (materialStategy == null) continue;
                    if (ImptValidateHelper.isEnableShelflifeMgr((DynamicObject)materialStategy)) {
                        this.calShelflife(dataEntity, entryObj, materialStategy, isIngore);
                        continue;
                    }
                    entryObj.set("producedate", (Object)"");
                    entryObj.set("expirydate", (Object)"");
                }
            }
        }
    }

    private void calShelflife(ExtendedDataEntity dataEntity, DynamicObject entryObj, DynamicObject materialStategy, boolean isIngore) {
        DynamicObject materialObj = materialStategy.getDynamicObject("masterid");
        String materialNum = materialObj.getString("number");
        Date producedate = (Date)entryObj.get("producedate");
        Date expirydate = (Date)entryObj.get("expirydate");
        String shelflifeUnit = materialStategy.getString("shelflifeunit");
        String caldirec = materialStategy.getString("caldirection");
        caldirec = StringUtils.isBlank((String)caldirec) ? CalDirectionEnum.CALBOTH.getValue() : caldirec;
        int shelflife = materialStategy.getInt("shelflife");
        String calculationForEndDate = materialStategy.getString("calculationforenddate");
        if (caldirec.equals(CalDirectionEnum.CALNONE.getValue())) {
            if (producedate == null || expirydate == null) {
                if (!isIngore) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u8ba1\u7b97\u65b9\u5411\u4e3a\u4e92\u4e0d\u8ba1\u7b97\uff0c\u751f\u4ea7\u65e5\u671f\u548c\u5230\u671f\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ShelflifeMgrNoAfterEntryValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum));
                }
                return;
            }
        } else if (caldirec.equals(CalDirectionEnum.CALBOTH.getValue())) {
            if (producedate == null && expirydate == null) {
                if (!isIngore) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u8ba1\u7b97\u65b9\u5411\u4e3a\u76f8\u4e92\u8ba1\u7b97\uff0c\u751f\u4ea7\u65e5\u671f\u6216\u5230\u671f\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ShelflifeMgrNoAfterEntryValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum));
                }
                return;
            }
            if (producedate != null) {
                Date expiryDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)producedate, (String)calculationForEndDate);
                entryObj.set("expirydate", (Object)expiryDate);
            } else if (expirydate != null) {
                Date produceDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(-shelflife), (Date)expirydate, (String)calculationForEndDate);
                entryObj.set("producedate", (Object)produceDate);
            }
        } else if (caldirec.equals(CalDirectionEnum.CALENDDATE.getValue())) {
            if (producedate == null) {
                if (!isIngore) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u8ba1\u7b97\u65b9\u5411\u4e3a\u6309\u751f\u4ea7\u65e5\u8ba1\u7b97\u5230\u671f\u65e5\uff0c\u751f\u4ea7\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ShelflifeMgrNoAfterEntryValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum));
                }
                return;
            }
            if (expirydate == null) {
                expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)producedate, (String)calculationForEndDate);
                entryObj.set("expirydate", (Object)expirydate);
            }
        } else if (caldirec.equals(CalDirectionEnum.CALSTARTDATE.getValue())) {
            if (expirydate == null) {
                if (!isIngore) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u8ba1\u7b97\u65b9\u5411\u4e3a\u6309\u5230\u671f\u65e5\u8ba1\u7b97\u751f\u4ea7\u65e5\uff0c\u5230\u671f\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ShelflifeMgrNoAfterEntryValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum));
                }
                return;
            }
            if (producedate == null) {
                producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(-shelflife), (Date)expirydate, (String)calculationForEndDate);
                entryObj.set("producedate", (Object)producedate);
            }
        }
        if (producedate != null && expirydate != null && producedate.after(expirydate)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u671f\u3002", (String)"ShelflifeMgrNoAfterEntryValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

