/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.util.Date;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.impt.ImptValidateHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;

public class ShelflifeMgrValidator
extends AbstractValidator {
    private static final String BILLCRETYPE_IMPORT = "1";

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ShelfLifeDateValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject billObj = dataEntity.getDataEntity();
                String billCreType = billObj.getString("billcretype");
                if (!BILLCRETYPE_IMPORT.equals(billCreType) && !"3".equals(billCreType)) continue;
                DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
                for (DynamicObject entryObj : billEntrys) {
                    DynamicObject materialStategy;
                    DynamicObjectCollection afterEntrys = entryObj.getDynamicObjectCollection("afterentity");
                    if (afterEntrys != null) {
                        for (DynamicObject afterEntry : afterEntrys) {
                            DynamicObject materialStategy2 = null;
                            DynamicObject billMat = afterEntry.getDynamicObject("material1");
                            if (billMat == null || (materialStategy2 = "bd_material".equals(billMat.getDataEntityType().getName()) ? billMat.getDynamicObject("material") : billMat) == null) continue;
                            if (ImptValidateHelper.isEnableShelflifeMgr((DynamicObject)materialStategy2)) {
                                this.calShelflife(dataEntity, afterEntry, materialStategy2, "producedate1", "expirydate1");
                                continue;
                            }
                            afterEntry.set("producedate1", (Object)"");
                            afterEntry.set("expirydate1", (Object)"");
                        }
                    }
                    if ((materialStategy = entryObj.getDynamicObject("material")) == null) continue;
                    if (ImptValidateHelper.isEnableShelflifeMgr((DynamicObject)materialStategy)) {
                        this.calShelflife(dataEntity, entryObj, materialStategy, "producedate", "expirydate");
                        continue;
                    }
                    entryObj.set("producedate", (Object)"");
                    entryObj.set("expirydate", (Object)"");
                }
            }
        }
    }

    private void calShelflife(ExtendedDataEntity dataEntity, DynamicObject entryObj, DynamicObject materialStategy, String produceKey, String expiryKey) {
        Date producedate = (Date)entryObj.get(produceKey);
        Date expirydate = (Date)entryObj.get(expiryKey);
        String shelflifeUnit = materialStategy.getString("shelflifeunit");
        String caldirec = materialStategy.getString("caldirection");
        caldirec = StringUtils.isBlank((String)caldirec) ? CalDirectionEnum.CALBOTH.getValue() : caldirec;
        int shelflife = materialStategy.getInt("shelflife");
        String calculationForEndDate = materialStategy.getString("calculationforenddate");
        if (!caldirec.equals(CalDirectionEnum.CALNONE.getValue())) {
            if (caldirec.equals(CalDirectionEnum.CALBOTH.getValue())) {
                if (producedate != null) {
                    Date expiryDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)producedate, (String)calculationForEndDate);
                    entryObj.set(expiryKey, (Object)expiryDate);
                } else if (expirydate != null) {
                    Date produceDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(-shelflife), (Date)expirydate, (String)calculationForEndDate);
                    entryObj.set(produceKey, (Object)produceDate);
                }
            } else if (caldirec.equals(CalDirectionEnum.CALENDDATE.getValue())) {
                if (producedate != null && expirydate == null) {
                    expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)producedate, (String)calculationForEndDate);
                    entryObj.set(expiryKey, (Object)expirydate);
                }
            } else if (caldirec.equals(CalDirectionEnum.CALSTARTDATE.getValue()) && expirydate != null && producedate == null) {
                producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(-shelflife), (Date)expirydate, (String)calculationForEndDate);
                entryObj.set(produceKey, (Object)producedate);
            }
        }
        if (producedate != null && expirydate != null && producedate.after(expirydate)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u671f\u3002", (String)"ShelflifeMgrValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

