/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.impt.ImptDataSourceHelper;
import kd.scmc.im.business.helper.impt.ImptValidateHelper;
import kd.scmc.im.business.pojo.GeneralValResultInfo;
import kd.scmc.im.validator.improt.InvBillImptDetailsValidator;

public class TransDirImptValidator
extends InvBillImptDetailsValidator {
    private static final String BILLCRETYPE_IMPORT = "1";
    private List<Long> hasPermissionOrgs = new ArrayList<Long>();
    private static final Log logger = LogFactory.getLog(TransDirImptValidator.class);
    private Map<Long, Set<Long>> whIdToLocationIdsMap = new HashMap<Long, Set<Long>>(64);

    @Override
    public void validate() {
        super.validate();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashMap<Long, Long> outOrgToDefDept = new HashMap<Long, Long>();
        ArrayList<ExtendedDataEntity> imptDataEntities = new ArrayList<ExtendedDataEntity>();
        for (int i = 0; i < this.dataEntities.length; ++i) {
            ExtendedDataEntity dataEntity = this.dataEntities[i];
            DynamicObject billObj = dataEntity.getDataEntity();
            String billCreType = billObj.getString("billcretype");
            if (!BILLCRETYPE_IMPORT.equals(billCreType)) continue;
            if (i == 0) {
                RequestContext requestContext = RequestContext.get();
                String currUserId = requestContext.getUserId();
                this.hasPermissionOrgs = TransDirImptValidator.getHasPermissionOrgs("im_transdirbill", this.getValidateContext().getBillEntityType().getAppId()).get(currUserId);
            }
            DynamicObject outOrg = billObj.getDynamicObject("outorg");
            DynamicObject inOrg = billObj.getDynamicObject("org");
            Long outOrgId = outOrg == null ? 0L : outOrg.getLong("id");
            Long inOrgId = inOrg == null ? 0L : inOrg.getLong("id");
            if (this.hasPermissionOrgs == null || this.hasPermissionOrgs.isEmpty()) continue;
            String transType = billObj.getString("transtype");
            DynamicObject org = billObj.getDynamicObject("org");
            Map<String, Object> checkOrgResult = this.checkOrg(outOrg, org, transType);
            boolean isSuccess = (Boolean)checkOrgResult.get("isSuccess");
            if (!isSuccess) {
                String errMsg = String.valueOf(checkOrgResult.get("errMsg"));
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            orgIds.add(outOrgId);
            orgIds.add(inOrgId);
            imptDataEntities.add(dataEntity);
        }
        if (imptDataEntities.isEmpty()) {
            return;
        }
        this.checkImptDataDetails(orgIds, imptDataEntities, outOrgToDefDept);
    }

    @Override
    protected void cacheData(ExtendedDataEntity[] dataEntities) {
        super.cacheData(dataEntities);
        this.cacheWhIdToLocationIds(dataEntities);
    }

    private void cacheWhIdToLocationIds(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> whIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObjectCollection entries = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                DynamicObject outWh = entry.getDynamicObject("outwarehouse");
                if (outWh == null) continue;
                whIds.add(outWh.getLong("id"));
            }
        }
        DataSet whDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])new QFilter("id", "in", whIds).toArray(), (String)"");
        while (whDs.hasNext()) {
            Row wh = whDs.next();
            Long whId = wh.getLong("id");
            Long locationId = wh.getLong("entryentity.location");
            if (locationId == 0L) continue;
            Set locationIds = this.whIdToLocationIdsMap.computeIfAbsent(whId, key -> new HashSet());
            locationIds.add(locationId);
        }
    }

    private void checkImptDataDetails(Set<Long> orgIds, List<ExtendedDataEntity> imptDataEntities, Map<Long, Long> outOrgToDefDept) {
        Map orgToDepts = ImptDataSourceHelper.getOrgToDepts(orgIds, outOrgToDefDept);
        Map warehouseData = ImptDataSourceHelper.getOrgToWarehouses(orgIds);
        Map orgToAccountOwners = ImptDataSourceHelper.getOrgToAccountOwners(orgIds);
        String billType = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        String transDirOutLocation = "outlocation.id";
        for (ExtendedDataEntity dataEntity : imptDataEntities) {
            List inDeptIds;
            GeneralValResultInfo inDeptResult;
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObject outOrg = billObj.getDynamicObject("outorg");
            DynamicObject inOrg = billObj.getDynamicObject("org");
            if (outOrg == null) {
                String errMsg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8c03\u51fa\u7ec4\u7ec7", (String)"TransDirImptValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            Long outOrgId = outOrg.getLong("id");
            List deptIds = (List)orgToDepts.get(outOrgId);
            GeneralValResultInfo ckDeptResult = this.checkDept(deptIds, outOrg, billObj.getDynamicObject("outdept"));
            boolean isCkSuccess = ckDeptResult.getIsVaild();
            if (!isCkSuccess) {
                String errMsg = ckDeptResult.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            if (inOrg != null && !(isCkSuccess = (inDeptResult = this.checkDept(inDeptIds = (List)orgToDepts.get(inOrg.getPkValue()), inOrg, billObj.getDynamicObject("dept"))).getIsVaild().booleanValue())) {
                String errMsg = inDeptResult.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            Set warehouseIds = (Set)warehouseData.get(outOrgId);
            List accountOwners = (List)orgToAccountOwners.get(outOrgId);
            boolean isNext = false;
            DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entryObj : billEntrys) {
                isCkSuccess = this.checkByInvData(dataEntity, entryObj, accountOwners, billType);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                DynamicObject outWarehouse = entryObj.getDynamicObject("outwarehouse");
                isCkSuccess = this.checkWarehouse(dataEntity, entryObj, warehouseIds, outWarehouse, outOrg);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                isCkSuccess = this.checkLocationOfWh(dataEntity, entryObj, outWarehouse, transDirOutLocation, this.whIdToLocationIdsMap);
                if (isCkSuccess) continue;
                isNext = true;
                break;
            }
            if (!isNext) continue;
        }
    }

    private boolean checkByInvData(ExtendedDataEntity dataEntity, DynamicObject entryObj, List<Object> accountOwners, String billType) {
        DynamicObject billObj = dataEntity.getDataEntity();
        String outOwnerType = entryObj.getString("outownertype");
        DynamicObject outOwner = entryObj.getDynamicObject("outowner");
        DynamicObject outOrg = billObj.getDynamicObject("outorg");
        DynamicObject reqOrg = entryObj.getDynamicObject("entryinorg");
        Boolean isCkSuccess = true;
        GeneralValResultInfo ckOutOwnerRes = ImptValidateHelper.checkOwner((DynamicObject)billObj, (String)outOwnerType, (DynamicObject)outOwner, (DynamicObject)reqOrg, (DynamicObject)outOrg, accountOwners, (String)billType);
        isCkSuccess = ckOutOwnerRes.getIsVaild();
        if (!isCkSuccess.booleanValue()) {
            String errMsg = ckOutOwnerRes.getValResult();
            this.addErrorMessage(dataEntity, errMsg);
            return false;
        }
        return true;
    }

    private Map<String, Object> checkOrg(DynamicObject outOrg, DynamicObject org, String transType) {
        HashMap<String, Object> checkResult = new HashMap<String, Object>(16);
        if (outOrg == null) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8c03\u51fa\u7ec4\u7ec7\u3002", (String)"TransDirImptValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            checkResult.put("isSuccess", Boolean.FALSE);
            checkResult.put("errMsg", errMsg);
            return checkResult;
        }
        Long outOrgId = outOrg.getLong("id");
        String outOrgNum = outOrg.getString("number");
        Long inOrgId = org == null ? 0L : org.getLong("id");
        String inOrgNum = org == null ? "" : org.getString("number");
        HashSet<Long> perOrgIdSet = new HashSet<Long>(this.hasPermissionOrgs);
        if (!perOrgIdSet.contains(outOrgId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u51fa\u5e93\u7ec4\u7ec7\u201c%s\u201d\u65e0\u6743\u9650\u3002", (String)"TransDirImptValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), outOrgNum);
            checkResult.put("isSuccess", Boolean.FALSE);
            checkResult.put("errMsg", errMsg);
            return checkResult;
        }
        if ("A".equals(transType)) {
            if (!outOrgId.equals(inOrgId)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u8c03\u62e8\u7684\u51fa\u5e93\u7ec4\u7ec7\u201c%1s\u201d\u5fc5\u987b\u4e0e\u5165\u5e93\u7ec4\u7ec7\u201c%2s\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"TransDirImptValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), outOrgNum, inOrgNum);
                checkResult.put("isSuccess", Boolean.FALSE);
                checkResult.put("errMsg", errMsg);
                return checkResult;
            }
        } else if (outOrgId.equals(inOrgId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u8c03\u62e8\u7684\u51fa\u5e93\u7ec4\u7ec7\u201c%1s\u201d\u4e0e\u5165\u5e93\u7ec4\u7ec7\u201c%2s\u201d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"TransDirImptValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), outOrgNum, inOrgNum);
            checkResult.put("isSuccess", Boolean.FALSE);
            checkResult.put("errMsg", errMsg);
            return checkResult;
        }
        checkResult.put("isSuccess", Boolean.TRUE);
        return checkResult;
    }

    public static Map<String, List<Long>> getHasPermissionOrgs(String formId, String appId) {
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        HashMap<String, List<Long>> userToPermissOrgs = new HashMap<String, List<Long>>();
        List hasPermissionOrgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg((String)formId, (String)appId);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return new HashMap<String, List<Long>>();
        }
        for (Map orgData : hasPermissionOrgs) {
            if (!userToPermissOrgs.containsKey(currUserId)) {
                userToPermissOrgs.put(currUserId, new ArrayList(10));
            }
            Long pOrgId = Long.valueOf((String)orgData.get("id"));
            ((List)userToPermissOrgs.get(currUserId)).add(pOrgId);
        }
        return userToPermissOrgs;
    }

    private GeneralValResultInfo checkDept(List<Long> deptIds, DynamicObject org, DynamicObject dept) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        String orgNum = org == null ? "" : org.getString("number");
        Long deptId = dept == null ? 0L : dept.getLong("id");
        if (dept != null && deptIds != null && !deptIds.contains(deptId)) {
            String deptNum = dept.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u5e93\u7ba1\u90e8\u95e8\u201c%2$s\u201d\u3002", (String)"TransDirImptValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum, deptNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }
}

