/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class TransFormImportValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(TransFormImportValidator.class);
    private Map<Long, Set<Object>> billBizTypeMap = new HashMap<Long, Set<Object>>();

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"TransFormImportValidator", (String)"validate");){
            DynamicObjectCollection subEntrys;
            DynamicObjectCollection billentrys;
            ArrayList<ExtendedDataEntity> imptEntitys = new ArrayList<ExtendedDataEntity>();
            HashSet<Long> orgIds = new HashSet<Long>();
            HashSet<Long> warehouseIds = new HashSet<Long>();
            HashSet<Long> auptyIds = new HashSet<Long>();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject billObj = dataEntity.getDataEntity();
                String billCreType = billObj.getString("billcretype");
                if (!"1".equals(billCreType) && !"3".equals(billCreType)) continue;
                imptEntitys.add(dataEntity);
                DynamicObject data = dataEntity.getDataEntity();
                billentrys = data.getDynamicObjectCollection("billentry");
                orgIds.add(data.getLong("org_id"));
                for (DynamicObject entry : billentrys) {
                    warehouseIds.add(entry.getLong("warehouse_id"));
                    auptyIds.add(entry.getLong("auxpty_id"));
                    subEntrys = entry.getDynamicObjectCollection("afterentity");
                    for (DynamicObject subEntry : subEntrys) {
                        warehouseIds.add(subEntry.getLong("warehouse1_id"));
                        auptyIds.add(subEntry.getLong("auxpty1_id"));
                    }
                }
            }
            Map<String, DynamicObject> warehouseSetMap = this.getWarehouseSetMap(orgIds, warehouseIds);
            Map<Long, Set<Long>> locationMap = this.getLocationMap(warehouseIds);
            Map<String, DynamicObject> auxptySetMap = this.getAuxptySetMap(auptyIds);
            for (ExtendedDataEntity dataEntity : imptEntitys) {
                DynamicObject billObj = dataEntity.getDataEntity();
                DynamicObject org = billObj.getDynamicObject("org");
                this.checkBizType(dataEntity);
                billentrys = billObj.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    subEntrys = billentry.getDynamicObjectCollection("afterentity");
                    this.checkQtyRate(dataEntity, billentry, false);
                    this.checkQty2ndRate(dataEntity, billentry, false);
                    this.checkWarehouse(dataEntity, billentry, org, warehouseSetMap, locationMap, false);
                    this.checkAuxpty(dataEntity, billentry, false, auxptySetMap);
                    for (DynamicObject subEntry : subEntrys) {
                        this.checkQtyRate(dataEntity, subEntry, true);
                        this.checkQty2ndRate(dataEntity, subEntry, true);
                        this.checkWarehouse(dataEntity, subEntry, org, warehouseSetMap, locationMap, true);
                        this.checkAuxpty(dataEntity, subEntry, true, auxptySetMap);
                    }
                }
            }
        }
    }

    private Map<Long, Set<Long>> getLocationMap(Set<Long> warehouseIds) {
        HashMap<Long, Set<Long>> locationMap = new HashMap<Long, Set<Long>>();
        DataSet whDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])new QFilter("id", "in", warehouseIds).toArray(), (String)"");
        while (whDs.hasNext()) {
            Row wh = whDs.next();
            Long whId = wh.getLong("id");
            Long locationId = wh.getLong("entryentity.location");
            if (locationId == 0L) continue;
            Set locationIds = locationMap.computeIfAbsent(whId, key -> new HashSet(16));
            locationIds.add(locationId);
        }
        whDs.close();
        return locationMap;
    }

    private void checkAuxpty(ExtendedDataEntity dataEntity, DynamicObject billentry, boolean isSubEntry, Map<String, DynamicObject> auxptySetMap) {
        String materialKey = isSubEntry ? "material1" : "material";
        String auxptyKey = isSubEntry ? "auxpty1" : "auxpty";
        DynamicObject mat = billentry.getDynamicObject(materialKey);
        if (mat == null) {
            return;
        }
        DynamicObject materialObj = mat.getDynamicObject("masterid");
        String materialNum = materialObj.getString("number");
        boolean isuseauxpty = materialObj.getBoolean("isuseauxpty");
        DynamicObject auxpty = billentry.getDynamicObject(auxptyKey);
        if (isuseauxpty && auxpty == null) {
            long auxptyId = billentry.getLong(auxptyKey + "_id");
            logger.info(String.format("=====TransFormImportValidator=====\u5f85\u6821\u9a8c\u8f85\u52a9\u5c5e\u6027id\uff1a%s", auxptyId));
            if (!auxptySetMap.containsKey(String.valueOf(auxptyId))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u503c\u3002", (String)"InvBillImptDetailsValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum));
            }
        }
    }

    private void checkWarehouse(ExtendedDataEntity dataEntity, DynamicObject billentry, DynamicObject org, Map<String, DynamicObject> warehouseSetMap, Map<Long, Set<Long>> locationMap, boolean isSubEntry) {
        String warehouseKey = isSubEntry ? "warehouse1" : "warehouse";
        String locationKey = isSubEntry ? "location1" : "location";
        DynamicObject warehouse = billentry.getDynamicObject(warehouseKey);
        if (warehouse == null || org == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(org.getPkValue());
        sb.append("_");
        sb.append(warehouse.getPkValue());
        DynamicObject warehouseSet = warehouseSetMap.get(sb.toString());
        if (warehouseSet == null) {
            String msg = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSESET_NOTEXIT(), (Object[])new Object[]{org.getString("name"), warehouse.getString("name")});
            this.addErrorMessage(dataEntity, msg);
            return;
        }
        String initStatus = warehouseSet.getString("initstatus");
        if ("A".equals(initStatus)) {
            String msg = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSE_UNINIT(), (Object[])new Object[]{org.getString("name"), warehouse.getString("name")});
            this.addErrorMessage(dataEntity, msg);
            return;
        }
        DynamicObject location = billentry.getDynamicObject(locationKey);
        if (location == null) {
            return;
        }
        boolean isOpenLocation = warehouseSet.getBoolean("warehouse.isopenlocation");
        if (!isOpenLocation) {
            String msg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93'%1$s'\u672a\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"TransFormImportValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), warehouse.getString("name"));
            this.addErrorMessage(dataEntity, msg);
        }
        boolean hasLocation = false;
        Set<Long> locationIds = locationMap.get(warehouse.getPkValue());
        if (locationIds != null) {
            for (Long locationId : locationIds) {
                if (!location.getPkValue().equals(locationId)) continue;
                hasLocation = true;
                break;
            }
        }
        if (!hasLocation) {
            String msg = ResManager.loadKDString((String)"\u4ed3\u5e93{0}{1}{2}\u4e0d\u5b58\u5728{3}{4}{5}\u7684\u4ed3\u4f4d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"TransFormImportValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[]{"'", warehouse.getString("name"), "'", "'", location.getString("name"), "'"});
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private Map<String, DynamicObject> getWarehouseSetMap(Set<Long> orgIds, Set<Long> warehouseIds) {
        HashMap<String, DynamicObject> warehouseSetMap = new HashMap<String, DynamicObject>(16);
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("startstatus", "=", (Object)"B");
        filter.and("org", "in", orgIds);
        filter.and("warehouse", "in", warehouseIds);
        Map warehousesetupMap = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"org,warehouse.id,warehouse.isopenlocation,initstatus", (QFilter[])filter.toArray());
        for (DynamicObject warehousesetup : warehousesetupMap.values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(warehousesetup.getLong("org_id"));
            sb.append("_");
            sb.append(warehousesetup.getLong("warehouse.id"));
            warehouseSetMap.put(sb.toString(), warehousesetup);
        }
        return warehouseSetMap;
    }

    private Map<String, DynamicObject> getAuxptySetMap(Set<Long> auxptyIds) {
        DynamicObject[] auxptySetMap;
        HashMap<String, DynamicObject> auxptyIdSetMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject auxpty : auxptySetMap = BusinessDataServiceHelper.load((String)"bd_flexauxprop", (String)"id,value", (QFilter[])new QFilter("id", "in", auxptyIds).toArray())) {
            auxptyIdSetMap.put(auxpty.getString("id"), auxpty);
        }
        logger.info(String.format("=====TransFormImportValidator===== \u6839\u636e\u8f85\u52a9\u5c5e\u6027id\uff1a%s\uff0c\u53d6\u5f97\u8f85\u52a9\u5c5e\u6027\uff1a%s", auxptyIds, auxptyIdSetMap));
        return auxptyIdSetMap;
    }

    private void checkQtyRate(ExtendedDataEntity dataEntity, DynamicObject billentry, boolean isSubEntry) {
        String unitKey = isSubEntry ? "unit1" : "unit";
        String qtyKey = isSubEntry ? "qty1" : "qty";
        DynamicObject unit = billentry.getDynamicObject(unitKey);
        BigDecimal qty = billentry.getBigDecimal(qtyKey);
        if (unit == null || qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int Precision = unit.getInt("precision");
        if ((qty = qty.stripTrailingZeros()).scale() <= Precision) {
            return;
        }
        int seq = billentry.getInt("seq");
        String entryName = billentry.getDataEntityType().getDisplayName().getLocaleValue();
        int pSeq = 0;
        String pEntryName = null;
        if (isSubEntry) {
            DynamicObject parent = (DynamicObject)billentry.getParent();
            pSeq = parent.getInt("seq");
            pEntryName = parent.getDataEntityType().getDisplayName().getLocaleValue();
        }
        String tip = null;
        tip = isSubEntry ? String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5206\u5f55\u4e2d\uff0c%3$s\u7b2c%4$s\u884c\u6570\u91cf\u7cbe\u5ea6\u8d85\u8fc7\u4e86\u8ba1\u91cf\u5355\u4f4d\u7cbe\u5ea6\u3002", (String)"TransFormImportValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), pEntryName, pSeq, entryName, seq) : String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u6570\u91cf\u7cbe\u5ea6\u8d85\u8fc7\u4e86\u8ba1\u91cf\u5355\u4f4d\u7cbe\u5ea6\u3002", (String)"TransFormImportValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), entryName, seq);
        this.addErrorMessage(dataEntity, tip);
    }

    private void checkQty2ndRate(ExtendedDataEntity dataEntity, DynamicObject billentry, boolean isSubEntry) {
        String materialKey = isSubEntry ? "material1" : "material";
        String qty2ndKey = isSubEntry ? "qtyunit2nd1" : "qtyunit2nd";
        DynamicObject material = billentry.getDynamicObject(materialKey);
        if (material == null) {
            return;
        }
        DynamicObject auxptyunit = material.getDynamicObject("masterid.auxptyunit");
        BigDecimal qty = billentry.getBigDecimal(qty2ndKey);
        if (auxptyunit == null || qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int Precision = auxptyunit.getInt("precision");
        if ((qty = qty.stripTrailingZeros()).scale() <= Precision) {
            return;
        }
        int seq = billentry.getInt("seq");
        String entryName = billentry.getDataEntityType().getDisplayName().getLocaleValue();
        int pSeq = 0;
        String pEntryName = null;
        if (isSubEntry) {
            DynamicObject parent = (DynamicObject)billentry.getParent();
            pSeq = parent.getInt("seq");
            pEntryName = parent.getDataEntityType().getDisplayName().getLocaleValue();
        }
        String tip = null;
        tip = isSubEntry ? String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5206\u5f55\u4e2d\uff0c%3$s\u7b2c%4$s\u884c\u8f85\u52a9\u6570\u91cf\u7cbe\u5ea6\u8d85\u8fc7\u4e86\u8f85\u52a9\u5355\u4f4d\u7cbe\u5ea6\u3002", (String)"TransFormImportValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), pEntryName, pSeq, entryName, seq) : String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u8f85\u52a9\u6570\u91cf\u7cbe\u5ea6\u8d85\u8fc7\u4e86\u8f85\u52a9\u5355\u4f4d\u7cbe\u5ea6\u3002", (String)"TransFormImportValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), entryName, seq);
        this.addErrorMessage(dataEntity, tip);
    }

    private void checkBizType(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObject billType = data.getDynamicObject("billtype");
        DynamicObject bizType = data.getDynamicObject("biztype");
        if (billType == null || bizType == null) {
            return;
        }
        Long billTypeId = (Long)billType.getPkValue();
        Set<Object> bizIds = this.billBizTypeMap.get(billTypeId);
        if (bizIds == null) {
            bizIds = new HashSet<Object>();
            String formId = data.getDataEntityType().getName();
            bizIds.addAll(BizTypeHelper.getBizTypeIds((Object)billTypeId, (String)formId));
            this.billBizTypeMap.put(billTypeId, bizIds);
        }
        if (!bizIds.contains(bizType.getPkValue())) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\uff1a\u5bfc\u5165\u7684\u4e1a\u52a1\u7c7b\u578b\u548c\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"TransFormImportHandle_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getString("billno")));
        }
    }
}

