/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt.invbiz;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.im.business.helper.importdata.ImptDataSourceHelper;
import kd.scmc.im.business.helper.importdata.ImptValidateHelper;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.business.pojo.ValidateResultCollection;
import kd.scmc.im.validator.improt.AbstractBillImptValidator;
import kd.scmc.im.validator.improt.billFiledMapper.BillFieldMapper;
import kd.scmc.im.validator.improt.billFiledMapper.BillFieldMapperFactory;

public class InvBillTplImptValidator
extends AbstractBillImptValidator {
    protected Map<Long, Set<Long>> orgMaterialMapping = new HashMap<Long, Set<Long>>(16);
    protected Map<Long, Set<Long>> orgToMaterials;

    public Map<Long, Set<Long>> getOrgToMaterials() {
        if (this.orgToMaterials == null) {
            this.orgToMaterials = ImptDataSourceHelper.getOrgToMasterData(this.orgMaterialMapping);
        }
        return this.orgToMaterials;
    }

    @Override
    protected void cacheEntryData(DynamicObject billObj, DynamicObject entryObj) {
        this.cacheOrgMaterial(billObj, entryObj);
    }

    @Deprecated
    protected void checkAvailableMaterial(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
    }

    protected void checkComment(DynamicObject billObj, String billId, ValidateResultCollection validateResults) {
        Map commentData = (Map)billObj.get("comment");
        if (commentData == null || commentData.isEmpty()) {
            return;
        }
        ValidateResult valCommRes = ImptValidateHelper.checkComment((Map)commentData);
        if (!valCommRes.getIsVaild().booleanValue()) {
            validateResults.addValidateResult(billId, valCommRes);
        }
    }

    private void cacheOrgMaterial(DynamicObject billObj, DynamicObject entryObj) {
        BillFieldMapper billFieldMapper = BillFieldMapperFactory.getBillFieldMapper(this.getBillKey());
        DynamicObject org = billObj.getDynamicObject(billFieldMapper.getInvOrgKey());
        DynamicObject material = entryObj.getDynamicObject(billFieldMapper.getMaterialKey());
        if (material == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long materialId = material.getLong("masterid.id");
        if (!this.orgMaterialMapping.containsKey(orgId)) {
            this.orgMaterialMapping.put(orgId, new HashSet());
        }
        this.orgMaterialMapping.get(orgId).add(materialId);
        if (billFieldMapper.hasSubEntry() && billFieldMapper.getSubEntryBillFiledMapper() != null) {
            DynamicObject subMaterial = entryObj.getDynamicObject(billFieldMapper.getSubEntryBillFiledMapper().getMaterialKey());
            Long subMaterialId = subMaterial.getLong("masterid.id");
            this.orgMaterialMapping.get(orgId).add(subMaterialId);
        }
    }

    @Override
    protected void checkF7(DynamicObject billObj, ValidateResultCollection validateResults) {
    }

    @Override
    protected void checkEntryF7(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        super.checkEntryF7(billObj, entryObj, validateResults);
    }
}

