/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt.invbiz.ininv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.importdata.ImptDataSourceHelper;
import kd.scmc.im.business.helper.importdata.ImptValidateHelper;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.business.pojo.ValidateResultCollection;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.BizTypeConsts;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.validator.improt.billFiledMapper.BillFieldMapper;
import kd.scmc.im.validator.improt.billFiledMapper.BillFieldMapperFactory;
import kd.scmc.im.validator.improt.invbiz.InvBillTplImptValidator;
import org.apache.commons.lang3.StringUtils;

public class InvInTplImptValidator
extends InvBillTplImptValidator {
    private static final String VMI_KEY = "vmi";
    private static final String ASSET_KEY = "asset";
    private static final String BOS_ORG = "bos_org";
    private Set<Long> orgIds = new HashSet<Long>(16);
    private Set<Long> purOrgIds = new HashSet<Long>(16);
    private Set<String> billBizTypeKeys = new HashSet<String>(16);
    private Map<Object, DynamicObject> invSchemeMapping = new HashMap<Object, DynamicObject>(16);
    private Set<Long> useAuxtyMaterials = new HashSet<Long>(16);
    private Map<Long, Long> materialToBaseUnit = new HashMap<Long, Long>(16);
    private Map<Object, DynamicObject> ownerMapping = new HashMap<Object, DynamicObject>(16);
    private Map<String, Map<Long, Set<Long>>> orgOperatorGroupMapping = new HashMap<String, Map<Long, Set<Long>>>(16);
    private Map<Object, DynamicObject> settleTypeMapping = new HashMap<Object, DynamicObject>(16);
    private Map<Object, DynamicObject> payConditionMapping = new HashMap<Object, DynamicObject>(16);
    private Map<Object, DynamicObject> cacheTaxRateIdMapping = new HashMap<Object, DynamicObject>(16);
    private Map<Long, List<Object>> supplierMaps = new HashMap<Long, List<Object>>(16);
    private Map<Long, List<Object>> customerMaps = new HashMap<Long, List<Object>>(16);
    private Set<Long> bizTypeIds;
    private Map<Long, List<Long>> invToPurOrgs;
    private Map<String, List<Long>> billBizTypeToInvSchemes;
    private Map<Long, List<Long>> orgDeptMapping;
    private Map<Long, List<Long>> orgBizDeptMapping;
    private Map<Long, List<Long>> purOrgBizDeptMapping;
    private Map<String, Object> auxptyData;
    private Map<Long, Set<Long>> orgWarehouseMapping;
    private Map<Long, List<Object>> orgToAccOwners;
    private Map<Long, Set<Long>> materialToUnits;
    private Map<Long, DynamicObject> bosOrgUsedMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Set<Long>> orgAndSupIds = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> org2Warehouse = new HashMap<Long, Set<Long>>();
    private Map<String, Boolean> isUnitRateConv = new HashMap<String, Boolean>();

    public DynamicObject getBosOrgUsedMap(Long id) {
        DynamicObject bosOrg;
        if (this.bosOrgUsedMap.containsKey(id)) {
            bosOrg = this.bosOrgUsedMap.get(id);
        } else {
            QFilter filter = new QFilter("id", "=", (Object)id);
            bosOrg = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG, (String)"id,enable", (QFilter[])filter.toArray());
            this.bosOrgUsedMap.put(id, bosOrg);
        }
        return bosOrg;
    }

    protected Set<Long> getOrgIds() {
        return this.orgIds;
    }

    protected Set<Long> getPurOrgIds() {
        return this.purOrgIds;
    }

    public Map<Object, DynamicObject> getOwnerMapping(Object ownerId) {
        if (!this.ownerMapping.containsKey(ownerId)) {
            DynamicObject ownerObj = ImptDataSourceHelper.getDefaultOwner((Object)ownerId);
            this.ownerMapping.putIfAbsent(ownerId, ownerObj);
        }
        return this.ownerMapping;
    }

    public Map<Long, Set<Long>> getOrgOperatorGroupMapping(Long orgId, String operatorGrpType) {
        String key = orgId + "_" + operatorGrpType;
        if (this.orgOperatorGroupMapping.get(key) == null) {
            Map orgToOperatorGroup = ImptDataSourceHelper.getOrgToOperatorGroup((Long)orgId, (String)operatorGrpType);
            this.orgOperatorGroupMapping.put(key, orgToOperatorGroup);
            this.orgOperatorGroupMapping.putIfAbsent(key, orgToOperatorGroup);
        }
        return this.orgOperatorGroupMapping.get(key);
    }

    public List<Object> getSupplierMaps(Long orgId, Object supplierId) {
        List<Object> supplierIds = this.supplierMaps.get(orgId);
        if (supplierIds == null || !supplierIds.contains(supplierId)) {
            Map supplierMap = ImptDataSourceHelper.getOrgToSupplier((Long)orgId, (Object)supplierId);
            if (supplierMap.containsKey(supplierId)) {
                if (supplierIds == null) {
                    supplierIds = new ArrayList<Object>(16);
                    supplierIds.add(supplierId);
                } else {
                    supplierIds.add(supplierId);
                }
            }
            this.supplierMaps.put(orgId, supplierIds);
        }
        return supplierIds;
    }

    public List<Object> getCustomerMaps(Long orgId, Object customerId) {
        List<Object> customerIds = this.customerMaps.get(orgId);
        if (customerIds == null || !customerIds.contains(customerId)) {
            Map customerMap = ImptDataSourceHelper.getOrgToCustomer((Long)orgId, (Object)customerId);
            if (customerMap.containsKey(customerId)) {
                if (customerIds == null) {
                    customerIds = new ArrayList<Object>(16);
                    customerIds.add(customerId);
                } else {
                    customerIds.add(customerId);
                }
            }
            this.customerMaps.put(orgId, customerIds);
        }
        return customerIds;
    }

    public Map<Long, List<Long>> getInvToPurOrgs() {
        if (this.invToPurOrgs == null) {
            this.invToPurOrgs = ImptDataSourceHelper.getInvToPurOrgs(this.orgIds);
        }
        return this.invToPurOrgs;
    }

    public Set<Long> getBizTypeIds() {
        if (this.bizTypeIds == null) {
            this.bizTypeIds = ImptDataSourceHelper.getBizTypes((String)this.getBillKey());
        }
        return this.bizTypeIds;
    }

    public Map<String, List<Long>> getBillBizTypeToInvSchemes() {
        if (this.billBizTypeToInvSchemes == null) {
            this.billBizTypeToInvSchemes = ImptDataSourceHelper.getBillBizTypeToInvSchemes(this.billBizTypeKeys);
        }
        return this.billBizTypeToInvSchemes;
    }

    public Map<Long, List<Long>> getOrgDeptMapping() {
        if (this.orgDeptMapping == null) {
            this.orgDeptMapping = ImptDataSourceHelper.getOrgToDepts1(this.orgIds);
        }
        return this.orgDeptMapping;
    }

    public Map<Long, List<Long>> getOrgBizDeptMapping() {
        if (this.orgBizDeptMapping == null) {
            this.orgBizDeptMapping = ImptDataSourceHelper.getOrgToDepts1(this.orgIds);
        }
        return this.orgBizDeptMapping;
    }

    public Map<Long, List<Long>> getPurOrgBizDeptMapping() {
        if (this.purOrgBizDeptMapping == null) {
            this.purOrgBizDeptMapping = ImptDataSourceHelper.getOrgToDepts1(this.purOrgIds);
        }
        return this.purOrgBizDeptMapping;
    }

    public Map<String, Object> getMaterialToAuxptys() {
        if (this.auxptyData == null) {
            this.auxptyData = ImptDataSourceHelper.getMaterialToAuxptys(this.useAuxtyMaterials);
        }
        return this.auxptyData;
    }

    public Map<Long, Set<Long>> getOrgWarehouseMapping() {
        if (this.orgWarehouseMapping == null) {
            this.orgWarehouseMapping = ImptDataSourceHelper.getOrgToWarehouses(this.orgIds);
        }
        return this.orgWarehouseMapping;
    }

    public Map<Long, List<Object>> getOrgToAccOwners() {
        if (this.orgToAccOwners == null) {
            this.orgToAccOwners = ImptDataSourceHelper.getOrgToAccountOwners(this.orgIds);
        }
        return this.orgToAccOwners;
    }

    public Map<Long, Set<Long>> getFixedConvertTypeUnits() {
        if (this.materialToUnits == null) {
            this.materialToUnits = ImptDataSourceHelper.getFixedConvertTypeUnits(this.materialToBaseUnit);
        }
        return this.materialToUnits;
    }

    protected void cacheOrgIds(DynamicObject billObj) {
        DynamicObject org = billObj.getDynamicObject("org");
        if (org != null) {
            this.orgIds.add((Long)org.getPkValue());
        }
    }

    protected void cachePurOrgIds(DynamicObject billObj, String Key) {
        DynamicObject org = billObj.getDynamicObject(Key);
        if (org != null) {
            this.purOrgIds.add((Long)org.getPkValue());
        }
    }

    public Map<Object, DynamicObject> getCacheTaxRateIdMapping() {
        if (this.cacheTaxRateIdMapping.isEmpty()) {
            this.cacheTaxRateIdMapping = ImptDataSourceHelper.cacheTaxRateId();
        }
        return this.cacheTaxRateIdMapping;
    }

    protected void cacheBillBizTypeKeys(DynamicObject billObj) {
        DynamicObject bizType = billObj.getDynamicObject("biztype");
        if (bizType != null) {
            Object bizTypeId = bizType.getPkValue();
            String billBizTypeKey = this.getBillKey() + "." + bizTypeId;
            this.billBizTypeKeys.add(billBizTypeKey);
        }
    }

    protected void cacheInvSchemeMapping(DynamicObject billObj) {
        DynamicObject invScheme = billObj.getDynamicObject("invscheme");
        if (invScheme != null) {
            Object pkValue = invScheme.getPkValue();
            if (this.invSchemeMapping.get(pkValue) == null) {
                invScheme = ImptDataSourceHelper.cacheInvScheme((Object)pkValue);
                this.invSchemeMapping.put(pkValue, invScheme);
                billObj.set("invscheme", (Object)invScheme);
            } else {
                billObj.set("invscheme", (Object)this.invSchemeMapping.get(pkValue));
            }
        }
    }

    public Map<Object, DynamicObject> getSettleTypeMapping() {
        if (this.settleTypeMapping.isEmpty()) {
            this.settleTypeMapping = ImptDataSourceHelper.cacheSettleType();
        }
        return this.settleTypeMapping;
    }

    public Map<Object, DynamicObject> getPayConditionMapping() {
        if (this.payConditionMapping.isEmpty()) {
            this.payConditionMapping = ImptDataSourceHelper.cachePayCondition();
        }
        return this.payConditionMapping;
    }

    protected void cacheAuxtyMaterials(DynamicObject entryObj) {
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        if (!ImptValidateHelper.isEnableAuxpty((DynamicObject)materialInfo)) {
            return;
        }
        DynamicObject materialObj = materialInfo.getDynamicObject("masterid");
        Long materialId = materialObj.getLong("id");
        this.useAuxtyMaterials.add(materialId);
    }

    protected void cacheMlToBaseUnit(DynamicObject entryObj) {
        DynamicObject materialStategy = entryObj.getDynamicObject("material");
        if (materialStategy == null) {
            return;
        }
        DynamicObject materialObj = materialStategy.getDynamicObject("masterid");
        Long baseUnitId = materialObj.getLong("baseunit.id");
        Long materialId = materialObj.getLong("id");
        this.materialToBaseUnit.put(materialId, baseUnitId);
    }

    protected void checkBizType(DynamicObject billObj, ValidateResultCollection validateResults) {
        String billNo = billObj.getDataEntityType().getName();
        DynamicObject billType = billObj.getDynamicObject("billtype");
        String billId = String.valueOf(billObj.getPkValue());
        if (billType == null) {
            ValidateResult valResultInfo = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvInTplImptValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, valResultInfo);
            return;
        }
        DynamicObject bizType = billObj.getDynamicObject("biztype");
        if (bizType == null) {
            return;
        }
        ValidateResult valBizTypeRes = ImptValidateHelper.checkBizType((List)BizTypeHelper.getBizTypeIds((Object)billType.getPkValue(), (String)billNo), (DynamicObject)bizType, (DynamicObject)billType);
        validateResults.addValidateResult(billId, valBizTypeRes);
    }

    protected void checkInvschemes(DynamicObject billObj, ValidateResultCollection validateResults) {
        DynamicObject invschemeDy = billObj.getDynamicObject("invscheme");
        DynamicObject bizType = billObj.getDynamicObject("biztype");
        if (invschemeDy == null) {
            return;
        }
        String billId = String.valueOf(billObj.getPkValue());
        if (bizType == null) {
            String errMsg = ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u201c%s\u201d\u7981\u7528\u6216\u4e0e\u5355\u636e\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"InvInTplImptValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            ValidateResult validateResult = new ValidateResult();
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
            return;
        }
        Long billBizTypeId = bizType.getLong("id");
        ValidateResult valInvschemeRes = ImptValidateHelper.checkInvSchemes((DynamicObject)invschemeDy, (Long)billBizTypeId);
        validateResults.addValidateResult(billId, valInvschemeRes);
    }

    protected void checkDept(DynamicObject billObj, ValidateResultCollection validateResults) {
        DynamicObject org = billObj.getDynamicObject("org");
        if (org == null) {
            return;
        }
        List<Long> invDepts = this.getOrgDeptMapping().get((Long)org.getPkValue());
        ValidateResult validateResult = ImptValidateHelper.checkDept((DynamicObject)billObj, invDepts);
        String billId = String.valueOf(billObj.getPkValue());
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkPurDept(DynamicObject billObj, ValidateResultCollection validateResults, String purOrgKey, String purDeptKey) {
        DynamicObject org = billObj.getDynamicObject(purOrgKey);
        if (org == null) {
            return;
        }
        List<Long> invDepts = this.getPurOrgBizDeptMapping().get((Long)org.getPkValue());
        ValidateResult validateResult = ImptValidateHelper.checkPurDept((DynamicObject)billObj, invDepts, (String)purOrgKey, (String)purDeptKey);
        String billId = String.valueOf(billObj.getPkValue());
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkBizDept(DynamicObject billObj, ValidateResultCollection validateResults) {
        DynamicObject bizOrg = billObj.getDynamicObject("bizorg");
        if (bizOrg == null) {
            return;
        }
        Long orgId = bizOrg.getLong("id");
        List<Long> bizDepts = this.getPurOrgBizDeptMapping().get(orgId);
        ValidateResult validateResult = ImptValidateHelper.checkBizDept((DynamicObject)billObj, bizDepts);
        String billId = String.valueOf(billObj.getLong("id"));
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkDiscountRate(DynamicObject bill, DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        BigDecimal discountRate = entryObj.getBigDecimal("discountrate");
        String discountType = entryObj.getString("discounttype");
        if (discountRate == null || discountType == null) {
            return;
        }
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType) && discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
            ValidateResult validateResult = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e100%\u3002", (String)"InvInTplImptValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
        }
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            boolean isTax = bill.getBoolean("istax");
            ValidateResult validateResult = new ValidateResult();
            String errMsg = "";
            if (isTax) {
                BigDecimal priceAndTax = entryObj.getBigDecimal("priceandtax");
                if (discountRate.compareTo(priceAndTax) > 0) {
                    errMsg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"InvInTplImptValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                }
            } else {
                BigDecimal price = entryObj.getBigDecimal("price");
                if (discountRate.compareTo(price) > 0) {
                    errMsg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"InvInTplImptValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                validateResult.setErrValResult(errMsg);
                validateResults.addValidateResult(billId, validateResult);
            }
        }
    }

    protected void checkOperator(String operatorGrpType, DynamicObject billObj, ValidateResultCollection validateResults) {
        boolean isInv = "KCZ".equals(operatorGrpType);
        String orgString = isInv ? "org" : "bizorg";
        DynamicObject org = billObj.getDynamicObject(orgString);
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        Map<Long, Set<Long>> operatorGroupMapping = this.getOrgOperatorGroupMapping(orgId, operatorGrpType);
        ValidateResult validateResult = ImptValidateHelper.checkOperator((String)operatorGrpType, (DynamicObject)billObj, operatorGroupMapping);
        String billId = String.valueOf(billObj.getLong("id"));
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkMaterialInfo(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        ValidateResult validateResult = new ValidateResult();
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        if (materialInfo == null) {
            String errMsg = ResManager.loadKDString((String)"\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InvInTplImptValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
            return;
        }
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        String materialNum = material.getString("number");
        String status = materialInfo.getString("status");
        if (!"C".equals(status)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u672a\u5ba1\u6838\u3002", (String)"InvInTplImptValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
            return;
        }
        boolean enable = materialInfo.getBoolean("enable");
        if (!enable) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u672a\u542f\u7528\u3002", (String)"InvInTplImptValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
        }
    }

    protected void checkAuxpty(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject materialStategy = entryObj.getDynamicObject("material");
        if (materialStategy == null) {
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkAuxpty((DynamicObject)entryObj, (DynamicObject)materialStategy, this.getMaterialToAuxptys());
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkUnit(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject materialStategy = entryObj.getDynamicObject("material");
        if (materialStategy == null) {
            return;
        }
        DynamicObject materialObj = materialStategy.getDynamicObject("masterid");
        Long materialId = materialObj.getLong("id");
        DynamicObject unit = entryObj.getDynamicObject("unit");
        if (unit == null) {
            entryObj.set("unit", (Object)materialStategy.getDynamicObject("inventoryunit"));
        }
        Long unitId = entryObj.getLong("unit.id");
        Set<Long> fixedConvUnits = this.getFixedConvertTypeUnits().get(materialId);
        ValidateResult validateResult = ImptValidateHelper.checkUnit(fixedConvUnits, (Long)unitId);
        if (!validateResult.getIsVaild().booleanValue()) {
            Long baseUnitId = this.materialToBaseUnit.get(materialId);
            String key = materialId + "_" + unitId + "_" + baseUnitId;
            Boolean isRateConv = this.isUnitRateConv.get(key);
            if (isRateConv == null) {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)unitId, (Long)baseUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    isRateConv = true;
                    this.isUnitRateConv.put(key, true);
                } else {
                    this.isUnitRateConv.put(key, false);
                    isRateConv = false;
                }
            }
            if (!isRateConv.booleanValue()) {
                validateResults.addValidateResult(billId, validateResult);
            }
        }
    }

    protected void checkWarehouse(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults, String warehouseField) {
        boolean isInitBill;
        DynamicObject warehouse = entryObj.getDynamicObject(warehouseField);
        DynamicObject org = billObj.getDynamicObject("org");
        if (warehouse == null || org == null) {
            return;
        }
        boolean bl = isInitBill = "im_purinbill".equals(billObj.getDataEntityType().getName()) || "im_saloutbill".equals(billObj.getDataEntityType().getName());
        if (isInitBill) {
            isInitBill = billObj.getBoolean("isinitbill");
        }
        if (!this.org2Warehouse.containsKey(org.getLong("id"))) {
            ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(1);
            bills.add(billObj);
            this.cacheOrgWarehouseMap(bills, warehouseField);
        }
        Set<Long> warehouseIds = this.org2Warehouse.get((Long)org.getPkValue());
        ValidateResult validateResult = ImptValidateHelper.checkWarehouse((DynamicObject)entryObj, warehouseIds, (DynamicObject)org, (boolean)isInitBill, (String)warehouseField);
        String billId = String.valueOf(billObj.getLong("id"));
        validateResults.addValidateResult(billId, validateResult);
    }

    @Deprecated
    protected void checkLocation(DynamicObject entryObj, String billId, ValidateResultCollection validateResults, String warehouseField, String locationField) {
        DynamicObject warehouse = entryObj.getDynamicObject(warehouseField);
        if (warehouse == null) {
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkLocation((DynamicObject)entryObj, (DynamicObject)warehouse, (String)locationField);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkLocation(DynamicObject entryObj, String billId, ValidateResultCollection validateResults, String warehouseField, String locationField, Map<Long, Set<Long>> whIdToLocationIdsMap) {
        DynamicObject warehouse = entryObj.getDynamicObject(warehouseField);
        if (warehouse == null) {
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkLocation((DynamicObject)entryObj, (DynamicObject)warehouse, (String)locationField, whIdToLocationIdsMap);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkLotNumber(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        if (materialInfo == null) {
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkLotNumber((DynamicObject)entryObj);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkProduceDateAndExpiryDate(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        if (materialInfo == null) {
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkProduceDateAndExpiryDate((DynamicObject)entryObj);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkInvTypeOwner(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        DynamicObject org = billObj.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject invScheme = billObj.getDynamicObject("invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isNotUpdate = invScheme.getBoolean("isnotupdate");
        if (!isNotUpdate) {
            boolean isInUpdate = invScheme.getBoolean("isinupdate");
            boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
            String billId = String.valueOf(billObj.getLong("id"));
            if (isInUpdate && isOutUpdate) {
                this.checkInOutUpdate(true, org, billId, entryObj, invScheme, validateResults);
                this.checkInOutUpdate(false, org, billId, entryObj, invScheme, validateResults);
            } else if (isInUpdate) {
                this.checkInOutUpdate(true, org, billId, entryObj, invScheme, validateResults);
            } else if (isOutUpdate) {
                this.checkInOutUpdate(false, org, billId, entryObj, invScheme, validateResults);
            }
        }
    }

    private void checkInOutUpdate(boolean isInUpdate, DynamicObject org, String billId, DynamicObject entryObj, DynamicObject invScheme, ValidateResultCollection validateResults) {
        boolean enable;
        DynamicObject keeper;
        String keeperType;
        DynamicObject owner;
        String ownerType;
        DynamicObjectCollection invTypeEntry;
        DynamicObject invType;
        String invSchemeNum = invScheme.getString("number");
        if (isInUpdate) {
            invType = entryObj.getDynamicObject("invtype");
            invTypeEntry = invScheme.getDynamicObjectCollection("invtypeentry");
            ownerType = entryObj.getString("ownertype");
            owner = entryObj.getDynamicObject("owner");
            keeperType = entryObj.getString("keepertype");
            keeper = entryObj.getDynamicObject("keeper");
        } else {
            invType = entryObj.getDynamicObject("outinvtype");
            invTypeEntry = invScheme.getDynamicObjectCollection("outinvtypeentry");
            ownerType = entryObj.getString("outownertype");
            owner = entryObj.getDynamicObject("outowner");
            keeperType = entryObj.getString("keepertype");
            keeper = entryObj.getDynamicObject("outkeeper");
        }
        if (owner != null && !(enable = this.checkOwnerEnable(owner))) {
            String number = owner.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u201c%s\u201d\u5df2\u88ab\u7981\u7528\u3002", (String)"InvInTplImptValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]), number);
            validateResults.addValidateInfo(billId, errMsg);
        }
        if (org == null) {
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkInvType((boolean)isInUpdate, (DynamicObject)invType, (DynamicObjectCollection)invTypeEntry, (String)invSchemeNum);
        validateResults.addValidateResult(billId, validateResult);
        String ownerMeg = ResManager.loadKDString((String)"\u8d27\u4e3b", (String)"InvInTplImptValidator_9", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        ValidateResult validateResult1 = this.checkSupplierOrCustomerOwner(org, owner, ownerType, ownerMeg);
        validateResults.addValidateResult(billId, validateResult1);
        String keepMeg = ResManager.loadKDString((String)"\u4fdd\u7ba1\u8005", (String)"InvInTplImptValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        ValidateResult validateResult2 = this.checkSupplierOrCustomerOwner(org, keeper, keeperType, keepMeg);
        validateResults.addValidateResult(billId, validateResult2);
        if (BOS_ORG.equals(ownerType)) {
            ValidateResult validateResult3 = this.checkAccOwner(isInUpdate, org, entryObj, owner, ownerType);
            validateResults.addValidateResult(billId, validateResult3);
        }
    }

    private DynamicObject setKeeper(DynamicObject entryObj, DynamicObject org, boolean isInUpdate, String keeperType, DynamicObject keeper) {
        if (isInUpdate && keeper == null && BOS_ORG.equals(keeperType)) {
            keeper = org;
            entryObj.set("keeper", (Object)org);
        }
        return keeper;
    }

    private DynamicObject setOwner(DynamicObject entryObj, boolean isInUpdate, String ownerType, DynamicObject owner) {
        Object id;
        DynamicObject reqOrg;
        Map orgMap;
        if (isInUpdate && owner == null && BOS_ORG.equals(ownerType) && (orgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)(reqOrg = entryObj.getDynamicObject("entryreqorg")).getPkValue()), (Boolean)false, (Boolean)true)) != null && (id = orgMap.get("id")) != null) {
            owner = this.getBosOrgUsedMap((Long)id);
            entryObj.set("owner", (Object)owner);
        }
        return owner;
    }

    private void isEmpty(boolean isInUpdate, DynamicObject owner, DynamicObject keeper, String billId, ValidateResultCollection validateResults) {
        String errMsg;
        ValidateResult validateResult;
        if (owner == null) {
            validateResult = new ValidateResult();
            errMsg = isInUpdate ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5165\u5e93\u8d27\u4e3b\u3002", (String)"InvInTplImptValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvInTplImptValidator_12", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
        }
        if (keeper == null) {
            validateResult = new ValidateResult();
            errMsg = isInUpdate ? ResManager.loadKDString((String)"\u5165\u5e93\u4fdd\u7ba1\u8005\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"InvInTplImptValidator_13", (String)"scmc-im-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvInTplImptValidator_14", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
        }
    }

    private ValidateResult checkSupplierOrCustomerOwner(DynamicObject org, DynamicObject owner, String type, String message) {
        ValidateResult validateResult = new ValidateResult();
        if ("bd_customer".equals(type) || "bd_supplier".equals(type)) {
            Long pkValue = (Long)org.getPkValue();
            if (owner == null) {
                return null;
            }
            List<Object> ownerIds = "bd_supplier".equals(type) ? this.getSupplierMaps(pkValue, owner.getPkValue()) : this.getCustomerMaps(pkValue, owner.getPkValue());
            validateResult = ImptValidateHelper.checkSupplierOrCustomerOwner((String)type, (DynamicObject)owner, (DynamicObject)org, ownerIds, (String)message);
        }
        return validateResult;
    }

    protected ValidateResult checkAccOwner(boolean isInUpdate, DynamicObject org, DynamicObject entryObj, DynamicObject owner, String ownerType) {
        Map<Long, List<Object>> orgToAccOwners = this.getOrgToAccOwners();
        Long orgId = org.getLong("id");
        List<Object> accOwners = orgToAccOwners.get(orgId);
        return ImptValidateHelper.checkOwner((String)ownerType, (DynamicObject)owner, (DynamicObject)org, accOwners);
    }

    private boolean checkOwnerEnable(DynamicObject owner) {
        boolean tag = true;
        if (BOS_ORG.equals(owner.getDataEntityType().getName())) {
            owner = this.getBosOrgUsedMap((Long)owner.getPkValue());
        }
        Object enable = owner.get("enable");
        if (EnableStatusEnum.DISABLE.getValue().equals(enable)) {
            tag = false;
        }
        return tag;
    }

    private void setDefaultInvType(boolean isInUpdate, DynamicObject entryObj, DynamicObjectCollection invTypeEntrys) {
        String invType = isInUpdate ? "invtype" : "outinvtype";
        String isDefault = isInUpdate ? "invtypeisdefault" : "outinvtypeisdefault";
        for (DynamicObject invTypeObj : invTypeEntrys) {
            boolean defaultInv = invTypeObj.getBoolean(isDefault);
            if (!defaultInv) continue;
            Object defInvType = invTypeObj.get(invType);
            entryObj.set(invType, defInvType);
            break;
        }
    }

    private void setDefaultInvStatus(boolean isInUpdate, DynamicObject entryObj, DynamicObjectCollection invStatusEntry) {
        String invStatus = isInUpdate ? "invstatus" : "outinvstatus";
        String isDefault = isInUpdate ? "invstatusisdefault" : "outinvstatusisdefault";
        for (DynamicObject invStatusObj : invStatusEntry) {
            boolean defaultInv = invStatusObj.getBoolean(isDefault);
            if (!defaultInv) continue;
            Object defInvStatus = invStatusObj.get(invStatus);
            entryObj.set(invStatus, defInvStatus);
            break;
        }
    }

    private void setDefaultOwner(boolean isInUpdate, DynamicObject org, DynamicObject entryObj) {
        Object defaultOwner = OwnerHelper.getOwnerDefValue((Long)((Long)org.getPkValue()));
        String owner = isInUpdate ? "owner" : "outowner";
        Map<Object, DynamicObject> ownerMapping = this.getOwnerMapping(defaultOwner);
        entryObj.set(owner, (Object)ownerMapping.get(defaultOwner));
    }

    private void setDefaultValue(boolean isInUpdate, DynamicObject org, DynamicObject entryObj, DynamicObject invScheme) {
        if (isInUpdate) {
            entryObj.set("ownertype", invScheme.get("ownertype"));
            String keeperType = invScheme.getString("keepertype");
            entryObj.set("keepertype", (Object)keeperType);
            if (BOS_ORG.equals(keeperType)) {
                entryObj.set("keeper", (Object)org);
            }
        } else {
            DynamicObjectCollection outInvStatusEntry = invScheme.getDynamicObjectCollection("outinvstatusentry");
            this.setDefaultInvStatus(false, entryObj, outInvStatusEntry);
            entryObj.set("outownertype", invScheme.get("outownertype"));
            String keeperType = invScheme.getString("outkeepertype");
            entryObj.set("outkeepertype", (Object)keeperType);
            if (BOS_ORG.equals(keeperType)) {
                entryObj.set("outkeeper", (Object)org);
            }
        }
    }

    protected void checkQty(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject bill = (DynamicObject)entryObj.getParent();
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        boolean isNegative = false;
        if (invScheme != null && "1".equals(invScheme.getString("bizdirection"))) {
            isNegative = true;
        }
        BigDecimal qty = entryObj.getBigDecimal("qty");
        BigDecimal qtyunit2nd = entryObj.getBigDecimal("qtyunit2nd");
        ValidateResult validateResult = null;
        if (!isNegative) {
            validateResult = ImptValidateHelper.checkQty((BigDecimal)qty, (BigDecimal)qtyunit2nd);
        }
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkPrice(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        BigDecimal price = entryObj.getBigDecimal("price");
        ValidateResult validateResult = ImptValidateHelper.checkPrice((BigDecimal)price);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkPriceAndTax(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        BigDecimal price = entryObj.getBigDecimal("priceandtax");
        ValidateResult validateResult = ImptValidateHelper.checkPrice((BigDecimal)price);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkProject(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject project = entryObj.getDynamicObject("project");
        ValidateResult validateResult = ImptValidateHelper.checkProject((DynamicObject)project);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkTaxRateId(DynamicObject billObj, DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject taxRateId = entryObj.getDynamicObject("taxrateid");
        if (taxRateId == null) {
            entryObj.set("taxrate", null);
            return;
        }
        Object enable = taxRateId.get("enable");
        if (EnableStatusEnum.DISABLE.getValue().equals(enable)) {
            String number = taxRateId.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u7a0e\u7387\u201c%s\u201d\u5df2\u88ab\u7981\u7528\u3002", (String)"InvInTplImptValidator_15", (String)"scmc-im-opplugin", (Object[])new Object[0]), number);
            validateResults.addValidateInfo(billId, errMsg);
            return;
        }
        Map<Object, DynamicObject> taxRateIdMapping = this.getCacheTaxRateIdMapping();
        ValidateResult validateResult = ImptValidateHelper.checkTaxRateId((DynamicObject)billObj, (DynamicObject)entryObj, taxRateIdMapping);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkBizOrg(DynamicObject billObj, ValidateResultCollection validateResults) {
        Map<Long, List<Long>> invToPurOrgs = this.getInvToPurOrgs();
        String billId = String.valueOf(billObj.getPkValue());
        ValidateResult validateResult = ImptValidateHelper.checkBizOrg((DynamicObject)billObj, invToPurOrgs);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkSupplier(DynamicObject billObj, ValidateResultCollection validateResults) {
        ValidateResult validateResult = ImptValidateHelper.checkSupplier((DynamicObject)billObj, this.orgAndSupIds);
        validateResults.addValidateResult(String.valueOf(billObj.getPkValue()), validateResult);
    }

    protected void checkSettleType(DynamicObject billObj, ValidateResultCollection validateResults) {
        Map<Object, DynamicObject> settleTypeMapping = this.getSettleTypeMapping();
        String billId = String.valueOf(billObj.getPkValue());
        ValidateResult result = ImptValidateHelper.checkSettleType((DynamicObject)billObj, settleTypeMapping);
        validateResults.addValidateResult(billId, result);
    }

    protected void checkPayCondition(DynamicObject billObj, ValidateResultCollection validateResults) {
        Map<Object, DynamicObject> payConditionMapping = this.getPayConditionMapping();
        String billId = String.valueOf(billObj.getPkValue());
        ValidateResult result = ImptValidateHelper.checkPayCondition((DynamicObject)billObj, payConditionMapping);
        validateResults.addValidateResult(billId, result);
    }

    protected void checkMaterialBusinessControl(DynamicObject billObj, DynamicObject entryObj, String billId, ValidateResultCollection validateResults, String materialKey, String bizTypeKey) {
        boolean aBoolean;
        List<Long> asset;
        boolean aBoolean2;
        DynamicObject bizType = billObj.getDynamicObject(bizTypeKey);
        Long pkValue = (Long)bizType.getPkValue();
        List<Long> vmi = this.getBizTypeList(VMI_KEY);
        ValidateResult validateResult = new ValidateResult();
        DynamicObject materialInfo = entryObj.getDynamicObject(materialKey);
        if (materialInfo == null) {
            return;
        }
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        String materialNum = material.getString("number");
        String errMsg = "";
        if (vmi.contains(pkValue) && !(aBoolean2 = material.getBoolean("enablevmi"))) {
            errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4e0d\u53efVMI\u3002", (String)"InvInTplImptValidator_16", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum);
        }
        if ((asset = this.getBizTypeList(ASSET_KEY)).contains(pkValue) && !(aBoolean = material.getBoolean("enableasset"))) {
            errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4e0d\u662f\u201c\u53ef\u8d44\u4ea7\u201d\u7269\u6599\u3002", (String)"InvInTplImptValidator_17", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum);
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
        }
    }

    private List<Long> getBizTypeList(String key) {
        ArrayList<Long> list = new ArrayList<Long>(5);
        if (VMI_KEY.equals(key)) {
            list.add(BizTypeConsts.BIZTYPE_PURIN_VMI);
            list.add(BizTypeConsts.BIZTYPE_PURINRETURN_VMI);
            list.add(BizTypeConsts.BIZTYPE_MOUT_VMI);
            list.add(BizTypeConsts.BIZTYPE_MOUTRETURN_VMI);
        }
        if (ASSET_KEY.equals(key)) {
            list.add(BizTypeConsts.BIZTYPE_PURIN_ASSET);
            list.add(BizTypeConsts.BIZTYPE_PURINRETURN_ASSET);
            list.add(BizTypeConsts.BIZTYPE_MROUT_ASSET);
        }
        return list;
    }

    protected void checkBizorg(DynamicObject billObj, ValidateResultCollection validateResults) {
        DynamicObject bizOrg = billObj.getDynamicObject("bizorg");
        if (bizOrg == null) {
            return;
        }
        boolean isOrgUnit = OrgUnitServiceHelper.checkOrgFunction((Long)((Long)bizOrg.getPkValue()), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType());
        ValidateResult valResultInfo = new ValidateResult();
        if (!isOrgUnit) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u5fc5\u987b\u4e3a\u4e1a\u52a1\u5355\u5143\u3002", (String)"InvInTplImptValidator_18", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        String billId = String.valueOf(billObj.getPkValue());
        validateResults.addValidateResult(billId, valResultInfo);
    }

    protected void cacheOrgAndSupIds(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, HashSet<Long>> billOrgSupIds = new HashMap<Long, HashSet<Long>>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObject org = billObj.getDynamicObject("org");
            Long orgId = org == null ? Long.valueOf(0L) : (Long)org.getPkValue();
            DynamicObject supplier = billObj.getDynamicObject("supplier");
            Long supplierId = supplier == null ? Long.valueOf(0L) : billObj.getDynamicObject("supplier").getPkValue();
            HashSet<Long> supIds = (HashSet<Long>)billOrgSupIds.get(orgId);
            if (supIds == null) {
                supIds = new HashSet<Long>(16);
                billOrgSupIds.put(orgId, supIds);
            }
            supIds.add(supplierId);
        }
        for (Map.Entry entry : billOrgSupIds.entrySet()) {
            this.orgAndSupIds.put((Long)entry.getKey(), this.querySupIds(entry));
        }
    }

    private Set<Long> querySupIds(Map.Entry<Long, Set<Object>> orgAndSupId) {
        QFilter filter = new QFilter("id", "in", orgAndSupId.getValue());
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection queryBaseData = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgAndSupId.getKey(), (QFilter)filter, (String)"id");
        return queryBaseData.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
    }

    protected void cacheOrgWarehouseMap(List<DynamicObject> bills, String ... warehouseFields) {
        HashSet<Long> orgIdSet = new HashSet<Long>(bills.size());
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        BillFieldMapper billFieldMapper = BillFieldMapperFactory.getBillFieldMapper(this.getBillKey());
        String entryKey = billFieldMapper.getBillEntryKey();
        for (DynamicObject billObj : bills) {
            orgIdSet.add(billObj.getDynamicObject("org").getLong("id"));
            DynamicObjectCollection entries = billObj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entries) {
                for (String warehouseField : warehouseFields) {
                    DynamicObject warehouse = entry.getDynamicObject(warehouseField);
                    if (warehouse == null) continue;
                    warehouseIdSet.add(warehouse.getLong("id"));
                }
            }
        }
        for (Long orgId : orgIdSet) {
            this.org2Warehouse.putIfAbsent(orgId, new HashSet());
        }
        QFilter whFilter = new QFilter("org", "in", orgIdSet);
        whFilter.and("startstatus", "=", (Object)"B");
        whFilter.and("initstatus", "=", (Object)"B");
        whFilter.and("warehouse", "in", warehouseIdSet);
        String whSetupSelects = "org.id,warehouse.id";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_warehousesetup", (String)whSetupSelects, (QFilter[])whFilter.toArray(), (String)"");
        for (Row row : dataSet) {
            Long warehouseId = row.getLong("warehouse.id");
            Long orgId = row.getLong("org.id");
            this.org2Warehouse.putIfAbsent(orgId, new HashSet());
            this.org2Warehouse.get(orgId).add(warehouseId);
        }
    }
}

