/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt.invbiz.ininv;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.pojo.ValidateResultCollection;
import kd.scmc.im.validator.improt.invbiz.ininv.InvInTplImptValidator;

public class ProInImptValidator
extends InvInTplImptValidator {
    private Map<Long, Set<Long>> whIdToLocationIdsMap = new HashMap<Long, Set<Long>>(64);

    @Override
    protected void cacheData(ExtendedDataEntity[] dataEntities) {
        super.cacheData(dataEntities);
        List<DynamicObject> bills = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity()).collect(Collectors.toList());
        this.cacheOrgWarehouseMap(bills, "warehouse");
        this.cacheWhIdToLocationIds(dataEntities);
    }

    @Override
    protected void cacheHeadData(DynamicObject billObj) {
        this.cacheOrgIds(billObj);
        this.cachePurOrgIds(billObj, "bizorg");
        this.cacheBillBizTypeKeys(billObj);
        this.cacheInvSchemeMapping(billObj);
    }

    private void cacheWhIdToLocationIds(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> whIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObjectCollection entries = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                DynamicObject wh = entry.getDynamicObject("warehouse");
                if (wh == null) continue;
                whIds.add(wh.getLong("id"));
            }
        }
        DataSet whDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])new QFilter("id", "in", whIds).toArray(), (String)"");
        while (whDs.hasNext()) {
            Row wh = whDs.next();
            Long whId = wh.getLong("id");
            Long locationId = wh.getLong("entryentity.location");
            if (locationId == 0L) continue;
            Set locationIds = this.whIdToLocationIdsMap.computeIfAbsent(whId, key -> new HashSet());
            locationIds.add(locationId);
        }
    }

    @Override
    protected void cacheEntryData(DynamicObject billObj, DynamicObject entryObj) {
        super.cacheEntryData(billObj, entryObj);
        this.cacheAuxtyMaterials(entryObj);
        this.cacheMlToBaseUnit(entryObj);
    }

    @Override
    public void checkF7(DynamicObject billObj, ValidateResultCollection validateResults) {
        super.checkF7(billObj, validateResults);
        this.checkInvschemes(billObj, validateResults);
        this.checkDept(billObj, validateResults);
        this.checkBizDept(billObj, validateResults);
        this.checkOperator("KCZ", billObj, validateResults);
        this.checkBizorg(billObj, validateResults);
    }

    @Override
    public void checkDate(DynamicObject billObj, ValidateResultCollection validateResults) {
    }

    @Override
    public void checkText(DynamicObject billObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getPkValue());
        this.checkComment(billObj, billId, validateResults);
    }

    @Override
    public void checkNumeric(DynamicObject billObj, ValidateResultCollection validateResults) {
    }

    @Override
    protected void checkEntryF7(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        super.checkEntryF7(billObj, entryObj, validateResults);
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkMaterialInfo(entryObj, billId, validateResults);
        this.checkAuxpty(entryObj, billId, validateResults);
        this.checkUnit(entryObj, billId, validateResults);
        this.checkWarehouse(billObj, entryObj, validateResults, "warehouse");
        this.checkLocation(entryObj, billId, validateResults, "warehouse", "location", this.whIdToLocationIdsMap);
        this.checkInvTypeOwner(billObj, entryObj, validateResults);
        this.checkProject(entryObj, billId, validateResults);
    }

    @Override
    protected void checkEntryText(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
    }

    @Override
    protected void checkEntryDate(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkProduceDateAndExpiryDate(entryObj, billId, validateResults);
    }

    @Override
    protected void checkEntryNumeric(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkQty(entryObj, billId, validateResults);
        this.checkPrice(entryObj, billId, validateResults);
    }
}

