/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class OtherInbillSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkQtyAnd2nd(entity);
        }
    }

    private void checkQtyAnd2nd(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObject biztype = (DynamicObject)bill.get("biztype");
        if (biztype == null) {
            return;
        }
        String biztypeNum = biztype.getString("number");
        if ("370".equals(biztypeNum)) {
            return;
        }
        DynamicObjectCollection col = bill.getDynamicObjectCollection("billentry");
        StringBuilder alertMsg = new StringBuilder();
        int size = 0;
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject row = (DynamicObject)col.get(i);
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal qtyunit2nd = row.getBigDecimal("qtyunit2nd");
            BigDecimal baseqty = row.getBigDecimal("baseqty");
            if ("350".equals(biztypeNum)) {
                if (qty.compareTo(BigDecimal.ZERO) != 0 || qtyunit2nd.compareTo(BigDecimal.ZERO) != 0) continue;
                String tip = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u6570\u91cf\u4e0e\u8f85\u52a9\u6570\u91cf\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"OtherInbillSubmitValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1);
                if (size == 0) {
                    alertMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u76d8\u76c8\u5165\u5e93\u65f6", (String)"OtherInbillSubmitValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0])).append(",");
                }
                alertMsg.append(tip);
                ++size;
                continue;
            }
            if (qty.compareTo(BigDecimal.ZERO) != 0 && baseqty.compareTo(BigDecimal.ZERO) != 0) continue;
            StringBuilder msg = new StringBuilder();
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                msg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"OtherInbillSubmitValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            if (baseqty.compareTo(BigDecimal.ZERO) == 0) {
                if (msg.length() > 0) {
                    msg.append('\u3001');
                }
                msg.append(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"OtherInbillSubmitValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            String tip = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c[%s]\u884c", (String)"OtherInbillSubmitValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1) + "\uff0c";
            String message = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtherInbillSubmitValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]);
            alertMsg.append(tip);
            alertMsg.append((CharSequence)msg);
            alertMsg.append(message);
        }
        if (alertMsg.length() > 0) {
            this.addErrorMessage(entity, alertMsg.toString());
        }
    }
}

