/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PurInBillAmountPrecisionValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            this.checkAmountScale(extendedDataEntity);
        }
    }

    private void checkAmountScale(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        if (currency == null) {
            return;
        }
        int amountPrecision = currency.getInt("amtprecision");
        String billNo = dataEntity.getString("billno");
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            String tipMsg;
            int scale;
            int seq = entry.getInt("seq");
            BigDecimal curDeductibleAmt = entry.getBigDecimal("curdeductibleamt");
            BigDecimal interCostAmt = entry.getBigDecimal("intercostamt");
            if (curDeductibleAmt != null && (scale = curDeductibleAmt.stripTrailingZeros().scale()) > amountPrecision) {
                tipMsg = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5206\u5f55\u7b2c%2$s\u884c\uff0c\u201c\u53ef\u62b5\u6263\u7a0e\u989d\u201d\u7cbe\u5ea6\u548c\u672c\u4f4d\u5e01\u7cbe\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"PurInBillAmountPrecisionValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, String.format(tipMsg, billNo, seq));
            }
            if (interCostAmt == null || (scale = interCostAmt.stripTrailingZeros().scale()) <= amountPrecision) continue;
            tipMsg = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5206\u5f55\u7b2c%2$s\u884c\uff0c\u201c\u8ba1\u6210\u672c\u91d1\u989d\u201d\u7cbe\u5ea6\u548c\u672c\u4f4d\u5e01\u7cbe\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"PurInBillAmountPrecisionValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, String.format(tipMsg, billNo, seq));
        }
    }
}

