/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PurInBillPriceTaxValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            this.checkPriceTax(extendedDataEntity);
        }
    }

    private void checkPriceTax(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        int amountPrecision = 2;
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        String billNo = dataEntity.getString("billno");
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            BigDecimal calInterCostAmt;
            int seq = entry.getInt("seq");
            String taxPayer = entry.getString("taxpayertype");
            if (!StringUtils.isNotBlank((CharSequence)taxPayer)) continue;
            BigDecimal curAmountAndTax = entry.getBigDecimal("curamountandtax");
            BigDecimal curDeductibleAmt = entry.getBigDecimal("curdeductibleamt");
            BigDecimal interCostAmt = entry.getBigDecimal("intercostamt");
            if (interCostAmt.compareTo(calInterCostAmt = curAmountAndTax.subtract(curDeductibleAmt).setScale(amountPrecision, 4)) == 0) continue;
            String tipMsg = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5206\u5f55\u7b2c%2$s\u884c\uff0c\u201c\u8ba1\u6210\u672c\u91d1\u989d\u201d\u4e0d\u7b49\u4e8e \u201c\u4ef7\u7a0e\u5408\u8ba1(\u672c\u4f4d\u5e01) -\u53ef\u62b5\u6263\u7a0e\u989d\u201d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"PurInBillPriceTaxValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, String.format(tipMsg, billNo, seq));
        }
    }
}

