/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class PurInBillPriceValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"PurInBillPriceValidator", (String)"validate");){
            ExtendedDataEntity[] dataEntities;
            if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0002")) {
                return;
            }
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject invBill = dataEntity.getDataEntity();
                DynamicObject invScheme = invBill.getDynamicObject("invscheme");
                if (invScheme == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u5e93\u5b58\u4e8b\u52a1\u3002", (String)"PurInBillPriceValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!invScheme.getBoolean("isforwardamount")) continue;
                this.checkPrice(dataEntity);
            }
        }
    }

    private void checkPrice(ExtendedDataEntity dataEntity) {
        DynamicObject invBill = dataEntity.getDataEntity();
        DynamicObjectCollection billEntry = invBill.getDynamicObjectCollection("billentry");
        if (billEntry == null || billEntry.isEmpty()) {
            return;
        }
        int index = 0;
        for (DynamicObject entry : billEntry) {
            BigDecimal price;
            ++index;
            boolean isPresent = entry.getBoolean("ispresent");
            if (isPresent || BigDecimal.ZERO.compareTo(price = entry.getBigDecimal("price")) < 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u5355\u4ef7\u9700\u8981\u5927\u4e8e\u96f6\u3002", (String)"PurInBillPriceValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), index));
        }
    }
}

