/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class PurReconciliationValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PurReconciliationValidator.class);
    private Map<Long, Set<Long>> verifyBillMapping = new HashMap<Long, Set<Long>>(8);
    private Map<Long, Set<Long>> verifyBillEntryMapping = new HashMap<Long, Set<Long>>(8);

    public void validate() {
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0004")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        String entityName = dataEntities[0].getDataEntity().getDataEntityType().getName();
        HashMap<String, Object> validatorInfo = new HashMap<String, Object>(8);
        HashMap<Long, List<Long>> billIdMap = new HashMap<Long, List<Long>>(dataEntities.length);
        this.buildParam(entityName, dataEntities, billIdMap);
        if (billIdMap.isEmpty()) {
            return;
        }
        validatorInfo.put("entityName", entityName);
        validatorInfo.put("entryKey", "billentry");
        validatorInfo.put("billIds", billIdMap);
        Map resultMap = null;
        try {
            resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{validatorInfo});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        Boolean success = (Boolean)resultMap.get("succed");
        Map reconciliation = (Map)resultMap.get("data");
        if (!success.booleanValue() && !reconciliation.isEmpty()) {
            this.addValidatorMessage(dataEntities, reconciliation);
        }
    }

    private void addVerifyRecordBill(Map<Long, List<Long>> billIdMap, Set<Long> orgIds) {
        Set<Long> currentBillIds = billIdMap.keySet();
        QFilter mainFilter = new QFilter("org", "in", orgIds);
        mainFilter.and("billid", "in", currentBillIds);
        mainFilter.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        mainFilter.and("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
        mainFilter.and("verifyrelation", "=", (Object)"purself");
        DataSet verifyRecordsByMain = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_verifyrecord", (String)"billid, billentryid, entry.e_billid, entry.e_billentryid", (QFilter[])mainFilter.toArray(), (String)"");
        QFilter asstFilter = new QFilter("org", "in", orgIds);
        asstFilter.and("entry.e_billid", "in", currentBillIds);
        asstFilter.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        asstFilter.and("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
        mainFilter.and("verifyrelation", "=", (Object)"purself");
        DataSet verifyRecordsByAsst = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_verifyrecord", (String)"billid, billentryid, entry.e_billid, entry.e_billentryid", (QFilter[])asstFilter.toArray(), (String)"");
        DataSet verifyRecords = verifyRecordsByMain.union(verifyRecordsByAsst);
        while (verifyRecords.hasNext()) {
            List eEntryIds;
            Row verifyRecord = verifyRecords.next();
            Long billId = verifyRecord.getLong("billid");
            Long billEntryId = verifyRecord.getLong("billentryid");
            Long eBillId = verifyRecord.getLong("entry.e_billid");
            Long eBillEntryId = verifyRecord.getLong("entry.e_billentryid");
            Set eBillIds = this.verifyBillMapping.computeIfAbsent(billId, k -> new HashSet(8));
            eBillIds.add(eBillId);
            Set billIds = this.verifyBillMapping.computeIfAbsent(eBillId, k -> new HashSet(8));
            billIds.add(billId);
            Set eBillEntryIds = this.verifyBillEntryMapping.computeIfAbsent(billEntryId, k -> new HashSet(8));
            eBillEntryIds.add(eBillEntryId);
            Set billEntryIds = this.verifyBillEntryMapping.computeIfAbsent(eBillEntryId, k -> new HashSet(8));
            billEntryIds.add(billEntryId);
            List entryIds = billIdMap.computeIfAbsent(billId, k -> new ArrayList(8));
            if (!entryIds.contains(billEntryId)) {
                entryIds.add(billEntryId);
            }
            if ((eEntryIds = billIdMap.computeIfAbsent(eBillId, k -> new ArrayList(8))).contains(eBillEntryId)) continue;
            eEntryIds.add(eBillEntryId);
        }
    }

    private void buildParam(String entityName, ExtendedDataEntity[] dataEntities, Map<Long, List<Long>> billIdMap) {
        HashSet<Long> settleOrgIds = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject supplier = entity.getDynamicObject("supplier");
            if (supplier == null || !supplier.getBoolean("issuppcolla")) continue;
            Long billId = entity.getLong("id");
            DynamicObjectCollection billEntry = entity.getDynamicObjectCollection("billentry");
            ArrayList<Long> entryIds = new ArrayList<Long>(billEntry.size());
            for (DynamicObject entry : billEntry) {
                Long entryId = entry.getLong("id");
                entryIds.add(entryId);
                DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
                if (settleOrg == null) continue;
                Long settleOrgId = settleOrg.getLong("id");
                settleOrgIds.add(settleOrgId);
            }
            billIdMap.put(billId, entryIds);
        }
        if (!"im_purinbill".equals(entityName) || billIdMap.isEmpty()) {
            return;
        }
        this.addVerifyRecordBill(billIdMap, settleOrgIds);
    }

    private void addValidatorMessage(ExtendedDataEntity[] dataEntities, Map<Long, List<Long>> reconciliation) {
        Set<Long> billIds = reconciliation.keySet();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            List<Long> entryIds;
            DynamicObject bill = dataEntity.getDataEntity();
            Long billId = bill.getLong("id");
            Set<Long> verifyBillIds = this.checkVerifyBill(billIds, billId);
            if (!billIds.contains(billId) && verifyBillIds.isEmpty() || (entryIds = this.getEntryIds(reconciliation, verifyBillIds, billId)) == null || entryIds.isEmpty()) continue;
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                Long entryId = entry.getLong("id");
                if (!entryIds.contains(entryId)) continue;
                int seq = entry.getInt("seq");
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5bf9\u5e94\u7684\u534f\u540c\u5355\u6216\u8005\u5bf9\u5e94\u6838\u9500\u5355\u636e\u7684\u534f\u540c\u5355\u5df2\u751f\u6210\u534f\u540c\u5bf9\u8d26/\u5f00\u7968\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PurReconciliationValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq));
            }
        }
    }

    private List<Long> getEntryIds(Map<Long, List<Long>> reconciliation, Set<Long> verifyBillIds, Long billId) {
        List<Long> entryIds = reconciliation.get(billId);
        if (verifyBillIds.isEmpty()) {
            return entryIds;
        }
        HashSet<Long> verifyEntryIds = new HashSet<Long>(8);
        for (Long verifyBillId : verifyBillIds) {
            List<Long> entryIdList = reconciliation.get(verifyBillId);
            verifyEntryIds.addAll(entryIdList);
        }
        HashSet<Long> currentEntryIds = new HashSet<Long>(8);
        for (Long verifyEntryId : verifyEntryIds) {
            Set<Map.Entry<Long, Set<Long>>> entries = this.verifyBillEntryMapping.entrySet();
            for (Map.Entry<Long, Set<Long>> entry : entries) {
                Set<Long> value = entry.getValue();
                if (!value.contains(verifyEntryId)) continue;
                currentEntryIds.add(entry.getKey());
            }
        }
        if (entryIds != null) {
            currentEntryIds.addAll(entryIds);
        }
        return new ArrayList<Long>(currentEntryIds);
    }

    private Set<Long> checkVerifyBill(Set<Long> billIds, Long billId) {
        Set<Long> verifyBillIds = this.verifyBillMapping.get(billId);
        HashSet<Long> ids = new HashSet<Long>(8);
        if (verifyBillIds == null || verifyBillIds.isEmpty()) {
            return ids;
        }
        for (Long verifyBillId : verifyBillIds) {
            boolean contains = billIds.contains(verifyBillId);
            if (!contains) continue;
            ids.add(verifyBillId);
        }
        return ids;
    }
}

