/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inspect;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.CollectionUtils;

public class InvInspectEntryInvTypeValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkInvType(dataEntity);
        }
    }

    private void checkInvType(ExtendedDataEntity dataEntity) {
        DynamicObject targetObj = dataEntity.getDataEntity();
        DynamicObject invScheme = targetObj.getDynamicObject("invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        DynamicObjectCollection entryList = targetObj.getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)entryList)) {
            return;
        }
        for (int i = 0; i < entryList.size(); ++i) {
            BigDecimal unqualifiedQty;
            DynamicObject entry = (DynamicObject)entryList.get(i);
            DynamicObject invType = entry.getDynamicObject("invtype");
            DynamicObject outInvType = entry.getDynamicObject("outinvtype");
            if (isInUpdate && isOutUpdate && invType != null && outInvType != null && !invType.getString("number").equals(outInvType.getString("number"))) {
                String msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u201c\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b\u201d\u548c\u201c\u5165\u5e93\u5e93\u5b58\u7c7b\u578b\u201d\u9700\u4e00\u81f4\u3002", (String)"InvInspectEntryInvTypeValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1});
                this.addErrorMessage(dataEntity, msg);
            }
            if (!"submit".equals(this.getOperateKey())) continue;
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal qualifiedQty = entry.getBigDecimal("qualifiedqty");
            if (qualifiedQty.add(unqualifiedQty = entry.getBigDecimal("unqualifiedqty")).compareTo(qty) <= 0) continue;
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u5408\u683c\u57fa\u672c\u6570\u91cf+\u4e0d\u5408\u683c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u6570\u91cf\u3002", (String)"InvInspectEntryInvTypeValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1});
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

