/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inspect;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.business.helper.InspectionHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class InvInspectMaterialValidator
extends AbstractValidator {
    private static final int BATCH_QUERY_SIZE = 10000;

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkMaterial(dataEntity);
        }
    }

    private void checkMaterial(ExtendedDataEntity entity) {
        DynamicObject invBill = entity.getDataEntity();
        DynamicObject bizType = invBill.getDynamicObject("biztype");
        if (bizType == null) {
            return;
        }
        HashSet<Object> inspectIndexs = new HashSet<Object>();
        DynamicObjectCollection billEntry = invBill.getDynamicObjectCollection("billentry");
        if (SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003")) {
            this.checkInspectApi(billEntry, bizType, inspectIndexs);
            for (int i = 0; i < billEntry.size(); ++i) {
                DynamicObject material = ((DynamicObject)billEntry.get(i)).getDynamicObject("material");
                if (material == null || inspectIndexs.contains("" + i)) continue;
                String tip = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u8be5\u884c\u7269\u6599\u4e0d\u53ef\u8d28\u68c0\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u3002", (String)"InvInspectMaterialValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1});
                this.addErrorMessage(entity, tip);
            }
        } else {
            for (int i = 0; i < billEntry.size(); ++i) {
                DynamicObject material = ((DynamicObject)billEntry.get(i)).getDynamicObject("material");
                if (material == null) continue;
                boolean isInvInspect = material.getBoolean("isinvinspect");
                if (!isInvInspect) {
                    String tip = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u8be5\u884c\u7269\u6599\u672a\u5f00\u542f\u5e93\u5b58\u68c0\u9a8c\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"InvInspectMaterialValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1});
                    this.addErrorMessage(entity, tip);
                    continue;
                }
                BigDecimal baseQty = ((DynamicObject)billEntry.get(i)).getBigDecimal("baseqty");
                BigDecimal qualifiedBaseQty = ((DynamicObject)billEntry.get(i)).getBigDecimal("qualifiedbaseqty");
                if (qualifiedBaseQty.compareTo(baseQty) <= 0) continue;
                String msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u5408\u683c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u6570\u91cf\u3002", (String)"InvInspectBillEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[]{i + 1});
                this.addErrorMessage(entity, msg);
            }
        }
    }

    private void checkInspectApi(DynamicObjectCollection billEntry, DynamicObject bizType, Set<Object> inspectIndexs) {
        ArrayList params = new ArrayList();
        Long bizTypeId = InspectionHelper.getBizTypeId((String)bizType.getString("number"));
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject material = ((DynamicObject)billEntry.get(i)).getDynamicObject("material");
            DynamicObject inspOrg = ((DynamicObject)billEntry.get(i)).getDynamicObject("insporg");
            if (material == null || inspOrg == null) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", i);
            paramMap.put("materialId", material.getDynamicObject("masterid").getPkValue());
            paramMap.put("inspectOrgId", inspOrg.getPkValue());
            paramMap.put("bizType", bizTypeId);
            params.add(paramMap);
        }
        List partition = Lists.partition(params, (int)10000);
        for (List list : partition) {
            inspectIndexs.addAll(InspectionHelper.calInspectForApi((List)list));
        }
    }
}

