/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialReqBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MaterialReqBillUnAuditValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkRowStatusIsClose(dataEntity);
            }
        }
    }

    private void checkRowStatusIsClose(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        if (dynamicObject == null) {
            return;
        }
        DynamicObjectCollection billEntry = dynamicObject.getDynamicObjectCollection("billentry");
        if (billEntry == null || billEntry.isEmpty()) {
            return;
        }
        boolean isExistsClose = false;
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= billEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntry.get(i - 1);
            if (!"D".equalsIgnoreCase(entry.getString("rowstatus"))) continue;
            isExistsClose = true;
            String str = i + "\u3001";
            builder.append(str);
        }
        if (isExistsClose) {
            String failRow = builder.substring(0, builder.length() - 1);
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MaterialReqBillUnAuditValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[]{failRow}));
        }
    }
}

