/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MaterialReqOutSetPriceValidator
extends AbstractValidator {
    private static final String AUDITSTATUS = "C";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkPrice(dataEntity);
            this.checkBillStatusAndCalRecords(dataEntity);
        }
    }

    private void checkPrice(ExtendedDataEntity dataEntity) {
        StringBuilder alertMsg = new StringBuilder();
        DynamicObject billEntity = dataEntity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : col) {
            BigDecimal purchasedQty = (BigDecimal)entry.get("purchasedqty");
            BigDecimal purchasedAmount = (BigDecimal)entry.get("purchasedamount");
            if (purchasedQty.compareTo(BigDecimal.ZERO) == 0 && purchasedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u51fa\u5e93\u5355\u5df2\u8fdb\u884c\u8f6c\u56fa\uff0c\u8bf7\u64a4\u9500\u8f6c\u56fa\u540e\u518d\u83b7\u53d6\u4ef7\u683c\u3002", (String)"MaterialReqOutSetPriceValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            alertMsg.append(msg);
        }
        if (alertMsg.length() > 0) {
            this.addErrorMessage(dataEntity, alertMsg.toString());
        }
    }

    private void checkBillStatusAndCalRecords(ExtendedDataEntity dataEntity) {
        StringBuilder alertMsg = new StringBuilder();
        DynamicObject billEntity = dataEntity.getDataEntity();
        String billStatus = (String)billEntity.get("billstatus");
        if (!AUDITSTATUS.equals(billStatus)) {
            String msg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\u624d\u80fd\u83b7\u53d6\u4ef7\u683c\u3002", (String)"MaterialReqOutSetPriceValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            alertMsg.append(msg);
        } else {
            String billNo = (String)billEntity.get("billno");
            DynamicObject calCostrecord = this.getCalCostrecordByNo(billNo);
            if (null == calCostrecord) {
                String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u4ef7\u683c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"MaterialReqOutSetPriceValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                alertMsg.append(msg);
            }
        }
        if (alertMsg.length() > 0) {
            this.addErrorMessage(dataEntity, alertMsg.toString());
        }
    }

    private DynamicObject getCalCostrecordByNo(String billNo) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        DynamicObject calCostrecord = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_costrecord", (QFilter[])filter.toArray());
        return calCostrecord;
    }
}

