/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class OtherOutbillSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkQtyAnd2nd(entity);
        }
    }

    private void checkQtyAnd2nd(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObject biztype = (DynamicObject)bill.get("biztype");
        if (biztype == null) {
            return;
        }
        String biztypeNum = biztype.getString("number");
        if ("380".equals(biztypeNum)) {
            return;
        }
        DynamicObjectCollection col = bill.getDynamicObjectCollection("billentry");
        StringBuilder alertMsg = new StringBuilder();
        int size = 0;
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject row = (DynamicObject)col.get(i);
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal qtyunit2nd = row.getBigDecimal("qtyunit2nd");
            BigDecimal baseqty = row.getBigDecimal("baseqty");
            if ("351".equals(biztypeNum)) {
                if (qty.compareTo(BigDecimal.ZERO) != 0 || qtyunit2nd.compareTo(BigDecimal.ZERO) != 0) continue;
                String tip = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u6570\u91cf\u4e0e\u8f85\u52a9\u6570\u91cf\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"OtherOutbillSubmitValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1);
                if (size == 0) {
                    alertMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u76d8\u4e8f\u51fa\u5e93\u65f6", (String)"OtherOutbillSubmitValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0])).append("\uff0c");
                }
                ++size;
                alertMsg.append(tip);
                continue;
            }
            if (qty.compareTo(BigDecimal.ZERO) != 0 && baseqty.compareTo(BigDecimal.ZERO) != 0) continue;
            StringBuilder msg = new StringBuilder();
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                msg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"OtherOutbillSubmitValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            if (baseqty.compareTo(BigDecimal.ZERO) == 0) {
                if (msg.length() > 0) {
                    msg.append('\u3001');
                }
                msg.append(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"OtherOutbillSubmitValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            String tip = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c[%s]\u884c", (String)"OtherOutbillSubmitValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1);
            String message = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtherOutbillSubmitValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]);
            alertMsg.append(tip).append(",");
            alertMsg.append((CharSequence)msg);
            alertMsg.append(message);
        }
        if (alertMsg.length() > 0) {
            this.addErrorMessage(entity, alertMsg.toString());
        }
    }
}

