/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.KitManagementHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class SalOutKitSubmitValidator
extends AbstractValidator {
    private List<Long> kitCheckPidList = new ArrayList<Long>(16);
    private static final String SM_DELIVERNOTICE = "sm_delivernotice";
    private static final String SM_RETURNAPPLY = "sm_returnapply";
    private static final String SM_SALORDER = "sm_salorder";

    public void validate() {
        boolean enableKitSale = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"KIT0001");
        if (!enableKitSale) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        ArrayList<Long> kitParentIds = new ArrayList<Long>(16);
        HashMap<String, List<Long>> inspectSrcBillMap = new HashMap<String, List<Long>>(16);
        this.cacheKitParam(extendedDataEntities, kitParentIds, inspectSrcBillMap);
        if (!kitParentIds.isEmpty()) {
            this.kitCheckPidList = this.getKitCheckPidList(inspectSrcBillMap, kitParentIds);
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            boolean isVirtualBill = dataEntity.getBoolean("isvirtualbill");
            if (isVirtualBill) continue;
            DynamicObjectCollection billEntrys = dataEntity.getDynamicObjectCollection("billentry");
            String mainBillEntity = null;
            HashSet<String> rows = new HashSet<String>(16);
            for (DynamicObject billEntry : billEntrys) {
                String productType = billEntry.getString("kitproducttype");
                boolean kitProduct = "kitparent".equals(productType) || "kitchild".equals(productType);
                if (!kitProduct) continue;
                long pid = billEntry.getLong("kitpid");
                mainBillEntity = billEntry.getString("mainbillentity");
                if (pid != 0L) continue;
                rows.add(billEntry.getString("seq"));
            }
            if (mainBillEntity != null && !SM_SALORDER.equals(mainBillEntity)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u5957\u4ef6\u4e1a\u52a1\u5fc5\u987b\u7531\u9500\u552e\u8ba2\u5355\u53d1\u8d77\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u660e\u7ec6\u884c\u6570\u636e\u3002", (String)"SalOutKitSubmitValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), dataEntity.getString("billno")));
                continue;
            }
            if (!rows.isEmpty()) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7b2c%2$s\u884c\uff0c\u5957\u4ef6\u7269\u6599\u7684\u201c\u7236\u9879\u4ea7\u54c1\u884cID\u201d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u8f6c\u6362\u89c4\u5219\u4ece\u4e0a\u6e38\u643a\u5e26\u3002", (String)"SalOutKitSubmitValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), dataEntity.getString("billno"), String.join((CharSequence)",", rows)));
                continue;
            }
            this.checkKit(extendedDataEntity, billEntrys);
        }
    }

    private void checkKit(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection billEntrys) {
        if (this.kitCheckPidList.isEmpty()) {
            return;
        }
        String billNo = extendedDataEntity.getBillNo();
        String checkKitMsg = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7b2c%2$s\u884c\uff0c\u7236\u9879\u7269\u6599\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u4e3a\u6210\u5957\uff0c\u4f46\u5b50\u9879\u672a\u9f50\u5957\uff0c\u8bf7\u68c0\u67e5\u6570\u91cf\u3002", (String)"SalOutKitSubmitValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(16);
        Map<Long, Map<Long, BigDecimal>> childBaseQtyMap = this.getChildEntryBaseQty(billEntrys, parameters);
        if (parameters.isEmpty()) {
            return;
        }
        String expandKitStructures = (String)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService", (String)"expandKitStructure", (Object[])new Object[]{parameters});
        Map result = (Map)JSON.parseObject((String)expandKitStructures, Map.class);
        block0: for (DynamicObject billEntry : billEntrys) {
            Map childEntryQtyMap;
            long kitParentPid;
            String productType = billEntry.getString("kitproducttype");
            String transferModel = billEntry.getString("kittransfermodel");
            if (!"kit".equals(transferModel) || !"kitparent".equals(productType) || !this.kitCheckPidList.contains(kitParentPid = billEntry.getLong("kitpid"))) continue;
            long mainBillEntryId = billEntry.getLong("mainbillentryid");
            String seq = billEntry.getString("seq");
            Map<Long, BigDecimal> salOutChildBaseQtyMap = childBaseQtyMap.get(kitParentPid);
            Map kitQtyPriceMap = (Map)result.get(mainBillEntryId);
            Object status = kitQtyPriceMap.get("status");
            if ("FAIL".equals(status) || (childEntryQtyMap = (Map)kitQtyPriceMap.get("child")) == null || childEntryQtyMap.isEmpty()) continue;
            HashSet<String> childEntryIds = new HashSet<String>(16);
            for (Map.Entry childEntryQty : childEntryQtyMap.entrySet()) {
                String childEntryId = (String)childEntryQty.getKey();
                Map childQtyMap = (Map)childEntryQty.getValue();
                Object storageOut = childQtyMap.get("storageOut");
                if (!Boolean.TRUE.equals(storageOut)) continue;
                childEntryIds.add(childEntryId);
            }
            Set<Long> salOutChildEntry = salOutChildBaseQtyMap.keySet();
            if (childEntryIds.size() != salOutChildEntry.size()) {
                this.addErrorMessage(extendedDataEntity, String.format(checkKitMsg, billNo, seq));
                continue;
            }
            for (Map.Entry<Long, BigDecimal> salOutChildBaseQtyEntry : salOutChildBaseQtyMap.entrySet()) {
                Long mainChildBillEntryId = salOutChildBaseQtyEntry.getKey();
                BigDecimal salOutChildBaseQty = salOutChildBaseQtyEntry.getValue();
                Map childQtyMap = (Map)childEntryQtyMap.get(String.valueOf(mainChildBillEntryId));
                BigDecimal salOrderBaseQty = (BigDecimal)childQtyMap.get("baseQty");
                if (salOrderBaseQty.compareTo(salOutChildBaseQty) == 0) continue;
                this.addErrorMessage(extendedDataEntity, String.format(checkKitMsg, billNo, seq));
                continue block0;
            }
        }
    }

    private Map<Long, Map<Long, BigDecimal>> getChildEntryBaseQty(DynamicObjectCollection billEntrys, List<Map<String, Object>> parameters) {
        HashMap<Long, Map<Long, BigDecimal>> childBaseQtyMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        for (DynamicObject billEntry : billEntrys) {
            String productType = billEntry.getString("kitproducttype");
            String transferModel = billEntry.getString("kittransfermodel");
            Long pid = billEntry.getLong("kitpid");
            if (!this.kitCheckPidList.contains(pid)) continue;
            childBaseQtyMap.putIfAbsent(pid, new HashMap(16));
            Map baseQtyMap = (Map)childBaseQtyMap.get(pid);
            long mainBillEntryId = billEntry.getLong("mainbillentryid");
            BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
            if ("kitchild".equals(productType) && "kit".equals(transferModel)) {
                BigDecimal qty = (BigDecimal)baseQtyMap.get(mainBillEntryId);
                if (qty == null) {
                    baseQtyMap.put(mainBillEntryId, baseQty);
                    continue;
                }
                baseQtyMap.put(mainBillEntryId, qty.add(baseQty));
                continue;
            }
            if (!"kit".equals(transferModel) || !"kitparent".equals(productType)) continue;
            String mainBillEntity = billEntry.getString("mainbillentity");
            Long mainBillId = billEntry.getLong("mainbillid");
            HashMap<String, Object> parameter = new HashMap<String, Object>(4);
            parameter.put("billEntity", mainBillEntity);
            parameter.put("billId", mainBillId);
            parameter.put("billEntryId", pid);
            parameter.put("baseQty", baseQty);
            parameters.add(parameter);
        }
        return childBaseQtyMap;
    }

    private void cacheKitParam(ExtendedDataEntity[] extendedDataEntities, List<Long> kitParentIds, Map<String, List<Long>> inspectSrcBillMap) {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            boolean isVirtualBill = dataEntity.getBoolean("isvirtualbill");
            if (isVirtualBill) continue;
            DynamicObjectCollection billEntrys = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject billEntry : billEntrys) {
                String productType = billEntry.getString("kitproducttype");
                String transferModel = billEntry.getString("kittransfermodel");
                if (!"kit".equals(transferModel) || !"kitparent".equals(productType)) continue;
                long parentPid = billEntry.getLong("kitpid");
                kitParentIds.add(parentPid);
                String srcBillEntity = billEntry.getString("srcbillentity");
                long srcBillId = billEntry.getLong("srcbillid");
                inspectSrcBillMap.putIfAbsent(srcBillEntity, new ArrayList(16));
                inspectSrcBillMap.get(srcBillEntity).add(srcBillId);
            }
        }
    }

    private List<Long> getKitCheckPidList(Map<String, List<Long>> inspectSrcBillMap, List<Long> kitParentIds) {
        Map reCheckInspectBillMap = KitManagementHelper.reCheckInspectBill(inspectSrcBillMap);
        for (Map.Entry inspectSrcEntry : reCheckInspectBillMap.entrySet()) {
            String srcBillEntity = (String)inspectSrcEntry.getKey();
            if (!SM_DELIVERNOTICE.equals(srcBillEntity) && !SM_RETURNAPPLY.equals(srcBillEntity)) continue;
            List inspectSrcBillIds = (List)inspectSrcEntry.getValue();
            QFilter qFilter = new QFilter("id", "in", (Object)inspectSrcBillIds).and("billentry.kitpid", "in", kitParentIds).and("billentry.isinspect", "=", (Object)"1");
            DataSet noCheckKitData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)srcBillEntity, (String)"billentry.kitpid, billentry.isinspect", (QFilter[])qFilter.toArray(), null);
            for (Row noCheckKitRow : noCheckKitData) {
                Long noCheckPid = noCheckKitRow.getLong("billentry.kitpid");
                kitParentIds.remove(noCheckPid);
            }
        }
        return kitParentIds;
    }
}

