/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.business.helper.directTran.InvDirectTranHelper;
import kd.scmc.im.consts.InvschemeConsts;

public class SaleOutbillUnAuditValidator
extends AbstractValidator {
    private static final String BACKWRITEOFF_TAG = "backwriteoff_tag";

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkEntrustSaleOutBill(entity);
            this.checkDirectTransSaleOutBill(entity);
        }
    }

    private void checkEntrustSaleOutBill(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObject invscheme = (DynamicObject)bill.get("invscheme");
        if (invscheme == null) {
            return;
        }
        Long invschemeId = (Long)invscheme.getPkValue();
        if (InvschemeConsts.INVSCHEM_ENTRUST_SALEOUT.equals(invschemeId) || InvschemeConsts.INVSCHEM_ENTRUST_SALEOUT_BACK.equals(invschemeId)) {
            String backWriteOffVal = this.getOption().getVariableValue(BACKWRITEOFF_TAG, "false");
            if ("true".equals(backWriteOffVal)) {
                return;
            }
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u59d4\u6258\u4ee3\u9500\u552e\u51fa\u6216\u552e\u51fa\u9000\u56de\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SaleOutbillUnAuditValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection salOutBillEntries = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject salOutBillEntry : salOutBillEntries) {
            BigDecimal entrustverifybaseqty = salOutBillEntry.getBigDecimal("entrustverifybaseqty");
            BigDecimal entrustverifyqty = salOutBillEntry.getBigDecimal("entrustverifyqty");
            if (entrustverifybaseqty.signum() <= 0 && entrustverifyqty.signum() <= 0) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5b58\u5728\u59d4\u6258\u4ee3\u9500\u5df2\u7ed3\u7b97\u6570\u91cf\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SaleOutbillUnAuditValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            break;
        }
    }

    private void checkDirectTransSaleOutBill(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        if (InvDirectTranHelper.isSupplyTrans((DynamicObject)bill)) {
            String backWriteOffVal = this.getOption().getVariableValue(BACKWRITEOFF_TAG, "false");
            if ("true".equals(backWriteOffVal)) {
                return;
            }
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u76f4\u8fd0\u9500\u552e\u51fa\u5e93\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SaleOutbillUnAuditValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }
}

