/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.setup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;

public class WarehouseSetupStopUseValidator
extends AbstractValidator {
    private static final String BILLENTRY_WAREHOUSE = "billentry.warehouse";
    private static final String BILLENTRY_AFTERENTITY_WAREHOUSE = "billentry.afterentity.warehouse1";
    private static final String BILLENTRY_OUTWAREHOUSE = "billentry.outwarehouse";
    private static final String OUTORG = "outorg";
    private static final String IM_OTHERBILLS = "im_otherbills";
    private Map<String, ExtendedDataEntity> orgWarehouseEntityMap = new HashMap<String, ExtendedDataEntity>(64);
    private Map<String, String> orgWarehouseNameMap = new HashMap<String, String>(64);

    public void validate() {
        Set<String> initStatusOrgWarehouseKeySet;
        this.orgWarehouseEntityMap = this.buildOrgWarehouseEntityMap();
        QFilter orgWarehouseInitStatusFilter = this.buildBillQFilter(Boolean.TRUE);
        if (orgWarehouseInitStatusFilter != null && !(initStatusOrgWarehouseKeySet = this.validateOrgWarehouseInitStatus("im_warehousesetup", orgWarehouseInitStatusFilter)).isEmpty()) {
            ExtendedDataEntity errorDataEntity = null;
            for (String initStatusOrgWarehouseKey : initStatusOrgWarehouseKeySet) {
                errorDataEntity = this.orgWarehouseEntityMap.get(initStatusOrgWarehouseKey);
                this.addFatalErrorMessage(errorDataEntity, ResManager.loadKDString((String)"\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\u4e0d\u5141\u8bb8\u53cd\u542f\u7528\u3002", (String)"WarehouseSetupStopUseValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
        }
        String tip = "";
        Set<String> invBalanceKeySet = null;
        QFilter invBalanceAndCloseFilter = this.buildBillQFilter(Boolean.FALSE);
        if (invBalanceAndCloseFilter != null) {
            QFilter invBalanceFilter = new QFilter("endqty", "!=", (Object)0);
            invBalanceFilter.or("endbaseqty", "!=", (Object)0);
            invBalanceFilter.or("endqty2nd", "!=", (Object)0);
            invBalanceFilter.and(invBalanceAndCloseFilter);
            String entityInvbalance = "im_invbalance";
            if (BalanceUpdateHandle.isNewPeriodBal()) {
                entityInvbalance = "im_inv_periodbalance";
                invBalanceFilter = new QFilter("qty_bal", "!=", (Object)0);
                invBalanceFilter.or("baseqty_bal", "!=", (Object)0);
                invBalanceFilter.or("qty2nd_bal", "!=", (Object)0);
                invBalanceFilter.and(invBalanceAndCloseFilter);
            }
            if (!(invBalanceKeySet = this.validateBill(entityInvbalance, invBalanceFilter)).isEmpty()) {
                tip = ResManager.loadKDString((String)"\u5b58\u5728\u4f59\u989d\u8bb0\u5f55\u3002", (String)"WarehouseSetupStopUseValidator_18", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMsg(tip, invBalanceKeySet);
            }
            Set<String> orgWarehouseKeySet = this.orgWarehouseEntityMap.keySet();
            QFilter transdirbillQFilter = this.buildBusinessBillQFilter("im_transdirbill", orgWarehouseKeySet);
            QFilter assembbillQFilter = this.buildBusinessBillQFilter("im_assembbill", orgWarehouseKeySet);
            QFilter adjustbillQFilter = this.buildBusinessBillQFilter("im_adjustbill", orgWarehouseKeySet);
            QFilter disassbillQFilter = this.buildBusinessBillQFilter("im_disassemblebill", orgWarehouseKeySet);
            QFilter otherbillsQFilter = this.buildBusinessBillQFilter(IM_OTHERBILLS, orgWarehouseKeySet);
            Set<String> transdirbillKeySet = null;
            Set<String> assembbillKeySet = null;
            Set<String> adjustbillKeySet = null;
            Set<String> disassembbillKeySet = null;
            if (transdirbillQFilter != null) {
                transdirbillKeySet = this.validateBusinessBills("im_transdirbill", transdirbillQFilter);
            }
            if (assembbillQFilter != null) {
                assembbillKeySet = this.validateBusinessBills("im_assembbill", assembbillQFilter);
            }
            if (adjustbillQFilter != null) {
                adjustbillKeySet = this.validateBusinessBills("im_adjustbill", adjustbillQFilter);
            }
            if (disassbillQFilter != null) {
                disassembbillKeySet = this.validateBusinessBills("im_disassemblebill", disassbillQFilter);
            }
            if (otherbillsQFilter != null) {
                this.validateBusinessBills(IM_OTHERBILLS, otherbillsQFilter);
            }
            if (null != transdirbillKeySet && !transdirbillKeySet.isEmpty()) {
                tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u76f4\u63a5\u8c03\u62e8\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMsg(tip, transdirbillKeySet);
            }
            if (null != assembbillKeySet && !assembbillKeySet.isEmpty()) {
                tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u7ec4\u88c5\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMsg(tip, assembbillKeySet);
            }
            if (null != disassembbillKeySet && !disassembbillKeySet.isEmpty()) {
                tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u62c6\u5378\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMsg(tip, disassembbillKeySet);
            }
            if (null != adjustbillKeySet && !adjustbillKeySet.isEmpty()) {
                tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u5f62\u6001\u8f6c\u6362\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMsg(tip, adjustbillKeySet);
            }
        }
    }

    private void addErrorMsg(String msg, Set<String> billKeySet) {
        for (String key : billKeySet) {
            ExtendedDataEntity dataEntity = this.orgWarehouseEntityMap.get(key);
            String warehouseName = this.orgWarehouseNameMap.get(key);
            if (dataEntity == null) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1$s\u201d\u53cd\u542f\u7528\u5931\u8d25\uff0c%2$s", (String)"WarehouseSetupStopUseValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), warehouseName, msg));
        }
    }

    private Set<String> validateBill(String entityName, QFilter qFilter) {
        HashSet<String> orgWarehouseKeySet = new HashSet<String>();
        String selectProperties = "org,warehouse";
        DynamicObjectCollection closeaccountObjs = QueryServiceHelper.query((String)entityName, (String)selectProperties, (QFilter[])qFilter.toArray());
        if (closeaccountObjs != null && closeaccountObjs.size() > 0) {
            String orgId = null;
            String warehouseId = null;
            String orgWarehouseKey = null;
            for (DynamicObject closeaccountObj : closeaccountObjs) {
                orgId = closeaccountObj.getLong("org") + "";
                warehouseId = closeaccountObj.getLong("warehouse") + "";
                if (orgId == null || warehouseId == null) continue;
                orgWarehouseKey = orgId + "," + warehouseId;
                orgWarehouseKeySet.add(orgWarehouseKey);
            }
        }
        return orgWarehouseKeySet;
    }

    private Set<String> validateBusinessBills(String billType, QFilter billQFilter) {
        HashSet<String> orgWarehouseKeyUnionSet = new HashSet<String>();
        switch (billType) {
            case "im_transdirbill": {
                Set<String> transdirOrgWarehouseKeySet = this.validateBusinessBill("im_transdirbill", billQFilter);
                if (transdirOrgWarehouseKeySet.isEmpty()) break;
                orgWarehouseKeyUnionSet.addAll(transdirOrgWarehouseKeySet);
                break;
            }
            case "im_disassemblebill": 
            case "im_adjustbill": 
            case "im_assembbill": {
                Set<String> orgWarehouseKeySet = this.validateBusinessBill(billType, billQFilter);
                if (orgWarehouseKeySet.isEmpty()) break;
                orgWarehouseKeyUnionSet.addAll(orgWarehouseKeySet);
                break;
            }
            case "im_otherbills": {
                this.getGeneralBillsViladateResult(billQFilter);
                break;
            }
        }
        return orgWarehouseKeyUnionSet;
    }

    private Set<String> getGeneralBillsViladateResult(QFilter billQFilter) {
        HashSet<String> orgWarehouseKeyUnionSet = new HashSet<String>();
        Set<String> purOrgWarehouseKeySet = this.validateBusinessBill("im_purinbill", billQFilter);
        Set<String> otherOrgWarehouseKeySet = this.validateBusinessBill("im_otherinbill", billQFilter);
        Set<String> proOrgWarehouseKeySet = this.validateBusinessBill("im_productinbill", billQFilter);
        Set<String> purreceiveOrgWarehouseKeySet = this.validateBusinessBill("im_purreceivebill", billQFilter);
        Set<String> transoutOrgWarehouseKeySet = this.validateBusinessBill("im_transoutbill", billQFilter);
        Set<String> transInOrgWarehouseKeySet = this.validateBusinessBill("im_transinbill", billQFilter);
        Set<String> saleOutOrgWarehouseKeySet = this.validateBusinessBill("im_saloutbill", billQFilter);
        Set<String> materialOrgWarehouseKeySet = this.validateBusinessBill("im_materialreqoutbill", billQFilter);
        Set<String> initOrgWarehouseKeySet = this.validateBusinessBill("im_initbill", billQFilter);
        Set<String> otherOutOrgWarehouseKeySet = this.validateBusinessBill("im_otheroutbill", billQFilter);
        Set<String> locationtransWarehouseKeySet = this.validateBusinessBill("im_locationtransfer", billQFilter);
        String tip = "";
        if (!purOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u91c7\u8d2d\u5165\u5e93\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, purOrgWarehouseKeySet);
        }
        if (!otherOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u5176\u4ed6\u5165\u5e93\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_9", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, otherOrgWarehouseKeySet);
        }
        if (!proOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u751f\u4ea7\u5165\u5e93\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, proOrgWarehouseKeySet);
        }
        if (!purreceiveOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u91c7\u8d2d\u6536\u8d27\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, purreceiveOrgWarehouseKeySet);
        }
        if (!transoutOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u5206\u6b65\u8c03\u51fa\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_12", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, transoutOrgWarehouseKeySet);
        }
        if (!transInOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u5206\u6b65\u8c03\u5165\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_13", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, transInOrgWarehouseKeySet);
        }
        if (!saleOutOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u9500\u552e\u51fa\u5e93\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_14", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, saleOutOrgWarehouseKeySet);
        }
        if (!materialOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u9886\u6599\u51fa\u5e93\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_19", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, materialOrgWarehouseKeySet);
        }
        if (!initOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u521d\u59cb\u5e93\u5b58\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_15", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, initOrgWarehouseKeySet);
        }
        if (!otherOutOrgWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u5176\u4ed6\u51fa\u5e93\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_16", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, otherOutOrgWarehouseKeySet);
        }
        if (!locationtransWarehouseKeySet.isEmpty()) {
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u4ed3\u4f4d\u79fb\u52a8\u5355\u201d\u3002", (String)"WarehouseSetupStopUseValidator_17", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMsg(tip, locationtransWarehouseKeySet);
        }
        return orgWarehouseKeyUnionSet;
    }

    private Set<String> validateBusinessBill(String billEntityName, QFilter billQFilter) {
        HashSet<String> orgWarehouseKeySet = new HashSet<String>();
        switch (billEntityName) {
            case "im_transdirbill": {
                Set<String> transdirbillKeySet = this.validateTransdirbill(billEntityName, billQFilter);
                if (transdirbillKeySet.isEmpty()) break;
                orgWarehouseKeySet.addAll(transdirbillKeySet);
                break;
            }
            case "im_disassemblebill": 
            case "im_assembbill": 
            case "im_adjustbill": {
                Set<String> adjustbillKeySet = this.validateAssembAdjstbill(billEntityName, billQFilter);
                if (adjustbillKeySet.isEmpty()) break;
                orgWarehouseKeySet.addAll(adjustbillKeySet);
                break;
            }
            default: {
                Set<String> generalBusinessBillKeySet = this.validateGeneralBusinessBills(billEntityName, billQFilter, Boolean.FALSE);
                if (generalBusinessBillKeySet.isEmpty()) break;
                orgWarehouseKeySet.addAll(generalBusinessBillKeySet);
                break;
            }
        }
        return orgWarehouseKeySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> validateGeneralBusinessBills(String billEntityName, QFilter billQFilter, boolean isValidateInitStatus) {
        HashSet<String> orgWarehouseKeySet = new HashSet<String>();
        String selectProperties = null;
        String warehouse = null;
        if (isValidateInitStatus) {
            warehouse = "warehouse";
            selectProperties = "org," + warehouse;
        } else {
            warehouse = BILLENTRY_WAREHOUSE;
            selectProperties = "org," + warehouse;
        }
        ORMImpl orm = new ORMImpl();
        GroupbyDataSet groupbyDataSet = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), billEntityName, selectProperties, billQFilter.toArray()).groupBy(new String[]{"org", warehouse});
        try (DataSet dataSet = groupbyDataSet.finish();){
            String billOrgId = null;
            String billWarehouseId = null;
            String billOrgWarehouseKey = null;
            for (Row row : dataSet) {
                billOrgId = row.getLong("org") + "";
                billWarehouseId = row.getLong(warehouse) + "";
                billOrgWarehouseKey = billOrgId + "," + billWarehouseId;
                orgWarehouseKeySet.add(billOrgWarehouseKey);
            }
        }
        return orgWarehouseKeySet;
    }

    private Set<String> validateAssembAdjstbill(String billEntityName, QFilter billQFilter) {
        HashSet<String> orgWarehouseKeySet = new HashSet<String>();
        String selectProperties = "org,billentry.warehouse,billentry.afterentity.warehouse1";
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)billEntityName, (String)selectProperties, (QFilter[])billQFilter.toArray());
        if (billObjs != null && billObjs.size() > 0) {
            String billOrgId = null;
            String billWarehouseId = null;
            String billNextWarehouseId = null;
            String billOrgWarehouseKey = null;
            String billNextOrgWarehouseKey = null;
            for (DynamicObject billObj : billObjs) {
                billOrgId = billObj.getLong("org") + "";
                billWarehouseId = billObj.getLong(BILLENTRY_WAREHOUSE) + "";
                billNextWarehouseId = billObj.getLong(BILLENTRY_AFTERENTITY_WAREHOUSE) + "";
                billOrgWarehouseKey = billOrgId + "," + billWarehouseId;
                billNextOrgWarehouseKey = billOrgId + "," + billNextWarehouseId;
                orgWarehouseKeySet.add(billOrgWarehouseKey);
                orgWarehouseKeySet.add(billNextOrgWarehouseKey);
            }
        }
        return orgWarehouseKeySet;
    }

    private Set<String> validateTransdirbill(String billEntityName, QFilter billQFilter) {
        HashSet<String> orgWarehouseKeySet = new HashSet<String>();
        String selectProperties = "org,outorg,billentry.warehouse,billentry.outwarehouse";
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)billEntityName, (String)selectProperties, (QFilter[])billQFilter.toArray());
        if (billObjs != null && billObjs.size() > 0) {
            String billOrgId = null;
            String billWarehouseId = null;
            String billOutOrgId = null;
            String billOutWarehouseId = null;
            String billOrgWarehouseKey = null;
            String billOutOrgWarehouseKey = null;
            for (DynamicObject billObj : billObjs) {
                billOrgId = billObj.getLong("org") + "";
                billWarehouseId = billObj.getLong(BILLENTRY_WAREHOUSE) + "";
                billOutOrgId = billObj.getLong(OUTORG) + "";
                billOutWarehouseId = billObj.getLong(BILLENTRY_OUTWAREHOUSE) + "";
                billOrgWarehouseKey = billOrgId + "," + billWarehouseId;
                billOutOrgWarehouseKey = billOutOrgId + "," + billOutWarehouseId;
                orgWarehouseKeySet.add(billOrgWarehouseKey);
                orgWarehouseKeySet.add(billOutOrgWarehouseKey);
            }
        }
        return orgWarehouseKeySet;
    }

    private Set<String> validateOrgWarehouseInitStatus(String billEntityName, QFilter billQFilter) {
        return this.validateGeneralBusinessBills(billEntityName, billQFilter, Boolean.TRUE);
    }

    private Map<String, ExtendedDataEntity> buildOrgWarehouseEntityMap() {
        HashMap<String, ExtendedDataEntity> orgWarehouseEntityMap = new HashMap<String, ExtendedDataEntity>();
        ExtendedDataEntity[] rowDataEntitys = this.getDataEntities();
        Long orgPkId = null;
        Long warehousePkId = null;
        String warehouseName = null;
        DynamicObject orgWarehouseObj = null;
        for (ExtendedDataEntity rowDataEntity : rowDataEntitys) {
            orgWarehouseObj = rowDataEntity.getDataEntity();
            orgPkId = orgWarehouseObj.getDynamicObject("org").getLong("id");
            String startstatus = orgWarehouseObj.getString("startstatus");
            if ("A".equals(startstatus)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u9009\u62e9\u8bb0\u5f55\u5305\u542b\u672a\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u542f\u7528\u3002", (String)"WarehouseSetupStopUseValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                continue;
            }
            warehousePkId = orgWarehouseObj.getDynamicObject("warehouse").getLong("id");
            warehouseName = orgWarehouseObj.getDynamicObject("warehouse").getString("name");
            String orgWarehouseKey = orgPkId + "," + warehousePkId;
            orgWarehouseEntityMap.put(orgWarehouseKey, rowDataEntity);
            this.orgWarehouseNameMap.put(orgWarehouseKey, warehouseName);
        }
        return orgWarehouseEntityMap;
    }

    private QFilter buildBillQFilter(boolean isValidateInitStatus) {
        ExtendedDataEntity[] rowDataEntitys = this.getDataEntities();
        Long orgPkId = null;
        Long warehousePkId = null;
        DynamicObject orgWarehouseObj = null;
        QFilter billQFilter = null;
        QFilter orgWarehouseWFilter = null;
        for (ExtendedDataEntity rowDataEntity : rowDataEntitys) {
            orgWarehouseObj = rowDataEntity.getDataEntity();
            orgPkId = orgWarehouseObj.getDynamicObject("org").getLong("id");
            String startstatus = orgWarehouseObj.getString("startstatus");
            if ("A".equals(startstatus)) continue;
            warehousePkId = orgWarehouseObj.getDynamicObject("warehouse").getLong("id");
            orgWarehouseWFilter = new QFilter("org", "=", (Object)orgPkId).and(new QFilter("warehouse", "=", (Object)warehousePkId));
            String initStatusEd = "B";
            if (isValidateInitStatus) {
                orgWarehouseWFilter.and(new QFilter("initstatus", "=", (Object)initStatusEd));
            }
            if (billQFilter == null) {
                billQFilter = orgWarehouseWFilter;
                continue;
            }
            billQFilter.or(orgWarehouseWFilter);
        }
        return billQFilter;
    }

    private QFilter buildBusinessBillQFilter(String billEntityName, Set<String> orgWarehouseKeySet) {
        QFilter billEntryQFilter = null;
        switch (billEntityName) {
            case "im_transdirbill": {
                billEntryQFilter = this.buildTransdirbillQFilter(orgWarehouseKeySet);
                break;
            }
            case "im_assembbill": {
                billEntryQFilter = this.buildAssembAjustbillQFilter(orgWarehouseKeySet);
                break;
            }
            case "im_disassemblebill": {
                billEntryQFilter = this.buildAssembAjustbillQFilter(orgWarehouseKeySet);
                break;
            }
            case "im_adjustbill": {
                billEntryQFilter = this.buildAssembAjustbillQFilter(orgWarehouseKeySet);
                break;
            }
            case "im_otherbills": {
                billEntryQFilter = this.bulidGeneralBusinessBillsQFilter(orgWarehouseKeySet);
                break;
            }
        }
        return billEntryQFilter;
    }

    private QFilter bulidGeneralBusinessBillsQFilter(Set<String> orgWarehouseKeySet) {
        QFilter billEntryQFilter = null;
        String orgPkId = null;
        String warehousePkId = null;
        QFilter orgWFilter = null;
        for (String srcOrgWarehouseKey : orgWarehouseKeySet) {
            orgPkId = srcOrgWarehouseKey.substring(0, srcOrgWarehouseKey.indexOf(","));
            warehousePkId = srcOrgWarehouseKey.substring(srcOrgWarehouseKey.indexOf(",") + 1, srcOrgWarehouseKey.length());
            orgWFilter = new QFilter("org", "=", (Object)Long.parseLong(orgPkId)).and(BILLENTRY_WAREHOUSE, "=", (Object)Long.parseLong(warehousePkId));
            if (billEntryQFilter == null) {
                billEntryQFilter = orgWFilter;
                continue;
            }
            billEntryQFilter.or(orgWFilter);
        }
        return billEntryQFilter;
    }

    private QFilter buildTransdirbillQFilter(Set<String> orgWarehouseKeySet) {
        QFilter billEntryQFilter = null;
        String orgPkId = null;
        String warehousePkId = null;
        QFilter orgWFilter = null;
        for (String srcOrgWarehouseKey : orgWarehouseKeySet) {
            orgPkId = srcOrgWarehouseKey.substring(0, srcOrgWarehouseKey.indexOf(","));
            warehousePkId = srcOrgWarehouseKey.substring(srcOrgWarehouseKey.indexOf(",") + 1, srcOrgWarehouseKey.length());
            orgWFilter = new QFilter("org", "=", (Object)Long.parseLong(orgPkId)).and(BILLENTRY_WAREHOUSE, "=", (Object)Long.parseLong(warehousePkId)).or(new QFilter(OUTORG, "=", (Object)Long.parseLong(orgPkId)).and(BILLENTRY_OUTWAREHOUSE, "=", (Object)Long.parseLong(warehousePkId)));
            if (billEntryQFilter == null) {
                billEntryQFilter = orgWFilter;
                continue;
            }
            billEntryQFilter.or(orgWFilter);
        }
        return billEntryQFilter;
    }

    private QFilter buildAssembAjustbillQFilter(Set<String> orgWarehouseKeySet) {
        QFilter billEntryQFilter = null;
        String orgPkId = null;
        String warehousePkId = null;
        QFilter orgWFilter = null;
        String warehouse = BILLENTRY_WAREHOUSE;
        for (String srcOrgWarehouseKey : orgWarehouseKeySet) {
            orgPkId = srcOrgWarehouseKey.substring(0, srcOrgWarehouseKey.indexOf(","));
            warehousePkId = srcOrgWarehouseKey.substring(srcOrgWarehouseKey.indexOf(",") + 1, srcOrgWarehouseKey.length());
            orgWFilter = new QFilter("org", "=", (Object)Long.parseLong(orgPkId)).and(warehouse, "=", (Object)Long.parseLong(warehousePkId)).or(new QFilter("org", "=", (Object)Long.parseLong(orgPkId)).and(BILLENTRY_AFTERENTITY_WAREHOUSE, "=", (Object)Long.parseLong(warehousePkId)));
            if (billEntryQFilter == null) {
                billEntryQFilter = orgWFilter;
                continue;
            }
            billEntryQFilter.or(orgWFilter);
        }
        return billEntryQFilter;
    }
}

