/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.commons.lang3.StringUtils;

public class BillInvSchemeValidator
extends AbstractValidator {
    private static String[] inCheckFieldsNonOrg = new String[]{"owner", "keeper", "ownertype", "keepertype", "invstatus", "invtype"};
    private static String[] inCheckFieldsOrg = new String[]{"owner", "ownertype", "invstatus", "invtype"};
    private static String[] outCheckFields = new String[]{"outowner", "outkeeper", "outownertype", "outkeepertype", "outinvstatus", "outinvtype"};

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillInvSchemeValidator", (String)"validate");){
            String entityType = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
            if ("im_locationtransfer".equals(entityType)) {
                return;
            }
            HashSet<Object> invSchemes = new HashSet<Object>(16);
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject bill = entity.getDataEntity();
                DynamicObject scheme = bill.getDynamicObject("invscheme");
                if (scheme == null) continue;
                invSchemes.add(scheme.getPkValue());
            }
            Map incSchemeMap = BusinessDataServiceHelper.loadFromCache((Object[])invSchemes.toArray(), (String)"im_invscheme");
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject bill = entity.getDataEntity();
                DynamicObject scheme = bill.getDynamicObject("invscheme");
                if (scheme == null) continue;
                DynamicObject invScheme = scheme;
                if (scheme.getPkValue() != null) {
                    invScheme = (DynamicObject)incSchemeMap.get(scheme.getPkValue());
                }
                String entityName = bill.getDataEntityType().getName();
                String keeperType = invScheme.getString("keepertype");
                String[] inCheckFields = this.getInCheckFields(entityName, keeperType);
                boolean isInUpdate = invScheme.getBoolean("isinupdate");
                boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
                for (int i = 0; i < entries.size(); ++i) {
                    String bizType;
                    String checkValueRangeMsg;
                    String checkMsg;
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    StringBuilder entryMsg = new StringBuilder();
                    StringBuilder entryRangeCheck = new StringBuilder();
                    StringBuilder msg = new StringBuilder();
                    StringBuilder rangeCheckMsg = new StringBuilder();
                    if (isInUpdate) {
                        checkMsg = this.checkValueNull(entry, inCheckFields);
                        if (StringUtils.isNotEmpty((CharSequence)checkMsg)) {
                            entryMsg.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u5f00\u542f\u5165\u5e93\u66f4\u65b0\uff1a", (String)"BillInvSchemeValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0])).append(checkMsg);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(checkValueRangeMsg = this.checkValueRange(invScheme, entry, "inUpdate")))) {
                            entryRangeCheck.append(checkValueRangeMsg);
                        }
                    }
                    if (isOutUpdate) {
                        checkMsg = this.checkValueNull(entry, outCheckFields);
                        if (StringUtils.isNotEmpty((CharSequence)checkMsg)) {
                            entryMsg.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u5f00\u542f\u51fa\u5e93\u66f4\u65b0\uff1a", (String)"BillInvSchemeValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0])).append(checkMsg);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(checkValueRangeMsg = this.checkValueRange(invScheme, entry, "outUpdate")))) {
                            if (StringUtils.isNotEmpty((CharSequence)entryRangeCheck)) {
                                entryRangeCheck.append("\uff0c");
                            }
                            entryRangeCheck.append(checkValueRangeMsg);
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)entryMsg)) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1s\u884c\uff0c%2s", (String)"BillInvSchemeValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1, entryMsg));
                        this.addErrorMessage(entity, msg.toString());
                    }
                    String string = bizType = bill.get("biztype") == null ? "" : bill.getString("biztype.number");
                    if (!StringUtils.isNotEmpty((CharSequence)entryRangeCheck) || bizType.isEmpty() || "370".equals(bizType) || "380".equals(bizType) || "350".equals(bizType) || "351".equals(bizType)) continue;
                    rangeCheckMsg.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1s\u884c\uff0c%2s\u4e0e\u5e93\u5b58\u4e8b\u52a1\u4e0d\u4e00\u81f4\u3002", (String)"BillInvSchemeValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1, entryRangeCheck));
                    this.addErrorMessage(entity, rangeCheckMsg.toString());
                }
            }
        }
    }

    private String checkValueRange(DynamicObject invScheme, DynamicObject entry, String updateDirection) {
        boolean checkInvInvStatus;
        String entryKeeperTypeKey;
        String entryOwnerTypeKey;
        String entryInvStatusKey;
        String entryInvTypeKey;
        String keeperTypeKey;
        String ownerTypeKey;
        String invStatusEntryKey;
        String invTypeEntryKey;
        StringBuilder msg = new StringBuilder();
        if ("inUpdate".equals(updateDirection)) {
            invTypeEntryKey = "invtypeentry";
            invStatusEntryKey = "invstatusentry";
            ownerTypeKey = "ownertype1";
            keeperTypeKey = "keepertype1";
            entryInvTypeKey = "invtype";
            entryInvStatusKey = "invstatus";
            entryOwnerTypeKey = "ownertype";
            entryKeeperTypeKey = "keepertype";
        } else {
            invTypeEntryKey = "outinvtypeentry";
            invStatusEntryKey = "outinvstatusentry";
            ownerTypeKey = "outownertype1";
            keeperTypeKey = "outkeepertype1";
            entryInvTypeKey = "outinvtype";
            entryInvStatusKey = "outinvstatus";
            entryOwnerTypeKey = "outownertype";
            entryKeeperTypeKey = "outkeepertype";
        }
        DynamicObjectCollection invTypeList = invScheme.getDynamicObjectCollection(invTypeEntryKey);
        DynamicObjectCollection invStatusList = invScheme.getDynamicObjectCollection(invStatusEntryKey);
        DynamicObject invType = entry.getDynamicObject(entryInvTypeKey);
        DynamicObject invStatus = entry.getDynamicObject(entryInvStatusKey);
        String ownerType = entry.getString(entryOwnerTypeKey);
        String keeperType = entry.getString(entryKeeperTypeKey);
        boolean checkInvType = this.checkDynamicObjectCollection(invTypeList, invType, entryInvTypeKey);
        if (checkInvType) {
            msg.append(this.getDisplayName(entry, entryInvTypeKey)).append("\uff0c");
        }
        if (checkInvInvStatus = this.checkDynamicObjectCollection(invStatusList, invStatus, entryInvStatusKey)) {
            msg.append(this.getDisplayName(entry, entryInvStatusKey)).append("\uff0c");
        }
        if (StringUtils.isEmpty((CharSequence)msg)) {
            boolean checkKeeperType;
            boolean checkOwnerType = this.checkEntryOwnerKeeper(invTypeList, ownerType, ownerTypeKey, invType, entryInvTypeKey);
            if (!checkOwnerType) {
                msg.append(this.getDisplayName(entry, entryOwnerTypeKey)).append("\uff0c");
            }
            if (!(checkKeeperType = this.checkEntryOwnerKeeper(invTypeList, keeperType, keeperTypeKey, invType, entryInvTypeKey))) {
                msg.append(this.getDisplayName(entry, entryKeeperTypeKey)).append("\uff0c");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            msg.deleteCharAt(msg.length() - 1);
        }
        return msg.toString();
    }

    private boolean checkDynamicObjectCollection(DynamicObjectCollection invTypeList, DynamicObject invType, String baseDataKey) {
        if (invType == null) {
            return false;
        }
        Object invTypePk = invType.getPkValue();
        ArrayList<Object> pks = new ArrayList<Object>(invTypeList.size());
        for (DynamicObject invSchemeInvType : invTypeList) {
            DynamicObject invBaseData = invSchemeInvType.getDynamicObject(baseDataKey);
            if (invBaseData == null) continue;
            pks.add(invBaseData.getPkValue());
        }
        return !pks.contains(invTypePk);
    }

    private boolean checkEntryOwnerKeeper(DynamicObjectCollection invTypeList, String ownerKeeperType, String ownerKeeperTypeKey, DynamicObject invType, String invTypeKey) {
        if (invType == null) {
            return true;
        }
        if (ownerKeeperType == null) {
            return false;
        }
        Object invTypePkValue = invType.getPkValue();
        for (DynamicObject invTypeEntry : invTypeList) {
            String schemeOwnerKeeperType;
            Object schemeInvTypePkValue;
            DynamicObject schemeInvType = invTypeEntry.getDynamicObject(invTypeKey);
            if (schemeInvType == null || !(schemeInvTypePkValue = schemeInvType.getPkValue()).equals(invTypePkValue) || !ownerKeeperType.equals(schemeOwnerKeeperType = invTypeEntry.getString(ownerKeeperTypeKey))) continue;
            return true;
        }
        return false;
    }

    private String checkValueNull(DynamicObject entry, String ... args) {
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            Object value = entry.get(args[i]);
            if (value != null) continue;
            msg.append(this.getDisplayName(entry, args[i])).append(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillInvSchemeValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    private String getDisplayName(DynamicObject entry, String key) {
        return ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)key)).getDisplayName().toString();
    }

    private String[] getInCheckFields(String entityName, String keepErType) {
        if ("im_materialreqoutbill".equals(entityName) && "bos_org".equals(keepErType)) {
            return inCheckFieldsOrg;
        }
        return inCheckFieldsNonOrg;
    }
}

