/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class BillQtyIsEqValidator
extends AbstractValidator {
    protected static final Log logger = LogFactory.getLog(BillQtyIsEqValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillQtyValidator", (String)"validate");){
            String entryName = null;
            String subEntryName = null;
            BillEntityType entityType = null;
            boolean isTransBill = false;
            boolean isApplyBill = false;
            DynamicObject transObjType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"dentityid", (QFilter[])new QFilter("number", "=", (Object)"im_transformbilltpl").toArray());
            DynamicObject applyObjType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"dentityid", (QFilter[])new QFilter("number", "=", (Object)"im_applybilltpl").toArray());
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject data = entity.getDataEntity();
                if (entityType == null) {
                    entityType = (BillEntityType)data.getDataEntityType();
                    isTransBill = entityType.getInheritPath().contains(transObjType.getString("dentityid"));
                    isApplyBill = entityType.getInheritPath().contains(applyObjType.getString("dentityid"));
                }
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    if (entryName == null) {
                        entryName = entry.getDynamicObjectType().getDisplayName().getLocaleValue();
                    }
                    int seq = entry.getInt("seq");
                    DynamicObject unit = entry.getDynamicObject("unit");
                    DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                    BigDecimal qty = entry.getBigDecimal("qty").abs();
                    BigDecimal baseQty = entry.getBigDecimal("baseqty").abs();
                    if (unit == null || baseUnit == null) continue;
                    if (isApplyBill) {
                        qty = entry.getBigDecimal("auditqty").abs();
                        if (!unit.getPkValue().equals(baseUnit.getPkValue()) || qty.compareTo(baseQty) == 0) continue;
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\uff0c\u6838\u51c6\u6570\u91cf\u548c\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BillQtyIsEqValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), entryName, seq));
                        continue;
                    }
                    if (unit.getPkValue().equals(baseUnit.getPkValue()) && qty.compareTo(baseQty) != 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\uff0c\u6570\u91cf\u548c\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BillQtyIsEqValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), entryName, seq));
                    }
                    if (!isTransBill) continue;
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("afterentity");
                    for (DynamicObject subEntry : subEntrys) {
                        if (subEntryName == null) {
                            subEntryName = subEntry.getDynamicObjectType().getDisplayName().getLocaleValue();
                        }
                        int afterSeq = subEntry.getInt("seq");
                        DynamicObject afterUnit = subEntry.getDynamicObject("unit1");
                        DynamicObject afterBaseUnit = subEntry.getDynamicObject("baseunit1");
                        BigDecimal afterQty = subEntry.getBigDecimal("qty1");
                        BigDecimal afterBaseQty = subEntry.getBigDecimal("baseqty1");
                        if (afterUnit == null || afterBaseUnit == null || !afterUnit.getPkValue().equals(afterBaseUnit.getPkValue()) || afterQty.compareTo(afterBaseQty) == 0) continue;
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5bf9\u5e94\u7684%3$s\u7b2c%4$s\u884c\uff0c\u6570\u91cf\u548c\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BillQtyIsEqValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), entryName, seq, subEntryName, afterSeq));
                    }
                }
            }
        }
    }
}

