/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.scmc.im.utils.DateUtils;

public class BillTplCalCloseCheckValidator
extends AbstractValidator {
    protected static final Log logger = LogFactory.getLog(BillTplCalCloseCheckValidator.class);
    private Set<Long> ownerIds = new HashSet<Long>(16);
    private Map<Long, String> ownerInfo = new HashMap<Long, String>(16);
    private Map<Long, Object[]> startDateMap = new HashMap<Long, Object[]>(16);
    private Map<Long, Object[]> closeDateMap = new HashMap<Long, Object[]>(16);
    private Map<Long, Set<Long>> billOwners = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Object[]> hasInitMap = new HashMap<Long, Object[]>(16);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillTplCalCloseCheckValidator", (String)"validate");){
            if (!MetaDataHelper.isBizAppExistCal()) {
                return;
            }
            boolean updateEnable = "submit".equals(this.getOperateKey());
            this.getAllOwnerIds();
            this.getCloseDate();
            String entityName = this.getValidateContext().getBillEntityType().getName();
            if ("im_initbill".equals(entityName)) {
                this.checkOwnerInit();
                ValidateResult validateResult = this.getValidateResult();
                List allErrorInfo = validateResult.getAllErrorInfo();
                if (!allErrorInfo.isEmpty()) {
                    return;
                }
                this.checkStockInDate();
            }
            boolean closeNextDayEnable = SupplyChainParameterHelper.getEnableScmParam((String)"INV0008");
            boolean dateEqualsEnable = SupplyChainParameterHelper.getEnableScmParam((String)"INV0004");
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject invBill = entity.getDataEntity();
                if (null == invBill || this.isSkip(invBill)) continue;
                if (!"unaudit".equals(this.getOperateKey()) && !"unsubmit".equals(this.getOperateKey())) {
                    CloseDateHelper.initBookDate((String)this.entityKey, (DynamicObject)invBill);
                }
                Date date = invBill.getDate("bookdate");
                if ((date = DateUtils.getDayStartTime((Date)date)) == null) {
                    return;
                }
                for (Long id : this.ownerIds) {
                    if (!this.startDateMap.isEmpty()) {
                        Object[] startDateValues = this.startDateMap.get(id);
                        this.isBeforeStartDate(entity, date, startDateValues);
                    }
                    if (this.closeDateMap.isEmpty()) continue;
                    if (closeNextDayEnable && updateEnable) {
                        this.updateDate(entity, dateEqualsEnable);
                        continue;
                    }
                    Object[] closeDateValues = this.closeDateMap.get(id);
                    this.isAfterCloseDate(entity, date, closeDateValues, id);
                }
            }
        }
    }

    private void updateDate(ExtendedDataEntity entity, boolean dateEqualsEnable) {
        Set<Long> owners = this.billOwners.get((Long)entity.getBillPkId());
        Date laseCloseDate = null;
        for (Long owner : owners) {
            Date closeDate;
            Object[] objects = this.closeDateMap.get(owner);
            if (objects == null || (closeDate = (Date)objects[0]) == null || laseCloseDate != null && closeDate.compareTo(laseCloseDate) <= 0) continue;
            laseCloseDate = closeDate;
        }
        Date bookDate = (Date)entity.getValue("bookdate");
        if (bookDate != null && laseCloseDate != null && laseCloseDate.compareTo(bookDate) >= 0) {
            Date time = DateUtils.addOneDay((Date)laseCloseDate);
            entity.setValue("bookdate", (Object)time);
            if (dateEqualsEnable) {
                entity.setValue("biztime", (Object)time);
            }
        }
    }

    private boolean isSkip(DynamicObject invBill) {
        boolean isExist = MetaDataHelper.isExistField((IDataEntityType)invBill.getDataEntityType(), (String)"isinitbill");
        return isExist && invBill.getBoolean("isinitbill");
    }

    private void checkOwnerInit() {
        if (this.hasInitMap != null && !this.hasInitMap.isEmpty()) {
            Set<Long> initOwners = this.hasInitMap.keySet();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    Long ownerId;
                    DynamicObject owner = entry.getDynamicObject("owner");
                    if (owner == null || !initOwners.contains(ownerId = Long.valueOf(owner.getLong("id")))) continue;
                    String ownerName = owner.getString("name");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u5e93\u8d27\u4e3b\u201c%s\u201d\u5728\u5b58\u8d27\u6838\u7b97\u6a21\u5757\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u521d\u59cb\u5e93\u5b58\u5355\u3002", (String)"BillTplCalCloseCheckValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), ownerName));
                }
            }
        }
    }

    private void checkStockInDate() {
        if (this.startDateMap != null && !this.startDateMap.isEmpty()) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (int i = 0; i < entrys.size(); ++i) {
                    Date startDate;
                    long ownerId;
                    Object[] startDateValues;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    Date stockInDate = entry.getDate("stockindate");
                    DynamicObject owner = entry.getDynamicObject("owner");
                    if (null == stockInDate || null == owner || (startDateValues = this.startDateMap.get(ownerId = owner.getLong("id"))) == null || startDateValues.length <= 0 || stockInDate.compareTo(startDate = (Date)startDateValues[0]) < 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1s\u884c\uff0c\u5f53\u524d\u8ba1\u7b97\u540e\u5165\u5e93\u65e5\u671f\u201c%2s\u201d\u5927\u4e8e\u7b49\u4e8e\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8d26\u7c3f\uff08\u7f16\u7801\u201c%3s\u201d\uff0c\u540d\u79f0\u201c%4s\u201d\uff09\u7684\u6838\u7b97\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%5s\u201d\u3002", (String)"BillTplCalCloseCheckValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1, DateUtils.getDateString((Date)stockInDate), startDateValues[1], startDateValues[2], DateUtils.getDateString((Date)startDate)));
                }
            }
        }
    }

    private void getAllOwnerIds() {
        if ("im_transinbill".equals(this.entityKey) || "im_transoutbill".equals(this.entityKey)) {
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject invScheme;
                DynamicObject invBill = entity.getDataEntity();
                if (null == invBill || this.isSkip(invBill) || (invScheme = invBill.getDynamicObject("invscheme")) == null) continue;
                boolean isInUpd = invScheme.getBoolean("isinupdate");
                boolean isOutUpd = invScheme.getBoolean("isoutupdate");
                DynamicObjectCollection invBillEntryList = invBill.getDynamicObjectCollection("billentry");
                HashSet<Long> owners = new HashSet<Long>();
                for (DynamicObject entry : invBillEntryList) {
                    String ownerName;
                    String ownerNum;
                    long ownerId;
                    DynamicObject owner;
                    if (isInUpd) {
                        owner = null;
                        owner = "im_transinbill".equals(this.entityKey) ? entry.getDynamicObject("owner") : entry.getDynamicObject("transitowner");
                        if (owner != null) {
                            ownerId = owner.getLong("id");
                            ownerNum = owner.getString("number");
                            ownerName = owner.getString("name");
                            this.ownerIds.add(ownerId);
                            this.ownerInfo.put(ownerId, ownerNum + "." + ownerName);
                            owners.add(ownerId);
                        }
                    }
                    if (!isOutUpd) continue;
                    owner = null;
                    owner = "im_transinbill".equals(this.entityKey) ? entry.getDynamicObject("transitowner") : entry.getDynamicObject("outowner");
                    if (owner == null) continue;
                    ownerId = owner.getLong("id");
                    ownerNum = owner.getString("number");
                    ownerName = owner.getString("name");
                    this.ownerIds.add(ownerId);
                    this.ownerInfo.put(ownerId, ownerNum + "." + ownerName);
                    owners.add(ownerId);
                }
                this.billOwners.put((Long)entity.getBillPkId(), owners);
            }
            return;
        }
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject invBill = entity.getDataEntity();
            if (null == invBill || this.isSkip(invBill)) continue;
            DynamicObjectCollection invBillEntryList = invBill.getDynamicObjectCollection("billentry");
            HashSet<Long> owners = new HashSet<Long>();
            for (DynamicObject entry : invBillEntryList) {
                DynamicObject owner = entry.getDynamicObject("owner");
                if (owner != null) {
                    long ownerId = owner.getLong("id");
                    String ownerNum = owner.getString("number");
                    String ownerName = owner.getString("name");
                    this.ownerIds.add(ownerId);
                    this.ownerInfo.put(ownerId, ownerNum + "." + ownerName);
                    owners.add(ownerId);
                }
                if ("im_locationtransfer".equals(this.entityKey) || entry.getDynamicObject("outowner") == null) continue;
                DynamicObject outOwner = entry.getDynamicObject("outowner");
                long outOwnerId = outOwner.getLong("id");
                String outOwnerNum = outOwner.getString("number");
                String outOwnerName = outOwner.getString("name");
                this.ownerIds.add(outOwnerId);
                this.ownerInfo.put(outOwnerId, outOwnerNum + "." + outOwnerName);
                owners.add(outOwnerId);
            }
            this.billOwners.put((Long)entity.getBillPkId(), owners);
        }
    }

    private void getCloseDate() {
        try {
            Map ownerCloseDate = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCloseService", (String)"getOwnerCloseDate", (Object[])new Object[]{this.ownerIds});
            this.startDateMap = (Map)ownerCloseDate.get("startDate");
            this.closeDateMap = (Map)ownerCloseDate.get("closeDate");
            this.hasInitMap = (Map)ownerCloseDate.get("hasInit");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5b58\u8d27\u6838\u7b97\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloseDateHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private void isBeforeStartDate(ExtendedDataEntity entity, Date bookDate, Object[] startDateValues) {
        if (startDateValues == null || startDateValues.length <= 0) {
            return;
        }
        Date startDate = (Date)startDateValues[0];
        String entityName = this.getValidateContext().getBillEntityType().getName();
        if (bookDate.compareTo(startDate) < 0 && !"im_initbill".equals(entityName)) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u201c%1s\u201d\u5c0f\u4e8e\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8d26\u7c3f\uff08\u7f16\u7801\u201c%2s\u201d\uff0c\u540d\u79f0\u201c%3s\u201d\uff09\u7684\u6838\u7b97\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%4s\u201d\u3002", (String)"BillTplCalCloseCheckValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), DateUtils.getDateString((Date)bookDate), startDateValues[1], startDateValues[2], DateUtils.getDateString((Date)startDate)));
        } else if (bookDate.compareTo(startDate) >= 0 && "im_initbill".equals(entityName)) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u201c%1s\u201d\u5927\u4e8e\u7b49\u4e8e\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8d26\u7c3f\uff08\u7f16\u7801\u201c%2s\u201d\uff0c\u540d\u79f0\u201c%3s\u201d\uff09\u7684\u6838\u7b97\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%4s\u201d\u3002", (String)"BillTplCalCloseCheckValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), DateUtils.getDateString((Date)bookDate), startDateValues[1], startDateValues[2], DateUtils.getDateString((Date)startDate)));
        }
    }

    private void isAfterCloseDate(ExtendedDataEntity entity, Date bizDate, Object[] closeDateValues, Long ownerId) {
        if (closeDateValues == null || closeDateValues.length <= 0) {
            return;
        }
        Date closeDate = (Date)closeDateValues[0];
        if (bizDate.compareTo(closeDate) <= 0) {
            String ownerNumAndName = this.ownerInfo.get(ownerId);
            String[] ownerNumName = ownerNumAndName.split("\\.");
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u5c0f\u4e8e\u7b49\u4e8e\u8d27\u4e3b\uff08\u7f16\u7801\u201c%2$s\u201d\uff0c\u540d\u79f0\u201c%3$s\u201d\uff09\u7684\u6838\u7b97\u5173\u8d26\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u80fd%5$s\u5f53\u524d\u53ca\u4ee5\u524d\u8bb0\u8d26\u65e5\u671f\u5355\u636e\uff0c\u8bf7\u5148\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u6216\u8005\u5148\u53cd\u5173\u8d26\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BillTplCalCloseCheckValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), DateUtils.getDateString((Date)bizDate), ownerNumName[0], ownerNumName[1], DateUtils.getDateString((Date)closeDate), this.getOperationName()));
        }
    }
}

