/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class BillTplCalUnSubmitValidator
extends AbstractValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillTplCalUnSubmitValidator", (String)"validate");){
            if (this.dataEntities == null || this.dataEntities.length <= 0) {
                return;
            }
            if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0001")) {
                return;
            }
            if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0005")) {
                return;
            }
            HashSet<Object> pkIds = new HashSet<Object>(16);
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject dataEntity = entity.getDataEntity();
                pkIds.add(dataEntity.getPkValue());
            }
            String requestId = RequestContext.get().getRequestId();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fbillid, frequestid from t_im_taskcollaborate where ", new Object[0]);
            sqlBuilder.appendIn("fbillid", pkIds.toArray());
            HashSet<Object> existBills = new HashSet<Object>(16);
            try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute("scm"), (SqlBuilder)sqlBuilder);){
                for (Row row : dataSet) {
                    Object fBillId = row.get("fbillid");
                    String fRequestId = row.getString("frequestid");
                    if (requestId != null && StringUtils.equals((CharSequence)requestId, (CharSequence)fRequestId)) continue;
                    existBills.add(fBillId);
                }
            }
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject dataEntity = entity.getDataEntity();
                Object pkValue = dataEntity.getPkValue();
                String billNum = dataEntity.getString("billno");
                if (!existBills.contains(pkValue)) continue;
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"%s\u540c\u6b65\u6838\u7b97\u7684\u4e1a\u52a1\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"BillTplCalUnSubmitValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNum), ErrorLevel.Error);
            }
        }
    }
}

