/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.im.business.helper.MetaDataHelper;

public class ConfiguredCodeMustInputValidator
extends AbstractValidator {
    private static final String CONFIGPROPERTIES = "configproperties";
    private static final String CONFIGURABLE = "2";

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("configuredcode");
        set.add("tracknumber");
        set.add("configuredcode1");
        set.add("tracknumber1");
        return set;
    }

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkConfiguredCodeAndTrackNum(entity);
        }
    }

    private void checkConfiguredCodeAndTrackNum(ExtendedDataEntity entity) {
        DynamicObject billEntity = entity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        if (col == null || col.isEmpty()) {
            return;
        }
        String entryName = col.getDynamicObjectType().getDisplayName().getLocaleValue();
        for (int i = 0; i < col.size(); ++i) {
            Boolean containAfterEntity;
            DynamicObject material;
            DynamicObject row = (DynamicObject)col.get(i);
            DynamicObject materialInvInfo = row.getDynamicObject("material");
            if (materialInvInfo == null || (material = materialInvInfo.getDynamicObject("masterid")) == null) continue;
            String configProperties = material.getString(CONFIGPROPERTIES);
            DynamicObject configuredCode = row.getDynamicObject("configuredcode");
            if (CONFIGURABLE.equals(configProperties) && null == configuredCode) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c%2s\u7684\u7269\u6599\u914d\u7f6e\u5c5e\u6027\u4e3a\u914d\u7f6e\u4ef6\uff0c\u914d\u7f6e\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ConfiguredCodeMustInputValidator_13", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1, entryName), ErrorLevel.Error);
            }
            if (configuredCode != null) {
                DynamicObject configCodeMaterial = configuredCode.getDynamicObject("material");
                Object materialPkValue = material.getPkValue();
                if (!materialPkValue.equals(configCodeMaterial.getPkValue())) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c%2s\u7684\u914d\u7f6e\u53f7\u201c%3s\u201d\u4e0e\u5355\u636e\u7269\u6599\u201c%4s\u201d\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfiguredCodeMustInputValidator_12", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1, entryName, configuredCode.get("number"), material.get("number")), ErrorLevel.Error);
                }
            }
            if (!(containAfterEntity = Boolean.valueOf(MetaDataHelper.isExistField((IDataEntityType)row.getDataEntityType(), (String)"afterentity"))).booleanValue()) continue;
            DynamicObjectCollection afterEntries = row.getDynamicObjectCollection("afterentity");
            String subEntryName = afterEntries.getDynamicObjectType().getDisplayName().getLocaleValue();
            int size = afterEntries.size();
            for (int j = 0; j < size; ++j) {
                DynamicObject afterMaterial;
                DynamicObject afterEntry = (DynamicObject)afterEntries.get(j);
                DynamicObject afterMaterialInvInfo = afterEntry.getDynamicObject("material1");
                if (afterMaterialInvInfo == null || (afterMaterial = afterMaterialInvInfo.getDynamicObject("masterid")) == null) continue;
                String afterConfigProperties = afterMaterial.getString(CONFIGPROPERTIES);
                DynamicObject afterConfiguredcode = afterEntry.getDynamicObject("configuredcode1");
                if (CONFIGURABLE.equals(afterConfigProperties) && null == afterConfiguredcode) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c%2s\u5bf9\u5e94\u7684\u7b2c%3s\u884c%4s\u7684\u7269\u6599\u914d\u7f6e\u5c5e\u6027\u4e3a\u914d\u7f6e\u4ef6\uff0c\u914d\u7f6e\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ConfiguredCodeMustInputValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1, entryName, j + 1, subEntryName), ErrorLevel.Error);
                }
                if (afterConfiguredcode == null) continue;
                DynamicObject configCodeMaterial = afterConfiguredcode.getDynamicObject("material");
                Object materialPkValue = afterMaterial.getPkValue();
                if (materialPkValue.equals(configCodeMaterial.getPkValue())) continue;
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c%2s\u5bf9\u5e94\u7684\u7b2c%3s\u884c%4s\u7684\u914d\u7f6e\u53f7\u201c%5s\u201d\u4e0e\u5355\u636e\u7269\u6599\u201c%6s\u201d\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfiguredCodeMustInputValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1, entryName, j + 1, subEntryName, afterConfiguredcode.get("number"), material.get("number")), ErrorLevel.Error);
            }
        }
    }
}

