/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.business.helper.AppParameterHelper;

public class OperatorSubmitValidator
extends AbstractValidator {
    public void validate() {
        Map<String, Map<String, Object>> opGroupIsolateMap = this.getAppParameters();
        if (opGroupIsolateMap == null || opGroupIsolateMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkOperator(entity, opGroupIsolateMap);
        }
    }

    private Map<String, Map<String, Object>> getAppParameters() {
        ArrayList<Long> orgIds = new ArrayList<Long>(this.dataEntities.length);
        String formId = this.getValidateContext().getBillEntityType().getName();
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject outOrg;
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org != null) {
                orgIds.add((Long)org.getPkValue());
            }
            if (!"im_transdirbill".equals(formId) || (outOrg = bill.getDynamicObject("outorg")) == null) continue;
            orgIds.add((Long)outOrg.getPkValue());
        }
        return AppParameterHelper.getBatchAppParameterByFormId((String)formId, orgIds);
    }

    private void checkOperator(ExtendedDataEntity entity, Map<String, Map<String, Object>> opGroupIsolateMap) {
        DynamicObject bill = entity.getDataEntity();
        String formId = bill.getDataEntityType().getName();
        boolean isTransDirBill = "im_transdirbill".equals(formId);
        DynamicObject org = (DynamicObject)bill.get("org");
        if (org == null) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7", (String)"OperatorSubmitValidator_12", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!"im_invcountbill".equals(formId)) {
            boolean isMeasureAdjustBizType;
            DynamicObject bizType = bill.getDynamicObject("biztype");
            boolean bl = isMeasureAdjustBizType = bizType != null && ("380".equals(bizType.get("number")) || "370".equals(bizType.get("number")));
            if (isMeasureAdjustBizType) {
                return;
            }
        }
        Map<String, Object> opGroupMap = opGroupIsolateMap.get(org.getPkValue().toString());
        Object operatorGroupIsolate = null;
        if (opGroupMap != null) {
            operatorGroupIsolate = opGroupMap.get("foperatorgroupisolate");
        }
        String msg = "";
        if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            Boolean checkBizGroup;
            if (!isTransDirBill && bill.get("operator") != null) {
                return;
            }
            if (isTransDirBill && "A".equals(bill.getString("transtype")) && (bill.get("operator") == null || bill.get("outoperator") == null)) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u7ec4\u7ec7\u5df2\u5f00\u542f\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u9009\u62e9\u8c03\u5165\u5e93\u7ba1\u5458\u6216\u8c03\u51fa\u5e93\u7ba1\u5458\u3002", (String)"OperatorSubmitValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            } else if (isTransDirBill && (bill.get("operator") == null || bill.get("outoperator") == null)) {
                DynamicObject outOrg = (DynamicObject)bill.get("outorg");
                if (outOrg == null) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7", (String)"OperatorSubmitValidator_12", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                    return;
                }
                Map<String, Object> outOpGroupMap = opGroupIsolateMap.get(outOrg.getPkValue().toString());
                Object outOrgOperatorGroupIsolate = null;
                if (outOpGroupMap != null) {
                    outOrgOperatorGroupIsolate = opGroupMap.get("foperatorgroupisolate");
                }
                if (outOrgOperatorGroupIsolate instanceof Boolean && ((Boolean)outOrgOperatorGroupIsolate).booleanValue()) {
                    msg = ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u7ec4\u7ec7\u5df2\u5f00\u542f\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u9009\u62e9\u8c03\u5165\u5e93\u7ba1\u5458\u6216\u8c03\u51fa\u5e93\u7ba1\u5458\u3002", (String)"OperatorSubmitValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                } else if (bill.get("operator") == null) {
                    msg = ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u5165\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u9009\u62e9\u8c03\u5165\u5e93\u7ba1\u5458\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"OperatorSubmitValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                }
            } else if ("im_purreceivebill".equals(formId) && bill.get("operator") == null) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u6536\u8d27\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u9009\u62e9\u6536\u8d27\u5458\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"OperatorSubmitValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            } else if (bill.get("operator") == null && (checkBizGroup = Boolean.valueOf(!"im_mdc_omcmplinbill".equals(formId) || !"B".equals(bill.getString("modeltype")))).booleanValue()) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u9009\u62e9\u5e93\u7ba1\u5458\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"OperatorSubmitValidator_9", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            }
        } else if (isTransDirBill) {
            DynamicObject outOrg = (DynamicObject)bill.get("outorg");
            Map<String, Object> outOpGroupMap = opGroupIsolateMap.get(outOrg.getPkValue().toString());
            Object outOrgOperatorGroupIsolate = null;
            if (outOpGroupMap != null) {
                outOrgOperatorGroupIsolate = outOpGroupMap.get("foperatorgroupisolate");
            }
            if (outOrgOperatorGroupIsolate instanceof Boolean && ((Boolean)outOrgOperatorGroupIsolate).booleanValue() && bill.get("outoperator") == null) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u51fa\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u9009\u62e9\u8c03\u51fa\u5e93\u7ba1\u5458\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"OperatorSubmitValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            }
        }
        if (!"".equals(msg)) {
            this.addErrorMessage(entity, msg);
        }
    }
}

