/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.Date;
import java.util.LinkedHashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class ShelfLifeDateAfterEntryValidator
extends AbstractValidator {
    public void validate() {
        int count = 0;
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billEntity = entity.getDataEntity();
            DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject row : col) {
                DynamicObjectCollection afterEntries = row.getDynamicObjectCollection("afterentity");
                LinkedHashSet<Integer> sets = new LinkedHashSet<Integer>();
                String entryName = col.getDynamicObjectType().getDisplayName().getLocaleValue();
                String afterEntryName = afterEntries.getDynamicObjectType().getDisplayName().getLocaleValue();
                for (DynamicObject afterEntry : afterEntries) {
                    Date produceDate = afterEntry.getDate("producedate1");
                    Date expiryDate = afterEntry.getDate("expirydate1");
                    DynamicObject materialInvInfo = afterEntry.getDynamicObject("material1");
                    if (materialInvInfo == null) continue;
                    if (materialInvInfo.getBoolean("enableshelflifemgr")) {
                        if (produceDate != null && expiryDate != null) continue;
                        sets.add(afterEntry.getInt("seq"));
                        continue;
                    }
                    if (produceDate == null && expiryDate == null) continue;
                    String msg = ResManager.loadKDString((String)"%1s\u7b2c%2s\u884c\u5bf9\u5e94\u7684%3s\u7b2c%4s\u884c\u7269\u6599\u672a\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u751f\u4ea7\u65e5\u671f\u548c\u5230\u671f\u65e5\u671f\u4e0d\u53ef\u586b\u5199\u3002", (String)"ShelfLifeDateAfterEntryValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                    this.addMessage(entity, String.format(msg, entryName, row.getInt("seq"), afterEntryName, afterEntry.getInt("seq")), ErrorLevel.Error);
                    if (++count < 1000) continue;
                    this.addMessage(entity, ResManager.loadKDString((String)"\u5931\u8d25\u4fe1\u606f\u8fc7\u591a\uff0c\u65e0\u6cd5\u5c55\u793a\uff0c\u5efa\u8bae\u5148\u5904\u7406\u73b0\u5728\u7684\u5931\u8d25\u539f\u56e0\u3002", (String)"ShelfLifeDateAfterEntryValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (sets.size() == 0) continue;
                String msg = ResManager.loadKDString((String)"%1s\u7b2c%2s\u884c\u5206\u5f55\u4e2d\uff0c%3s\u7269\u6599\u7b2c%4s\u884c\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u751f\u4ea7\u65e5\u671f\u548c\u5230\u671f\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ShelfLifeDateAfterEntryValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addMessage(entity, String.format(msg, entryName, row.getInt("seq"), afterEntryName, sets), ErrorLevel.Error);
                if (++count < 1000) continue;
                this.addMessage(entity, ResManager.loadKDString((String)"\u5931\u8d25\u4fe1\u606f\u8fc7\u591a\uff0c\u65e0\u6cd5\u5c55\u793a\uff0c\u5efa\u8bae\u5148\u5904\u7406\u73b0\u5728\u7684\u5931\u8d25\u539f\u56e0\u3002", (String)"ShelfLifeDateAfterEntryValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

