/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.MaterielIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.MaterielScopeResultHandle;
import kd.scmc.im.business.helper.datactrl.QualifiedMaterielIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.QualifiedMaterielScopeResultHandle;
import kd.scmc.im.business.helper.datactrl.UnQualifiedMaterielIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.UnQualifiedMaterielScopeResultHandle;

public class WarehouseMaterialValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(WarehouseMaterialValidator.class);
    private Map<Long, Object> materialScopeMap = new HashMap<Long, Object>(16);
    private Map<Long, Boolean> materialIsolateMap = new HashMap<Long, Boolean>(16);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"WarehouseMaterialValidator", (String)"validate");){
            this.loadParamMap();
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject billEntity = entity.getDataEntity();
                DynamicObject org = billEntity.getDynamicObject("org");
                if (org == null) continue;
                this.checkMaterialScope(entity);
                this.checkMaterialIsolate(entity);
            }
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5355\u636e\u7269\u6599\u8303\u56f4\u6821\u9a8c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean isTransBill() {
        String entityName = this.entityKey;
        return entityName.equals("im_assembbill") || entityName.equals("im_disassemblebill") || entityName.equals("im_adjustbill");
    }

    private void checkMaterialIsolate(ExtendedDataEntity entity) {
        DynamicObject billEntity = entity.getDataEntity();
        Long orgId = billEntity.getLong("org.id");
        Boolean isolate = this.materialIsolateMap.getOrDefault(orgId, Boolean.FALSE);
        if (!isolate.booleanValue()) {
            return;
        }
        String entryDisplayName = billEntity.getDataEntityType().getDisplayName().getLocaleValue();
        DynamicObjectCollection entryRows = billEntity.getDynamicObjectCollection("billentry");
        boolean isTransBill = this.isTransBill();
        Map checkResultMap = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])this.getMaterielIsolateResultHandle()).checkData((List)entryRows, billEntity.getDataEntityType().getName(), "billentry.material.masterid");
        for (int entryRowIdx = 0; entryRowIdx < entryRows.size(); ++entryRowIdx) {
            DynamicObject entryRow = (DynamicObject)entryRows.get(entryRowIdx);
            Map idKeyMap = (Map)checkResultMap.get(entryRowIdx);
            DynamicObject materialInv = entryRow.getDynamicObject("material");
            if (null == materialInv) continue;
            DynamicObject material = materialInv.getDynamicObject("masterid");
            Long matId = (Long)material.getPkValue();
            if (idKeyMap != null && idKeyMap.containsKey(matId) && !((Boolean)idKeyMap.get(matId)).booleanValue()) {
                String msg = ResManager.loadKDString((String)"{0}\u7b2c{1}\u884c\uff0c\u7269\u6599\uff1a{2}\uff08{3}\uff09\u4e0d\u5728\u5e93\u7ba1\u5458\uff08\u7ec4\u3001\u90e8\u95e8\uff09\u7ba1\u7406\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u201c\u5e93\u7ba1\u5458-\u7269\u6599\u5173\u7cfb\u8bbe\u7f6e\u201d\u3002", (String)"IM-E-576154", (String)"scmc-im-opplugin", (Object[])new Object[]{entryDisplayName, String.valueOf(entryRowIdx + 1), material.getString("number"), material.getString("name")});
                this.addMessage(entity, msg, ErrorLevel.Error);
            }
            if (!isTransBill) continue;
            this.checkMaterielIsolateWithSubEntity(entity, entryRowIdx, entryRow);
        }
    }

    private void checkMaterielIsolateWithSubEntity(ExtendedDataEntity entity, Integer entryRowIdx, DynamicObject entryRow) {
        String entryDisplayName = entryRow.getDataEntityType().getDisplayName().getLocaleValue();
        DynamicObjectCollection subEntryRows = entryRow.getDynamicObjectCollection("afterentity");
        String subEntryDisplayName = subEntryRows.getDynamicObjectType().getDisplayName().getLocaleValue();
        Map checkResultMap = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])this.getMaterielIsolateResultHandle()).checkData((List)subEntryRows, this.entityKey, "billentry.afterentity.material1.masterid");
        for (int subEntryRowIdx = 0; subEntryRowIdx < subEntryRows.size(); ++subEntryRowIdx) {
            DynamicObject subEntryRow = (DynamicObject)subEntryRows.get(subEntryRowIdx);
            Map idKeyMap = (Map)checkResultMap.get(subEntryRowIdx);
            DynamicObject materialInv = subEntryRow.getDynamicObject("material");
            if (null == materialInv) continue;
            DynamicObject material = materialInv.getDynamicObject("masterid");
            Long matId = (Long)material.getPkValue();
            if (idKeyMap == null || !idKeyMap.containsKey(matId) || ((Boolean)idKeyMap.get(matId)).booleanValue()) continue;
            String msg = ResManager.loadKDString((String)"{0}\u7b2c{1}\u884c\u7684{2}\u7b2c{3}\u884c\uff0c\u7269\u6599\uff1a{4}\uff08{5}\uff09\u4e0d\u5728\u5e93\u7ba1\u5458\uff08\u7ec4\u3001\u90e8\u95e8\uff09\u7ba1\u7406\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u201c\u5e93\u7ba1\u5458-\u7269\u6599\u5173\u7cfb\u8bbe\u7f6e\u201d\u3002", (String)"IM-E-883677", (String)"scmc-im-opplugin", (Object[])new Object[]{entryDisplayName, String.valueOf(entryRowIdx + 1), subEntryDisplayName, String.valueOf(subEntryRowIdx + 1), material.getString("number"), material.getString("name")});
            this.addMessage(entity, msg, ErrorLevel.Error);
        }
    }

    private void loadParamMap() {
        String operateKey = this.getOperateKey();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add(org.getLong("id"));
            this.materialIsolateMap.put(org.getLong("id"), false);
        }
        Map batchAppParameters = ParameterReader.loadBatchSystemParameterByOrgFromCache((AppParam)new AppParam(null, "=9Q86DR2P+Q", "05", new ArrayList(orgIds), Long.valueOf(0L), Long.valueOf(0L)));
        if (batchAppParameters == null || batchAppParameters.isEmpty()) {
            return;
        }
        for (Map.Entry batchAppParameter : batchAppParameters.entrySet()) {
            String orgId = (String)batchAppParameter.getKey();
            Map parameters = (Map)batchAppParameter.getValue();
            if (parameters == null) continue;
            if (parameters.containsKey("fmeterialscope")) {
                String materialScope = parameters.getOrDefault("fmeterialscope", "0");
                this.materialScopeMap.put(Long.valueOf(orgId), materialScope);
            }
            if (!"submit".equals(operateKey) || !parameters.containsKey("fmaterialisolate")) continue;
            Boolean materialIsolate = parameters.getOrDefault("fmaterialisolate", Boolean.FALSE);
            this.materialIsolateMap.put(Long.valueOf(orgId), materialIsolate);
        }
    }

    private void checkMaterialScope(ExtendedDataEntity entity) {
        DynamicObject billEntity = entity.getDataEntity();
        Long orgId = billEntity.getLong("org.id");
        String level = (String)this.materialScopeMap.getOrDefault(orgId, "0");
        if ("0".equals(level)) {
            return;
        }
        boolean isTrans = this.isTransBill();
        DynamicObjectCollection entryRows = billEntity.getDynamicObjectCollection("billentry");
        String entryDisplayName = entryRows.getDynamicObjectType().getDisplayName().getLocaleValue();
        Map entryIdMap = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])this.getMaterielScopeResultHandle()).checkData((List)entryRows, billEntity.getDataEntityType().getName(), "billentry.material.masterid");
        for (int entryRowIdx = 0; entryRowIdx < entryRows.size(); ++entryRowIdx) {
            DynamicObject entryRow = (DynamicObject)entryRows.get(entryRowIdx);
            Map idMap = (Map)entryIdMap.get(entryRowIdx);
            DynamicObject materialInv = entryRow.getDynamicObject("material");
            if (null == materialInv) continue;
            DynamicObject material = materialInv.getDynamicObject("masterid");
            Long matId = (Long)material.getPkValue();
            if (idMap != null && idMap.containsKey(matId) && !((Boolean)idMap.get(matId)).booleanValue()) {
                String msg = ResManager.loadKDString((String)"{0}\u7b2c{1}\u884c\uff0c\u7269\u6599\uff1a{2}\uff08{3}\uff09\u672a\u5728\u5bf9\u5e94\u4ed3\u5e93\u4e2d\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u201c\u4ed3\u5e93\u8bbe\u7f6e\u201d\u3002", (String)"IM-E-286423", (String)"scmc-im-opplugin", (Object[])new Object[]{entryDisplayName, String.valueOf(entryRowIdx + 1), material.getString("number"), material.getString("name")});
                if ("2".equals(level)) {
                    this.addMessage(entity, msg, ErrorLevel.Error);
                } else if ("1".equals(level)) {
                    this.addMessage(entity, msg, ErrorLevel.Warning);
                }
            }
            if (!isTrans) continue;
            this.checkMaterielScopeWithSubEntity(entity, entryRowIdx, entryRow, level);
        }
    }

    private void checkMaterielScopeWithSubEntity(ExtendedDataEntity entity, Object entryRowIdx, DynamicObject entryRow, String level) {
        String entryDisplayName = entryRow.getDataEntityType().getDisplayName().getLocaleValue();
        DynamicObjectCollection subEntryRows = entryRow.getDynamicObjectCollection("afterentity");
        String subEntryName = subEntryRows.getDynamicObjectType().getDisplayName().getLocaleValue();
        Map checkResultMap = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])this.getMaterielScopeResultHandle()).checkData((List)subEntryRows, this.entityKey, "billentry.afterentity.material1.masterid");
        Integer subEntryRowIdx = 0;
        while (subEntryRowIdx < subEntryRows.size()) {
            DynamicObject subEntryRow = (DynamicObject)subEntryRows.get(subEntryRowIdx.intValue());
            Map idKeyMap = (Map)checkResultMap.get(subEntryRowIdx.longValue());
            DynamicObject materialInv = subEntryRow.getDynamicObject("material1");
            if (null != materialInv) {
                DynamicObject material = materialInv.getDynamicObject("masterid");
                Long matId = (Long)material.getPkValue();
                if (idKeyMap != null && idKeyMap.containsKey(matId) && !((Boolean)idKeyMap.get(matId)).booleanValue()) {
                    String msg = ResManager.loadKDString((String)"{0}\u7b2c{1}\u884c\u7684{2}\u7b2c{3}\u884c\uff0c\u7269\u6599\uff1a{4}\uff08{5}\uff09\u672a\u5728\u5bf9\u5e94\u4ed3\u5e93\u4e2d\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u201c\u4ed3\u5e93\u8bbe\u7f6e\u201d\u3002", (String)"IM-E-805472", (String)"scmc-im-opplugin", (Object[])new Object[]{entryDisplayName, entryRowIdx, subEntryName, String.valueOf(subEntryRowIdx + 1), material.getString("number"), material.getString("name")});
                    if ("2".equals(level)) {
                        this.addMessage(entity, msg, ErrorLevel.Error);
                    } else if ("1".equals(level)) {
                        this.addMessage(entity, msg, ErrorLevel.Warning);
                    }
                }
            }
            Integer n = subEntryRowIdx;
            Integer n2 = subEntryRowIdx = Integer.valueOf(subEntryRowIdx + 1);
        }
    }

    private DataCtrlSchemeResultHandle[] getMaterielScopeResultHandle() {
        if ("im_invinspectbill".equals(this.entityKey)) {
            return new DataCtrlSchemeResultHandle[]{new MaterielScopeResultHandle(false), new QualifiedMaterielScopeResultHandle(false), new UnQualifiedMaterielScopeResultHandle(false)};
        }
        return new DataCtrlSchemeResultHandle[]{new MaterielScopeResultHandle(false)};
    }

    private DataCtrlSchemeResultHandle[] getMaterielIsolateResultHandle() {
        if ("im_invinspectbill".equals(this.entityKey)) {
            return new DataCtrlSchemeResultHandle[]{new MaterielIsolateResultHandle(), new QualifiedMaterielIsolateResultHandle(), new UnQualifiedMaterielIsolateResultHandle()};
        }
        return new DataCtrlSchemeResultHandle[]{new MaterielIsolateResultHandle()};
    }
}

