/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.WarehouseIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.WarehousePeopleScopeResultHandle;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class WarehouseOperatorValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(WarehouseOperatorValidator.class);
    private Map<String, List<String>> extValidateWarehouseFields = new HashMap<String, List<String>>(4);
    private Map<String, Set<Long>> allAllowWhIdSet = new HashMap<String, Set<Long>>(4);

    public WarehouseOperatorValidator() {
        this.initWarehouseValidateFields();
    }

    private void loadWarehouseIdSet(DynamicObject billEntity, DataCtrlSchemeResultHandle dataCtrlSchemeResultHandle, String ... warehouseFields) {
        for (String warehouseField : warehouseFields) {
            Set allowWhIdSet = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])new DataCtrlSchemeResultHandle[]{dataCtrlSchemeResultHandle}).getDataByDataCtrl(billEntity, this.entityKey, "billentry." + warehouseField);
            this.allAllowWhIdSet.put(warehouseField, allowWhIdSet);
        }
    }

    private Set<Long> getWarehouseIdSet(String warehouseField) {
        if (!this.allAllowWhIdSet.containsKey(warehouseField)) {
            warehouseField = "warehouse";
        }
        Set<Long> allowWhIdSet = this.allAllowWhIdSet.get(warehouseField);
        return allowWhIdSet;
    }

    private void initWarehouseValidateFields() {
        this.extValidateWarehouseFields.put("im_billtpl", Collections.singletonList("warehouse"));
        this.extValidateWarehouseFields.put("im_applybilltpl", Collections.singletonList("warehouse"));
        this.extValidateWarehouseFields.put("im_transformbilltpl", Collections.singletonList("warehouse"));
        this.extValidateWarehouseFields.put("im_locationtransfer", Collections.singletonList("warehouse"));
        this.extValidateWarehouseFields.put("im_invcountbill", Collections.singletonList("warehouse"));
        this.extValidateWarehouseFields.put("im_purinbill", Arrays.asList("warehouse", "outwarehouse"));
        this.extValidateWarehouseFields.put("im_ospurinbill", Arrays.asList("warehouse", "outwarehouse"));
        this.extValidateWarehouseFields.put("im_saloutbill", Arrays.asList("warehouse", "inwarehouse"));
        this.extValidateWarehouseFields.put("im_transdirbill", Collections.singletonList("warehouse"));
        this.extValidateWarehouseFields.put("im_invinspectbill", Arrays.asList("warehouse", "outwarehouse", "qualifiedwarehouse", "unqualifiedwarehouse"));
        this.extValidateWarehouseFields.put("im_mdc_ominbill", Arrays.asList("warehouse", "outwarehouse"));
        this.extValidateWarehouseFields.put("im_mdc_omcmplinbill", Arrays.asList("warehouse", "outwarehouse"));
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"WarehouseOperatorValidator", (String)"validate");){
            Map<String, Map<String, Object>> paramsMap = this.loadParam(this.dataEntities, "fpeoplescop");
            for (ExtendedDataEntity entity : this.dataEntities) {
                Object fwarehouseisolate;
                DynamicObject billEntity = entity.getDataEntity();
                Object fpeoplescop = this.getParam(paramsMap, billEntity, "fpeoplescop");
                if (null != fpeoplescop && !fpeoplescop.equals("0")) {
                    this.checkPeopleScope(entity, (String)fpeoplescop);
                }
                if (!Boolean.TRUE.equals(fwarehouseisolate = this.getParam(paramsMap, billEntity, "fwarehouseisolate"))) continue;
                this.checkWarehouseIsolate(entity);
            }
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5355\u636e\u5e93\u7ba1\u5458\u6821\u9a8c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private Object getParam(Map<String, Map<String, Object>> paramsMap, DynamicObject billEntity, String paramName) {
        String orgId = billEntity.getString("org.id");
        Map<String, Object> param = paramsMap.get(orgId);
        if (null != param) {
            return param.get(paramName);
        }
        return null;
    }

    private List<String> getWarehouseFields() {
        List<String> warehouseFields = this.extValidateWarehouseFields.get(this.entityKey);
        if (null == warehouseFields) {
            String entityType;
            List entityTypeList = InvBizDataCtrlHelper.getEntityTypeList((String)this.entityKey);
            Iterator iterator = entityTypeList.iterator();
            while (iterator.hasNext() && null == (warehouseFields = this.extValidateWarehouseFields.get(entityType = (String)iterator.next()))) {
            }
        }
        if (null == warehouseFields) {
            return Collections.emptyList();
        }
        return warehouseFields;
    }

    private void checkPeopleScope(ExtendedDataEntity entity, String controlLevel) {
        DynamicObject billEntity = entity.getDataEntity();
        DynamicObject operator = billEntity.getDynamicObject("operator");
        if (null == operator) {
            return;
        }
        String operatorStringName = operator.getString("operatorname");
        DynamicObjectCollection entryRows = billEntity.getDynamicObjectCollection("billentry");
        if (entryRows.isEmpty()) {
            return;
        }
        List<String> warehouseFields = this.getWarehouseFields();
        if (warehouseFields.isEmpty()) {
            return;
        }
        boolean isTransBill = this.isTransBill();
        this.loadWarehouseIdSet(billEntity, (DataCtrlSchemeResultHandle)new WarehousePeopleScopeResultHandle(false), "warehouse");
        for (int i = 0; i < entryRows.size(); ++i) {
            String beforeRowIdx = String.valueOf(i + 1);
            DynamicObject entryRow = (DynamicObject)entryRows.get(i);
            for (String warehouseField : warehouseFields) {
                Set<Long> allowWhIdSet;
                DynamicObject warehouseDym = entryRow.getDynamicObject(warehouseField);
                if (this.existWarehouse(warehouseDym, allowWhIdSet = this.getWarehouseIdSet(warehouseField))) continue;
                String warehouseName = warehouseDym.getString("name");
                String entryName = entryRow.getDataEntityType().getDisplayName().getLocaleValue();
                ErrorCode errCode = new InvBillErrorCode().getERROR_WAREHOUSESET_OPERATOR(entryName, beforeRowIdx, warehouseName, operatorStringName);
                String msg = errCode.getMessage();
                if ("2".equals(controlLevel)) {
                    this.addMessage(entity, msg, ErrorLevel.Error);
                    continue;
                }
                if (!"1".equals(controlLevel)) continue;
                this.addMessage(entity, msg, ErrorLevel.Warning);
            }
            if (!isTransBill) continue;
            this.checkPeopleScopeWithSubEntity(entity, entryRow, beforeRowIdx, warehouseFields, operatorStringName, controlLevel);
        }
    }

    private void checkWarehouseIsolate(ExtendedDataEntity entity) {
        DynamicObject billEntity = entity.getDataEntity();
        DynamicObjectCollection entryRows = billEntity.getDynamicObjectCollection("billentry");
        if (entryRows.isEmpty()) {
            return;
        }
        List<String> warehouseFields = this.getWarehouseFields();
        if (warehouseFields.isEmpty()) {
            return;
        }
        boolean isTransBill = this.isTransBill();
        this.loadWarehouseIdSet(billEntity, (DataCtrlSchemeResultHandle)new WarehouseIsolateResultHandle(), "warehouse");
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entryRows.get(i);
            for (String warehouseField : warehouseFields) {
                DynamicObject warehouseDym = entryRow.getDynamicObject(warehouseField);
                String beforeRowIdx = String.valueOf(i + 1);
                Set<Long> allowWhIdSet = this.getWarehouseIdSet(warehouseField);
                if (!this.existWarehouse(warehouseDym, allowWhIdSet)) {
                    String warehouseName = warehouseDym.getString("name");
                    String entryName = entryRow.getDataEntityType().getDisplayName().getLocaleValue();
                    ErrorCode errCode = new InvBillErrorCode().getERROR_WAREHOUSESET_ISOLATE_OPERATOR(entryName, beforeRowIdx, warehouseName);
                    String msg = errCode.getMessage();
                    this.addErrorMessage(entity, msg);
                }
                if (!isTransBill) continue;
                this.checkWarehouseIsolateWithSubEntity(entity, entryRow, beforeRowIdx, warehouseFields);
            }
        }
    }

    private boolean isTransBill() {
        String entityName = this.entityKey;
        return entityName.equals("im_assembbill") || entityName.equals("im_disassemblebill") || entityName.equals("im_adjustbill");
    }

    private void checkPeopleScopeWithSubEntity(ExtendedDataEntity entity, DynamicObject entryRow, String beforeRowIdx, List<String> warehouseFields, String operatorStringName, String controlLevel) {
        DynamicObjectCollection afterEntryRows = entryRow.getDynamicObjectCollection("afterentity");
        if (afterEntryRows.isEmpty()) {
            return;
        }
        String entryName = entryRow.getDataEntityType().getDisplayName().getLocaleValue();
        for (int subEntryIdx = 0; subEntryIdx < afterEntryRows.size(); ++subEntryIdx) {
            DynamicObject afterEntryRow = (DynamicObject)afterEntryRows.get(subEntryIdx);
            for (String warehouseField : warehouseFields) {
                Set<Long> allowWhIdSet;
                DynamicObject warehouseDym = afterEntryRow.getDynamicObject(warehouseField + "1");
                if (this.existWarehouse(warehouseDym, allowWhIdSet = this.getWarehouseIdSet(warehouseField))) continue;
                String afterRowIdx = String.valueOf(subEntryIdx + 1);
                String warehouseName = warehouseDym.getString("name");
                ErrorCode errCode = new InvBillErrorCode().getERROR_SUBENTITY_WAREHOUSESET_OPERATOR(entryName, beforeRowIdx, afterEntryRow.getDataEntityType().getDisplayName().getLocaleValue(), afterRowIdx, warehouseName, operatorStringName);
                String msg = errCode.getMessage();
                if ("2".equals(controlLevel)) {
                    this.addMessage(entity, msg, ErrorLevel.Error);
                    continue;
                }
                if (!"1".equals(controlLevel)) continue;
                this.addMessage(entity, msg, ErrorLevel.Warning);
            }
        }
    }

    private boolean existWarehouse(DynamicObject warehouseDym, Set<Long> allowWhIdSet) {
        if (null == warehouseDym) {
            return true;
        }
        if (CollectionUtils.isEmpty(allowWhIdSet)) {
            return true;
        }
        return allowWhIdSet.contains((Long)warehouseDym.getPkValue());
    }

    private void checkWarehouseIsolateWithSubEntity(ExtendedDataEntity entity, DynamicObject entryRow, String beforeRowIdx, List<String> warehouseFields) {
        DynamicObjectCollection afterEntryRows = entryRow.getDynamicObjectCollection("afterentity");
        String entryName = entryRow.getDataEntityType().getDisplayName().getLocaleValue();
        for (int i = 0; i < afterEntryRows.size(); ++i) {
            DynamicObject afterEntryRow = (DynamicObject)afterEntryRows.get(i);
            for (String warehouseField : warehouseFields) {
                Set<Long> allowWhIdSet;
                DynamicObject warehouseDym = afterEntryRow.getDynamicObject(warehouseField + "1");
                if (CommonUtils.isNull((Object)warehouseDym) || this.existWarehouse(warehouseDym, allowWhIdSet = this.getWarehouseIdSet(warehouseField))) continue;
                String afterRowIdx = String.valueOf(i + 1);
                String warehouseName = warehouseDym.getString("name");
                ErrorCode errCode = new InvBillErrorCode().getERROR_SUBENTITY_WAREHOUSESET_ISOLATE_OPERATOR(entryName, beforeRowIdx, afterEntryRow.getDataEntityType().getDisplayName().getLocaleValue(), afterRowIdx, warehouseName);
                String msg = errCode.getMessage();
                this.addErrorMessage(entity, msg);
            }
        }
    }

    private Map<String, Map<String, Object>> loadParam(ExtendedDataEntity[] dataEntities, String key) {
        if (null == dataEntities) {
            return Collections.emptyMap();
        }
        List orgIds = Stream.of(dataEntities).map(item -> item.getDataEntity().getLong("org.id")).distinct().collect(Collectors.toList());
        return AppParameterHelper.getBatchAppParameterByFormId((String)this.entityKey, orgIds);
    }
}

