/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.transbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.enums.StatusEnum;
import kd.scmc.im.utils.QFBuilder;

public class InvApplyBillCloseValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("lotnumber");
        return set;
    }

    public void validate() {
        String entityKey = this.getEntityKey();
        ArrayList<Object> pkIds = new ArrayList<Object>(this.dataEntities.length);
        HashMap<Object, ExtendedDataEntity> entityMap = new HashMap<Object, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object pk = dataEntity.getDataEntity().getPkValue();
            pkIds.add(pk);
            entityMap.put(pk, dataEntity);
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("billentry.srcbillentity", "=", (Object)entityKey);
        qfBuilder.add("billentry.srcbillid", "in", pkIds);
        qfBuilder.add("billstatus", "in", Arrays.asList(StatusEnum.SAVE.getValue(), StatusEnum.SUBMIT.getValue()));
        Map transDirMap = BusinessDataServiceHelper.loadFromCache((String)"im_transdirbill", (String)"id, billentry.srcbillid", (QFilter[])qfBuilder.toArray());
        Map transOutMap = BusinessDataServiceHelper.loadFromCache((String)"im_transoutbill", (String)"id, billentry.srcbillid", (QFilter[])qfBuilder.toArray());
        HashMap targetBills = new HashMap(this.dataEntities.length);
        targetBills.putAll(transDirMap);
        targetBills.putAll(transOutMap);
        if (targetBills.size() == 0) {
            return;
        }
        HashSet<Object> srcIds = new HashSet<Object>(this.dataEntities.length);
        for (DynamicObject bill : transOutMap.values()) {
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("billentry");
            if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) continue;
            Object srcBillId = ((DynamicObject)dynamicObjectCollection.get(0)).get("srcbillid");
            srcIds.add(srcBillId);
        }
        if (srcIds.size() == 0) {
            return;
        }
        String loadKDString = ResManager.loadKDString((String)"\u5b58\u5728\u6682\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5173\u95ed\u3002", (String)"InvApplyBillCloseValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        for (Object e : srcIds) {
            if (e == null || entityMap.get(e) == null) continue;
            this.addErrorMessage((ExtendedDataEntity)entityMap.get(e), loadKDString);
        }
    }
}

