/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.transbill;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TransApplyBillStatusValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("mainbillid");
        set.add("mainbillentity");
        return set;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Object, Set> srcIdToEntityMapping = new HashMap<Object, Set>(dataEntities.length);
        HashSet<Object> mainBillIds = new HashSet<Object>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entries;
            Object isVirtualBill = dataEntity.getValue("isvirtualbill");
            if (isVirtualBill != null && ((Boolean)isVirtualBill).booleanValue() || (entries = dataEntity.getDataEntity().getDynamicObjectCollection("billentry")) == null || entries.size() == 0) continue;
            DynamicObject entry = (DynamicObject)entries.get(0);
            String mainBillEntity = entry.getString("mainbillentity");
            Object mainBillId = entry.get("mainbillid");
            if (mainBillId == null || !"im_transapply".equals(mainBillEntity)) continue;
            Set set = srcIdToEntityMapping.computeIfAbsent(mainBillId, key -> new HashSet());
            set.add(dataEntity);
            mainBillIds.add(mainBillId);
        }
        Map transApplyBillMap = BusinessDataServiceHelper.loadFromCache((String)"im_transapply", (String)"id,billstatus", (QFilter[])new QFilter("id", "in", mainBillIds).toArray());
        for (Map.Entry objectEntry : transApplyBillMap.entrySet()) {
            Object srcBillId = objectEntry.getKey();
            DynamicObject bill = (DynamicObject)objectEntry.getValue();
            Object billStatus = bill.get("billstatus");
            if (!"D".equals(billStatus)) continue;
            Set extendedDataEntities = (Set)srcIdToEntityMapping.get(srcBillId);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                Object billNo = dataEntity.get("billno");
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u6765\u6e90\u7684\u8c03\u62e8\u7533\u8bf7\u5355\u5df2\u5173\u95ed\uff0c\u8bf7\u53cd\u5173\u95ed\u540e\u64cd\u4f5c\u3002", (String)"TransApplyBillStatusValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo);
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }
}

