/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.transbill;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class TransApplySaveValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("lotnumber");
        set.add("producedate");
        set.add("expirydate");
        set.add("ownertype");
        set.add("inownertype");
        set.add("invtype");
        set.add("warehouse");
        set.add("inwarehouse");
        set.add("inowner");
        set.add("owner");
        set.add("transtype");
        set.add("outorg");
        set.add("inorg");
        set.add("material");
        return set;
    }

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkEntry(entity);
            this.lotNumValidator(entity);
            this.shelfLifeDateValidator(entity);
            this.checkSupplierOwnerType(entity);
        }
    }

    private void checkSupplierOwnerType(ExtendedDataEntity dataEntity) {
        DynamicObject billEntity = dataEntity.getDataEntity();
        DynamicObject bizType = billEntity.getDynamicObject("biztype");
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject row : col) {
            String msg;
            if (bizType == null || !"6".equals(bizType.get("domain"))) continue;
            String ownerType = row.getString("ownertype");
            String inOwnerType = row.getString("inownertype");
            DynamicObject invType = row.getDynamicObject("invtype");
            if (!"bd_supplier".equals(ownerType) || !"bos_org".equals(inOwnerType)) {
                msg = ResManager.loadKDString((String)"VMI\u4e1a\u52a1\u7c7b\u578b\u4ec5\u80fd\u8c03\u51fa\u8d27\u4e3b\u4e3a\u4f9b\u5e94\u5546\u53ca\u8c03\u5165\u8d27\u4e3b\u4e3a\u6838\u7b97\u7ec4\u7ec7\u7684\u5e93\u5b58\uff0c\u8bf7\u4fee\u6539\u4e1a\u52a1\u7c7b\u578b\u6216\u8d27\u4e3b\u7c7b\u578b\u3002", (String)"TransApplySaveValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
            }
            if (invType != null && "113".equals(invType.getString("number"))) continue;
            msg = ResManager.loadKDString((String)"VMI\u4e1a\u52a1\u7c7b\u578b\u4ec5\u80fd\u8c03\u51fa\u5e93\u5b58\u7c7b\u578b\u4e3aVMI\u7684\u5e93\u5b58\uff0c\u8bf7\u4fee\u6539\u4e1a\u52a1\u7c7b\u578b\u6216\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b\u3002", (String)"TransApplySaveValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg, ErrorLevel.Error);
        }
    }

    private void lotNumValidator(ExtendedDataEntity dataEntity) {
        DynamicObject billEntity = dataEntity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject row : col) {
            String lotNum = row.getString("lotnumber");
            if (row.getBoolean("material.enablelot")) {
                if (StringUtils.isEmpty((CharSequence)(lotNum = lotNum.replaceAll("\u3000", " ").trim()))) continue;
                row.set("lotnumber", (Object)lotNum);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)(lotNum = lotNum.replaceAll("\u3000", " ").trim()))) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c\u6279\u53f7\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"TransApplySaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, String.format(msg, row.getInt("seq")), ErrorLevel.Error);
        }
    }

    private void shelfLifeDateValidator(ExtendedDataEntity dataEntity) {
        DynamicObject billEntity = dataEntity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        int count = 0;
        for (DynamicObject row : col) {
            Date produceDate = row.getDate("producedate");
            Date expiryDate = row.getDate("expirydate");
            DynamicObject materialInvInfo = row.getDynamicObject("material");
            if (materialInvInfo == null || materialInvInfo.getBoolean("enableshelflifemgr") || produceDate == null && expiryDate == null) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u201c\u751f\u4ea7\u65e5\u671f\u201d\u548c\u201c\u5230\u671f\u65e5\u671f\u201d\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"TransApplySaveValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, String.format(msg, row.getInt("seq")), ErrorLevel.Error);
            if (++count < 1000) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5931\u8d25\u4fe1\u606f\u8fc7\u591a\uff0c\u65e0\u6cd5\u5c55\u793a\uff0c\u5efa\u8bae\u5148\u5904\u7406\u73b0\u5728\u7684\u5931\u8d25\u539f\u56e0\u3002", (String)"TransApplySaveValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            break;
        }
    }

    private void checkEntry(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection adjCol = bill.getDynamicObjectCollection("billentry");
        if (CommonUtils.isNull((Object)adjCol) || adjCol.size() == 0) {
            return;
        }
        this.checkWarehouse(entity);
        this.checkOrg(entity);
    }

    private void checkOrg(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        String transType = bill.getString("transtype");
        HashSet<Integer> errIndex = new HashSet<Integer>();
        for (int i = 0; i < entry.size(); ++i) {
            if (!"B".equals(transType)) continue;
            DynamicObject outOrg = ((DynamicObject)entry.get(i)).getDynamicObject("outorg");
            DynamicObject inOrg = ((DynamicObject)entry.get(i)).getDynamicObject("inorg");
            if (inOrg == null || outOrg == null || !inOrg.getPkValue().equals(outOrg.getPkValue())) continue;
            errIndex.add(i + 1);
        }
        if (errIndex.size() > 0) {
            ErrorCode err = new InvBillErrorCode().getERROR_TRANSINOUT_ORG();
            String msg = String.format(err.getMessage(), errIndex);
            this.addMessage(entity, msg);
        }
    }

    private void checkWarehouse(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        String transType = bill.getString("transtype");
        HashSet<Integer> errIndex = new HashSet<Integer>();
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entry.get(i);
            if (!"A".equals(transType)) continue;
            DynamicObject outWh = entryRow.getDynamicObject("warehouse");
            DynamicObject inWh = entryRow.getDynamicObject("inwarehouse");
            DynamicObject inOwner = entryRow.getDynamicObject("inowner");
            DynamicObject outOwner = entryRow.getDynamicObject("owner");
            if (CommonUtils.isNull((Object)outWh) || CommonUtils.isNull((Object)inWh) || !outWh.getPkValue().equals(inWh.getPkValue()) || CommonUtils.isNull((Object)inOwner) || CommonUtils.isNull((Object)outOwner) || !inOwner.getPkValue().equals(outOwner.getPkValue())) continue;
            errIndex.add(i + 1);
        }
        if (errIndex.size() > 0) {
            ErrorCode errCode = new InvBillErrorCode().getERROR_TRANSAPPLY_WAREHOUSE();
            String msg = String.format(errCode.getMessage(), errIndex);
            this.addMessage(entity, msg);
        }
    }
}

