/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.transbill;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.WarehouseIsolateResultHandle;
import kd.scmc.im.errorcode.InvBillErrorCode;

public class TransApplyWarehouseOperatorValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(TransApplyWarehouseOperatorValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"TransApplyWarehouseOperatorValidator", (String)"validate");){
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject billEntity = entity.getDataEntity();
                DynamicObject org = billEntity.getDynamicObject("org");
                if (org == null) continue;
                this.checkWarehouseIsolate(entity, "warehouse");
                this.checkWarehouseIsolate(entity, "inwarehouse");
            }
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5355\u636e\u4ed3\u5e93\u8303\u56f4\u6821\u9a8c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void checkWarehouseIsolate(ExtendedDataEntity entity, String warehouseField) {
        DynamicObject billEntity = entity.getDataEntity();
        DynamicObjectCollection entryRows = billEntity.getDynamicObjectCollection("billentry");
        Map checkResultMap = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])new DataCtrlSchemeResultHandle[]{new WarehouseIsolateResultHandle()}).checkData((List)entryRows, this.entityKey, "billentry." + warehouseField);
        for (int entryRowIdx = 0; entryRowIdx < entryRows.size(); ++entryRowIdx) {
            DynamicObject entryRow = (DynamicObject)entryRows.get(entryRowIdx);
            Map idKeyMap = (Map)checkResultMap.get(entryRowIdx);
            DynamicObject warehouseDym = entryRow.getDynamicObject(warehouseField);
            if (null == warehouseDym) continue;
            Long whId = (Long)warehouseDym.getPkValue();
            if (idKeyMap == null || !idKeyMap.containsKey(whId) || ((Boolean)idKeyMap.get(whId)).booleanValue()) continue;
            String beforeRowIdx = String.valueOf(entryRowIdx + 1);
            String warehouseName = warehouseDym.getString("name");
            String entryName = entryRow.getDataEntityType().getDisplayName().getLocaleValue();
            ErrorCode errCode = new InvBillErrorCode().getERROR_WAREHOUSESET_ISOLATE_OPERATOR(entryName, beforeRowIdx, warehouseName);
            String msg = errCode.getMessage();
            this.addErrorMessage(entity, msg);
        }
    }
}

