/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.transbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class TransDirBillSaveVaildator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkOrg(entity);
        }
    }

    private void checkOrg(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        String transType = bill.getString("transtype");
        if ("B".equals(transType)) {
            DynamicObject outOrg = bill.getDynamicObject("outorg");
            DynamicObject inOrg = bill.getDynamicObject("org");
            if (!CommonUtils.isNull((Object)inOrg) && !CommonUtils.isNull((Object)outOrg) && inOrg.getPkValue() == outOrg.getPkValue()) {
                this.showOrgErrMsg(entity, "outorg", "org");
            }
        }
    }

    private void showOrgErrMsg(ExtendedDataEntity entity, String outorg, String inorg) {
        MainEntityType mainEntityType = (MainEntityType)entity.getDataEntity().getDataEntityType();
        ErrorCode err = new InvBillErrorCode().getERROR_TRANSIN_ORG_SAME();
        IDataEntityProperty outorgProperty = mainEntityType.findProperty(outorg);
        IDataEntityProperty inorgProperty = mainEntityType.findProperty(inorg);
        String msg = String.format(err.getMessage(), outorgProperty.getDisplayName(), inorgProperty.getDisplayName());
        this.addMessage(entity, msg);
    }
}

