/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.transbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.scmc.im.errorcode.InvBillErrorCode;

public class TransDirBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkEntry(entity);
        }
    }

    private void checkEntry(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        String transType = bill.getString("transtype");
        DynamicObjectCollection adjCol = bill.getDynamicObjectCollection("billentry");
        if (adjCol == null || adjCol.size() == 0 || "B".equals(transType)) {
            return;
        }
        this.checkTrans(entity, adjCol);
    }

    private void checkTrans(ExtendedDataEntity entity, DynamicObjectCollection adjCol) {
        for (int i = 0; i < adjCol.size(); ++i) {
            boolean checkResult;
            DynamicObject entryRow = (DynamicObject)adjCol.get(i);
            DynamicObject outWh = entryRow.getDynamicObject("outwarehouse");
            DynamicObject inWh = entryRow.getDynamicObject("warehouse");
            DynamicObject outOwner = entryRow.getDynamicObject("outowner");
            DynamicObject inOwner = entryRow.getDynamicObject("owner");
            DynamicObject outInvStatus = entryRow.getDynamicObject("outinvstatus");
            DynamicObject invStatus = entryRow.getDynamicObject("invstatus");
            boolean bl = checkResult = outWh != null && inWh != null && outWh.getPkValue().equals(inWh.getPkValue()) && outOwner != null && inOwner != null && outOwner.getPkValue().equals(inOwner.getPkValue()) && outInvStatus != null && invStatus != null && outInvStatus.getPkValue().equals(invStatus.getPkValue());
            if (!Boolean.TRUE.equals(checkResult)) continue;
            ErrorCode errCode = new InvBillErrorCode().getERROR_TRANSINOUT_WAREHOUSE();
            String msg = String.format(errCode.getMessage(), i + 1);
            this.addMessage(entity, msg);
        }
    }
}

