/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.transbill;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class TransitVaildator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("invscheme");
        fields.add("transit");
        fields.add("transitownertype");
        fields.add("transitowner");
        return fields;
    }

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkTransit(entity);
        }
    }

    private void checkTransit(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        DynamicObject invScheme = data.getDynamicObject("invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        if (!isInUpdate || !isOutUpdate) {
            return;
        }
        String transit = data.getString("transit");
        if (StringUtils.isBlank((CharSequence)transit)) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u4e3a\u53cc\u65b9\u5411\u66f4\u65b0\uff0c\u5728\u9014\u5f52\u5c5e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransitVaildator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            DynamicObject transitOwner;
            String transitOwnerType = entry.getString("transitownertype");
            if (StringUtils.isBlank((CharSequence)transitOwnerType)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u4e3a\u53cc\u65b9\u5411\u66f4\u65b0\uff0c\u5728\u9014\u8d27\u4e3b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransitVaildator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            if ((transitOwner = entry.getDynamicObject("transitowner")) != null) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u4e3a\u53cc\u65b9\u5411\u66f4\u65b0\uff0c\u5728\u9014\u8d27\u4e3b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransitVaildator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }
}

