/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.business.bizgroup;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizGroupRecordCompletedHelper {
    public static void setBizGroupCompleted(Set<Long> transInBillIds, Set<Long> trueEntryIds, Set<Long> falseEntryIds) {
        if (transInBillIds == null || transInBillIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("entryentity.bizbillid", "in", transInBillIds);
        filter.and("entryentity.formid", "=", (Object)"im_transinbill");
        DynamicObject[] bizGroupRecords = BusinessDataServiceHelper.load((String)"im_bgrecord", (String)"id,iscompleted,type,formid,bizbillid,bizentryid,baseqty,islastentry,isdel,ischargeoffed", (QFilter[])filter.toArray());
        if (bizGroupRecords == null || bizGroupRecords.length == 0) {
            return;
        }
        for (DynamicObject bizGroupRecord : bizGroupRecords) {
            DynamicObjectCollection entry = bizGroupRecord.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entry) {
                Long entryId = dynamicObject.getLong("bizentryid");
                if (trueEntryIds != null && trueEntryIds.contains(entryId)) {
                    dynamicObject.set("islastentry", (Object)Boolean.TRUE);
                    continue;
                }
                if (falseEntryIds == null || !falseEntryIds.contains(entryId)) continue;
                dynamicObject.set("islastentry", (Object)Boolean.FALSE);
            }
            BizGroupRecordCompletedHelper.resolveGroupRecordComplted(bizGroupRecord);
        }
        SaveServiceHelper.save((DynamicObject[])bizGroupRecords);
    }

    public static void setBizGroupCompleted4Chargeoff(Set<Long> trueIds, Set<Long> falseIds) {
        HashSet<Long> allBillIds = new HashSet<Long>(4);
        if (trueIds != null && !trueIds.isEmpty()) {
            allBillIds.addAll(trueIds);
        }
        if (falseIds != null && !falseIds.isEmpty()) {
            allBillIds.addAll(falseIds);
        }
        if (allBillIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("entryentity.bizbillid", "in", allBillIds);
        DynamicObject[] bizGroupRecords = BusinessDataServiceHelper.load((String)"im_bgrecord", (String)"id,iscompleted,type,formid,bizbillid,bizentryid,baseqty,islastentry,isdel,ischargeoffed", (QFilter[])filter.toArray());
        if (bizGroupRecords == null || bizGroupRecords.length == 0) {
            return;
        }
        for (DynamicObject bizGroupRecord : bizGroupRecords) {
            DynamicObjectCollection entry = bizGroupRecord.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entry) {
                Long entryId = dynamicObject.getLong("bizbillid");
                if (trueIds != null && trueIds.contains(entryId)) {
                    dynamicObject.set("ischargeoffed", (Object)Boolean.TRUE);
                }
                if (falseIds == null || !falseIds.contains(entryId)) continue;
                dynamicObject.set("ischargeoffed", (Object)Boolean.FALSE);
            }
            BizGroupRecordCompletedHelper.resolveGroupRecordComplted(bizGroupRecord);
        }
        SaveServiceHelper.save((DynamicObject[])bizGroupRecords);
    }

    public static void resolveGroupRecordComplted(DynamicObject groupRecord) {
        boolean iscompleted;
        DynamicObjectCollection entry = groupRecord.getDynamicObjectCollection("entryentity");
        BigDecimal srcQty = BigDecimal.ZERO;
        BigDecimal destQty = BigDecimal.ZERO;
        boolean destHasPos = false;
        boolean destHasNeg = false;
        boolean islastentry = false;
        boolean hasChargeOff = false;
        for (DynamicObject entryRow : entry) {
            boolean isDel = entryRow.getBoolean("isdel");
            String formid = entryRow.getString("formid.id");
            if (isDel) continue;
            boolean ischargeoffed = entryRow.getBoolean("ischargeoffed");
            String type = entryRow.getString("type");
            islastentry = islastentry || entryRow.getBoolean("islastentry");
            BigDecimal baseqty = entryRow.getBigDecimal("baseqty");
            if ("1".equals(type)) {
                if (baseqty.signum() > 0) {
                    destHasPos = true;
                } else if (baseqty.signum() < 0) {
                    destHasNeg = true;
                }
            }
            if ("1".equals(type) && ischargeoffed) {
                if (!"im_transinbill".equals(formid)) continue;
                hasChargeOff = true;
            }
            if ("0".equals(type)) {
                srcQty = srcQty.add(baseqty);
                continue;
            }
            if (!"1".equals(type)) continue;
            destQty = destQty.add(baseqty);
        }
        boolean bl = iscompleted = islastentry || destQty.abs().compareTo(srcQty.abs()) >= 0;
        if (destHasNeg && destHasPos) {
            iscompleted = false;
        }
        if (hasChargeOff) {
            iscompleted = false;
        }
        groupRecord.set("iscompleted", (Object)iscompleted);
    }
}

