/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.business.bizgroup;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.cal.business.bizgroup.BizGroupRecordHolder;
import kd.sdk.scmc.im.extpoint.IInvGroupBillExpand;

public class BizGroupRecordCreater {
    private static Log log = LogFactory.getLog(BizGroupRecordCreater.class);
    public static final String KEY_GROUPBILLENTRY = "groupbillentry";
    private static final String FINALSELECTFIELDS = "src_bizbillid,src_bizentryid,src_billno,src_bookdate,src_bizdate,src_material,src_owner,src_islastentry,src_ischargeoffed,src_baseqty,src_formid,dest_bizbillid,dest_bizentryid,dest_billno,dest_bookdate,dest_bizdate,dest_material,dest_owner,dest_islastentry,dest_ischargeoffed,dest_baseqty,dest_formid,";
    private Set<Long> bizbillids;
    private String entity;
    private List<Long> bizGroupSettingIdList = new ArrayList<Long>(4);
    private Map<Long, Set<DynamicObject>> currentBizGroupSettingEntryMap = new HashMap<Long, Set<DynamicObject>>(4);
    private Map<Long, Set<DynamicObject>> findBizGroupSettingEntrysMap = new HashMap<Long, Set<DynamicObject>>(4);
    private boolean isByDestBill;
    private String currentType;
    private String findType;
    private BizGroupRecordHolder holder = new BizGroupRecordHolder();

    public BizGroupRecordCreater(Set<Long> bizbillids, String entity, boolean isByDestBill) {
        this.bizbillids = new HashSet<Long>(bizbillids);
        this.entity = entity;
        this.isByDestBill = isByDestBill;
        if (isByDestBill) {
            this.currentType = "1";
            this.findType = "0";
        } else {
            this.currentType = "0";
            this.findType = "1";
        }
        this.initBizGroupSettings();
    }

    private void initBizGroupSettings() {
        DynamicObject[] settings;
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("grouptype", "=", (Object)"A");
        filter.and("groupbillentry.formid", "=", (Object)this.entity);
        filter.and("groupbillentry.type", "=", (Object)this.currentType);
        for (DynamicObject setting : settings = BusinessDataServiceHelper.load((String)"im_bizgroupsetting", (String)"id,number,name,type,formid.id,filterjson_tag,cfilterjson_tag,relfield,selfield,text2long", (QFilter[])filter.toArray(), (String)"priority")) {
            long settingId = setting.getLong("id");
            this.bizGroupSettingIdList.add(settingId);
            DynamicObjectCollection groupBillEntrys = setting.getDynamicObjectCollection(KEY_GROUPBILLENTRY);
            for (DynamicObject groupBillEntry : groupBillEntrys) {
                String type = groupBillEntry.getString("type");
                DynamicObject formid = groupBillEntry.getDynamicObject("formid");
                if (formid == null) continue;
                if (this.currentType.equals(type) && this.entity.equals(formid.getString("id"))) {
                    Set currentBizGroupSettingEntry = this.currentBizGroupSettingEntryMap.computeIfAbsent(settingId, k -> new HashSet(4));
                    currentBizGroupSettingEntry.add(groupBillEntry);
                    continue;
                }
                if (!this.findType.equals(type)) continue;
                Set findBizGroupSettingEntry = this.findBizGroupSettingEntrysMap.computeIfAbsent(settingId, k -> new HashSet(4));
                findBizGroupSettingEntry.add(groupBillEntry);
            }
        }
    }

    public Set<Long> createRecord() {
        log.info("\u5f00\u59cb\u6267\u884c\u751f\u6210\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55");
        if (this.bizbillids == null || this.bizbillids.isEmpty()) {
            return null;
        }
        PluginProxy extPluginProxy = PluginProxy.create(IInvGroupBillExpand.class, (String)"SCMC_IM_INV_GROUPBILL");
        Map<Long, IInvGroupBillExpand> pluginMap = this.getPluginMap((PluginProxy<IInvGroupBillExpand>)extPluginProxy);
        Lists.partition(new ArrayList<Long>(this.bizbillids), (int)1000).forEach(partList -> {
            HashSet<Long> curPartBizBillIds = new HashSet<Long>(1000);
            curPartBizBillIds.addAll((Collection<Long>)partList);
            for (Long bizGroupSettingId : this.bizGroupSettingIdList) {
                log.info("\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\uff1a" + bizGroupSettingId);
                Set<DynamicObject> currentBills = this.currentBizGroupSettingEntryMap.get(bizGroupSettingId);
                for (DynamicObject currentBill : currentBills) {
                    if (curPartBizBillIds.isEmpty()) break;
                    this.holder.setBizGroupSetting(bizGroupSettingId);
                    IInvGroupBillExpand plugin = (IInvGroupBillExpand)pluginMap.get(bizGroupSettingId);
                    if (plugin != null) {
                        Set<Long> curValidBizBillids = this.getCurVaildBizBillIds(curPartBizBillIds, currentBill);
                        if (curValidBizBillids.isEmpty()) continue;
                        DynamicObject findBill = this.findBizGroupSettingEntrysMap.get(bizGroupSettingId).iterator().next();
                        List<QFilter> billFilterlist = this.getFilterCFilters(findBill);
                        Set groupRecord = plugin.createGroupRecord(curValidBizBillids, billFilterlist, this.isByDestBill);
                        this.holder.addGroupRecord(groupRecord);
                    } else {
                        this.createRecordByStandard(curPartBizBillIds, bizGroupSettingId, currentBill);
                    }
                    curPartBizBillIds.removeAll(this.holder.getHasRecordBizBillIds());
                }
                log.info("\u7ed3\u675f\u6267\u884c\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\uff1a" + bizGroupSettingId);
            }
        });
        this.holder.saveRecord();
        log.info("\u7ed3\u675f\u4fdd\u5b58\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55");
        return this.holder.getHasRecordBizBillIds();
    }

    private Set<Long> getCurVaildBizBillIds(Set<Long> curPartBizBillIds, DynamicObject currentBill) {
        List<QFilter> billFilterlist = this.getFilterCFilters(currentBill);
        QFilter filter = new QFilter("id", "in", curPartBizBillIds);
        billFilterlist.add(filter);
        HashSet<Long> ids = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entity, (String)"id", (QFilter[])billFilterlist.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    private Map<Long, IInvGroupBillExpand> getPluginMap(PluginProxy<IInvGroupBillExpand> extPluginProxy) {
        HashMap<Long, IInvGroupBillExpand> map = new HashMap<Long, IInvGroupBillExpand>(4);
        List plugins = extPluginProxy.getPlugins();
        if (plugins == null || plugins.isEmpty()) {
            return map;
        }
        for (IInvGroupBillExpand plugin : plugins) {
            map.put(plugin.getSettingId(), plugin);
        }
        return map;
    }

    private void createRecordByStandard(Set<Long> curPartBizBillIds, Long bizGroupSettingId, DynamicObject currentBill) {
        DataSet currentBillDS = this.getCurrentBillDS(currentBill, curPartBizBillIds);
        String relfeldStr = currentBill.getString("relfield");
        if (StringUtils.isEmpty((String)relfeldStr)) {
            log.error("\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\uff1a" + bizGroupSettingId + "\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb");
            return;
        }
        CharSequence[] relfields = relfeldStr.split(",");
        this.holder.setRelfields((String[])relfields);
        ArrayList list = new ArrayList(4);
        for (int i = 0; i < relfields.length; ++i) {
            list.add(new HashSet(16));
        }
        boolean isEmpty = true;
        DataSet currentBillCopy = currentBillDS.copy();
        for (Row row : currentBillCopy) {
            isEmpty = false;
            for (int i = 0; i < relfields.length; ++i) {
                String relfield = relfields[i];
                Set values = (Set)list.get(i);
                values.add(row.get(relfield));
            }
        }
        if (isEmpty) {
            return;
        }
        Set<DynamicObject> findBizGroupSettingEntrys = this.findBizGroupSettingEntrysMap.get(bizGroupSettingId);
        boolean needCopy = findBizGroupSettingEntrys.size() > 1;
        for (DynamicObject findBill : findBizGroupSettingEntrys) {
            List<QFilter> billFilterlist = this.getFilterCFilters(findBill);
            String[] findFields = findBill.getString("relfield").split(",");
            List<String> text2longs = Arrays.asList(findBill.getString("text2long").split(","));
            for (int i = 0; i < findFields.length; ++i) {
                String findField = findFields[i];
                Set values = (Set)list.get(i);
                if (text2longs.contains(findField)) {
                    HashSet<Long> longIds = new HashSet<Long>(16);
                    for (Object object : values) {
                        if (object == null || !StringUtils.isNotEmpty((String)object.toString())) continue;
                        longIds.add(Long.valueOf(object.toString()));
                    }
                    billFilterlist.add(new QFilter(findField, "in", longIds));
                    continue;
                }
                billFilterlist.add(new QFilter(findField, "in", (Object)values));
            }
            String findBillEntity = findBill.getString("formid.id");
            String selectFields = findBill.getString("selfield");
            DataSet findBillDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)findBillEntity, (String)selectFields, (QFilter[])billFilterlist.toArray(new QFilter[0]), null);
            currentBillCopy = currentBillDS;
            if (needCopy) {
                currentBillCopy = currentBillDS.copy();
            }
            JoinDataSet join = currentBillCopy.join(findBillDS, JoinType.INNER);
            for (int i = 0; i < relfields.length; ++i) {
                join.on(relfields[i], findFields[i]);
            }
            DataSet finish = join.select((FINALSELECTFIELDS + String.join((CharSequence)",", relfields)).split(",")).finish();
            for (Row row : finish) {
                this.holder.addGroupRecord(row);
            }
        }
    }

    private DataSet getCurrentBillDS(DynamicObject currentBill, Set<Long> curPartBizBillIds) {
        List<QFilter> billFilterlist = this.getFilterCFilters(currentBill);
        QFilter filter = new QFilter("id", "in", curPartBizBillIds);
        billFilterlist.add(filter);
        String selectFields = currentBill.getString("selfield");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entity, (String)selectFields, (QFilter[])billFilterlist.toArray(new QFilter[0]), null);
        return dataSet;
    }

    private List<QFilter> getFilterCFilters(DynamicObject currentBill) {
        String filterjson_tag = currentBill.getString("filterjson_tag");
        String cfilterjson_tag = currentBill.getString("cfilterjson_tag");
        String entity = currentBill.getString("formid.id");
        ArrayList<QFilter> allFilters = new ArrayList<QFilter>(4);
        QFilter billFilter = this.getBillFilter(filterjson_tag, entity);
        QFilter cbillFilter = this.getBillFilter(cfilterjson_tag, entity);
        allFilters.add(billFilter);
        allFilters.add(cbillFilter);
        return allFilters;
    }

    private QFilter getBillFilter(String filterjson_tag, String entity) {
        if (StringUtils.isEmpty((String)filterjson_tag)) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterjson_tag, FilterCondition.class);
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }
}

